/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.ops.SVGElement;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.office.conv.StyleConverter;
import com.adobe.dp.office.conv.WordMLConverter;
import com.adobe.dp.office.types.RGBColor;
import com.adobe.dp.office.vml.VMLCoordPair;
import com.adobe.dp.office.vml.VMLElement;
import com.adobe.dp.office.vml.VMLGroupElement;
import com.adobe.dp.office.vml.VMLLineElement;
import com.adobe.dp.office.vml.VMLOvalElement;
import com.adobe.dp.office.vml.VMLPathConverter;
import com.adobe.dp.office.vml.VMLRectElement;
import com.adobe.dp.office.vml.VMLShadow;
import com.adobe.dp.office.vml.VMLShapeElement;
import com.adobe.dp.office.word.TXBXContentElement;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;

public class VMLConverter {
    private Publication epub;
    private OPSDocument chapter;
    private OPSResource resource;
    private WordMLConverter wordConverter;
    private StyleConverter styleConverter;
    private StyleResource styles;
    private boolean embedded;
    PrintWriter log;

    VMLConverter(WordMLConverter wordConverter, boolean embedded) {
        this.wordConverter = wordConverter;
        this.log = wordConverter.log;
        this.embedded = embedded;
        if (!embedded) {
            this.epub = wordConverter.getPublication();
            String name = this.epub.makeUniqueResourceName("OPS/media/vml-style.css");
            this.styles = this.epub.createStyleResource(name);
            Stylesheet stylesheet = this.styles.getStylesheet();
            this.styleConverter = new StyleConverter(stylesheet, true);
        }
    }

    void convertVML(OPSResource resource, SVGElement svg, VMLGroupElement group) {
        Hashtable style = group.getStyle();
        if (style == null) {
            return;
        }
        this.resource = resource;
        this.chapter = resource.getDocument();
        String widthStr = (String)style.get("width");
        String heightStr = (String)style.get("height");
        VMLCoordPair origin = group.getOrigin();
        VMLCoordPair size = group.getSize();
        float widthPt = VMLPathConverter.readCSSLength(widthStr, 100.0f);
        float heightPt = VMLPathConverter.readCSSLength(heightStr, 100.0f);
        if (!this.embedded) {
            StyleResource global = (StyleResource)this.epub.getResourceByName("OPS/global.css");
            this.chapter.addStyleResource(global);
            this.chapter.addStyleResource(this.styles);
            svg.setAttribute("width", Float.toString(widthPt));
            svg.setAttribute("height", Float.toString(heightPt));
        }
        float scaleX = (float)size.x / widthPt;
        float scaleY = (float)size.y / heightPt;
        svg.setAttribute("viewBox", String.valueOf(origin.x) + " " + origin.y + " " + size.x + " " + size.y);
        this.convertVMLChildren(svg, group, scaleX, scaleY);
    }

    private void convertVMLChildren(SVGElement svg, VMLElement vml, float scaleX, float scaleY) {
        Iterator it = vml.content();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof VMLElement)) continue;
            this.convertVMLChild(this.chapter, svg, (VMLElement)child, scaleX, scaleY);
        }
    }

    private void convertVMLChild(OPSDocument chapter, SVGElement parentSVG, VMLElement vml, float scaleX, float scaleY) {
        try {
            SVGElement childSVG = null;
            Hashtable style = vml.getStyle();
            if (style == null) {
                return;
            }
            String rotationStr = (String)style.get("rotation");
            float rotation = 0.0f;
            if (rotationStr != null) {
                try {
                    rotation = rotationStr.endsWith("fd") ? Float.parseFloat(rotationStr.substring(0, rotationStr.length() - 2)) / 65536.0f : Float.parseFloat(rotationStr);
                }
                catch (Exception e) {
                    e.printStackTrace(this.log);
                }
            }
            float top = VMLElement.getNumberValue(style, "top", 0.0f);
            float left = VMLElement.getNumberValue(style, "left", 0.0f);
            float width = VMLElement.getNumberValue(style, "width", 0.0f);
            float height = VMLElement.getNumberValue(style, "height", 0.0f);
            float cx = left + width / 2.0f;
            float cy = top + height / 2.0f;
            String flip = (String)style.get("flip");
            float[] textbox = null;
            if (!(vml instanceof VMLGroupElement)) {
                if (vml instanceof VMLShapeElement) {
                    childSVG = chapter.createSVGElement("path");
                    VMLPathConverter conv = new VMLPathConverter((VMLShapeElement)vml);
                    conv.setOuterSize(width, height);
                    conv.setScale(scaleX, scaleY);
                    conv.readFormulas();
                    String path = conv.getSVGPath();
                    childSVG.setAttribute("d", path);
                    textbox = conv.getTextBox();
                } else if (vml instanceof VMLRectElement) {
                    if (width > 0.0f && height > 0.0f) {
                        childSVG = chapter.createSVGElement("rect");
                        childSVG.setAttribute("x", Float.toString(-width / 2.0f));
                        childSVG.setAttribute("y", Float.toString(-height / 2.0f));
                        childSVG.setAttribute("width", Float.toString(width));
                        childSVG.setAttribute("height", Float.toString(height));
                    }
                } else if (vml instanceof VMLOvalElement) {
                    if (width > 0.0f && height > 0.0f) {
                        childSVG = chapter.createSVGElement("ellipse");
                        childSVG.setAttribute("rx", Float.toString(width / 2.0f));
                        childSVG.setAttribute("ry", Float.toString(height / 2.0f));
                    }
                } else if (vml instanceof VMLLineElement) {
                    VMLCoordPair from = ((VMLLineElement)vml).getFrom();
                    VMLCoordPair to = ((VMLLineElement)vml).getTo();
                    if (from != null && to != null) {
                        childSVG = chapter.createSVGElement("line");
                        childSVG.setAttribute("x1", Float.toString(from.x));
                        childSVG.setAttribute("y1", Float.toString(from.y));
                        childSVG.setAttribute("x2", Float.toString(to.x));
                        childSVG.setAttribute("y2", Float.toString(to.y));
                    }
                }
            }
            if (childSVG != null) {
                float opacity;
                RGBColor fill;
                boolean flipY;
                StringBuffer transform = new StringBuffer();
                boolean flipX = flip != null && flip.indexOf(120) >= 0;
                boolean bl = flipY = flip != null && flip.indexOf(121) >= 0;
                if (cx != 0.0f || cy != 0.0f) {
                    transform.append("translate(" + cx + "," + cy + ")");
                }
                if (rotation != 0.0f) {
                    transform.append("rotate(" + rotation + ")");
                }
                if (flipX || flipY) {
                    transform.append("scale(" + (flipX ? -1 : 1) + " " + (flipY ? -1 : 1) + ")");
                }
                VMLShadow shadow = vml.getShadow();
                if (transform.length() > 0) {
                    childSVG.setAttribute("transform", transform.toString());
                }
                childSVG.setAttribute("fill", (fill = vml.getFill()) != null ? fill.toCSSString() : "none");
                RGBColor stroke = vml.getStroke();
                if (stroke != null) {
                    float sw;
                    childSVG.setAttribute("stroke", stroke.toCSSString());
                    String sws = vml.getStrokeWeight();
                    if (sws != null && (sw = VMLPathConverter.readCSSLength(sws, 0.0f)) > 0.0f) {
                        childSVG.setAttribute("stroke-width", Float.toString(scaleX * sw));
                    }
                }
                if (shadow != null) {
                    SVGElement svgShadow = (SVGElement)childSVG.cloneElementShallow();
                    String shadowOffset = "translate(" + scaleX * shadow.getOffsetX() + "," + scaleY * shadow.getOffsetY() + ")";
                    svgShadow.setAttribute("transform", String.valueOf(shadowOffset) + transform);
                    svgShadow.setAttribute("fill", shadow.getColor().toCSSString());
                    if (stroke != null) {
                        svgShadow.setAttribute("stroke", shadow.getColor().toCSSString());
                    }
                    if (shadow.getOpacity() != 1.0f) {
                        svgShadow.setAttribute("opacity", Float.toString(shadow.getOpacity()));
                    }
                    parentSVG.add(svgShadow);
                }
                if ((opacity = vml.getOpacity()) != 1.0f) {
                    childSVG.setAttribute("opacity", Float.toString(opacity));
                }
                parentSVG.add(childSVG);
                TXBXContentElement textboxContent = vml.getTextBoxContentElement();
                if (textboxContent != null) {
                    if (textbox == null) {
                        textbox = vml.getTextBox();
                    }
                    if (textbox != null) {
                        SVGElement foreignObject = chapter.createSVGElement("foreignObject");
                        float scaleAdj = (float)Math.round(100.0f * scaleY) / 100.0f;
                        foreignObject.setAttribute("transform", transform + "scale(" + scaleAdj + " " + scaleAdj + ")");
                        foreignObject.setAttribute("x", Float.toString(textbox[0] / scaleY));
                        foreignObject.setAttribute("y", Float.toString(textbox[1] / scaleY));
                        foreignObject.setAttribute("width", Float.toString((textbox[2] - textbox[0]) / scaleY));
                        foreignObject.setAttribute("height", Float.toString((textbox[3] - textbox[1]) / scaleY));
                        parentSVG.add(foreignObject);
                        WordMLConverter wordConv = this.embedded ? new WordMLConverter(this.wordConverter, this.resource) : new WordMLConverter(this.wordConverter, this.styleConverter);
                        int depth = wordConv.pushOPSContainer(foreignObject);
                        wordConv.appendConvertedElement(textboxContent, null, null, 1.0f, 1);
                        wordConv.restoreOPSContainer(depth);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.log);
        }
    }
}

