/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.epub.style.BaseRule;
import com.adobe.dp.epub.style.CSSLength;
import com.adobe.dp.epub.style.PrototypeRule;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.office.conv.StylingResult;
import com.adobe.dp.office.types.BorderSide;
import com.adobe.dp.office.types.FontFamily;
import com.adobe.dp.office.types.Paint;
import com.adobe.dp.office.types.RGBColor;
import com.adobe.dp.office.word.BaseProperties;
import com.adobe.dp.office.word.NumberingLabel;
import com.adobe.dp.office.word.ParagraphProperties;
import com.adobe.dp.office.word.RunProperties;
import com.adobe.dp.office.word.Style;
import com.adobe.dp.office.word.TableProperties;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class StyleConverter {
    Stylesheet stylesheet;
    Style documentDefaultParagraphStyle;
    double defaultFontSize = 22.0;
    HashSet classNames = new HashSet();
    int styleCount = 1;
    boolean usingPX;
    private static final int RUN_COMPLEX = 1;
    private static final int RUN_STYLE = 2;
    private static final int RUN_BOLD = 4;
    private static final int RUN_ITALIC = 8;
    private static final int RUN_SUPER = 16;
    private static final int RUN_SUB = 32;

    StyleConverter(Stylesheet stylesheet, boolean usingPX) {
        this.stylesheet = stylesheet;
        this.usingPX = usingPX;
        this.classNames.add("primary");
        this.classNames.add("embed");
        this.classNames.add("nesting");
        this.classNames.add("footnote");
        this.classNames.add("footnote-ref");
        this.classNames.add("footnote-title");
    }

    StyleConverter(StyleConverter conv) {
        this(conv.stylesheet, true);
        this.classNames = conv.classNames;
    }

    void setDocumentDefaultParagraphStyle(Style documentDefaultParagraphStyle) {
        this.documentDefaultParagraphStyle = documentDefaultParagraphStyle;
    }

    boolean usingPX() {
        return this.usingPX;
    }

    void setDefaultFontSize(double defaultFontSize) {
        this.defaultFontSize = defaultFontSize;
    }

    private String findUniqueClassName(String base, boolean tryBase) {
        if (tryBase) {
            if (!this.classNames.contains(base)) {
                return base;
            }
            base = String.valueOf(base) + "-";
        }
        String name;
        while (this.classNames.contains(name = String.valueOf(base) + this.styleCount)) {
            ++this.styleCount;
        }
        return name;
    }

    String getUniqueClassName(String base, boolean tryBase) {
        String cname = this.findUniqueClassName(base, tryBase);
        this.classNames.add(cname);
        return cname;
    }

    private String mapToElement(String styleId) {
        if (styleId != null) {
            if (styleId.equals("Title")) {
                return "h1";
            }
            if (styleId.equals("Heading1")) {
                return "h1";
            }
            if (styleId.equals("Heading2")) {
                return "h2";
            }
            if (styleId.equals("Heading3")) {
                return "h3";
            }
            if (styleId.equals("Heading4")) {
                return "h4";
            }
            if (styleId.equals("Heading5")) {
                return "h5";
            }
            if (styleId.equals("Heading6")) {
                return "h6";
            }
        }
        return null;
    }

    private int getRunMask(RunProperties rp) {
        int result = 0;
        if (rp == null) {
            return 0;
        }
        if (rp.getRunStyle() != null) {
            result = 2;
        }
        if (!rp.isEmpty()) {
            Iterator it = rp.properties();
            while (it.hasNext()) {
                Object val;
                String prop = (String)it.next();
                if (prop.equals("b")) {
                    val = rp.get("b");
                    if (!val.equals(Boolean.TRUE)) continue;
                    result |= 4;
                    continue;
                }
                if (prop.equals("i")) {
                    val = rp.get("i");
                    if (!val.equals(Boolean.TRUE)) continue;
                    result |= 8;
                    continue;
                }
                if (prop.equals("vertAlign")) {
                    val = rp.get("vertAlign");
                    if (val.equals("superscript")) {
                        result |= 0x10;
                        continue;
                    }
                    if (!val.equals("subscript")) continue;
                    result |= 0x20;
                    continue;
                }
                result |= 1;
            }
        }
        return result;
    }

    static void setIfNotPresent(BaseRule rule, String name, Object value) {
        Object val = rule.get(name);
        if (val == null || val instanceof String && ((String)val).startsWith(" ")) {
            rule.set(name, value);
        }
    }

    String convertBorderSide(BorderSide side) {
        String type = side.getType();
        type = type.equals("single") ? "solid" : "solid";
        Paint paint = side.getColor();
        String color = paint instanceof RGBColor ? ((RGBColor)paint).toCSSString() : "black";
        double width = (double)side.getWidth() / 8.0;
        return String.valueOf(width > 1.0 ? String.valueOf(width) + "px " : "1px ") + type + " " + color;
    }

    private String getFontFamilyString(FontFamily family) {
        String name = family.getName();
        StringBuffer result = new StringBuffer();
        if (name.indexOf(32) >= 0) {
            result.append('\'');
            result.append(name);
            result.append('\'');
        } else {
            result.append(name);
        }
        String backupName = null;
        String shape = family.getFamily();
        String pitch = family.getPitch();
        if (pitch != null && pitch.equals("fixed")) {
            backupName = "monospace";
        } else if (shape != null) {
            if (shape.equals("roman")) {
                backupName = "serif";
            } else if (shape.equals("swiss")) {
                backupName = "sans-serif";
            }
        }
        if (backupName != null) {
            result.append(',');
            result.append(backupName);
        }
        return result.toString();
    }

    public boolean convertLabelToProperty(NumberingLabel label, BaseRule rule) {
        String text = label.getText();
        if (text.length() == 1) {
            char bulletChar = text.charAt(0);
            if (bulletChar == '\uf0b7') {
                if (rule != null) {
                    rule.set("list-style-type", "disc");
                    rule.set("text-indent", new CSSLength(0.0, "px"));
                }
                return true;
            }
            if (bulletChar == 'o') {
                if (rule != null) {
                    rule.set("list-style-type", "circle");
                    rule.set("text-indent", new CSSLength(0.0, "px"));
                }
                return true;
            }
        }
        if (rule != null) {
            rule.set("list-style-type", "none");
        }
        return false;
    }

    public StylingResult getLabelRule(BaseRule paragraphRule, NumberingLabel label, float emScale) {
        CSSLength len;
        Object textIndent;
        StylingResult result = new StylingResult();
        if (label.getRunProperties() != null) {
            this.convertStylingRule(result, label.getRunProperties(), emScale, false, false);
        }
        if (paragraphRule != null && (textIndent = paragraphRule.get("text-indent")) instanceof CSSLength && (len = (CSSLength)textIndent).getValue() < 0.0) {
            CSSLength labelWidth = new CSSLength(-len.getValue(), len.getUnit());
            result.elementRule.set("display", "inline-block");
            result.elementRule.set("text-indent", new CSSLength(0.0, "px"));
            result.elementRule.set("min-width", labelWidth);
        }
        result.elementClassName = "label";
        this.finalizeElementRule(result);
        return result;
    }

    void finalizeElementRule(StylingResult result) {
        if (result.elementRule.isEmpty()) {
            result.elementClassName = null;
            return;
        }
        Rule rule = this.stylesheet.getClassRuleForPrototype(result.elementRule);
        if (rule == null) {
            result.elementClassName = this.findUniqueClassName(result.elementClassName, false);
            rule = this.stylesheet.createClassRuleForPrototype(result.elementClassName, result.elementRule);
            this.classNames.add(result.elementClassName);
        } else {
            result.elementClassName = ((SimpleSelector)rule.getSelector()).getClassName();
        }
    }

    void finalizeContainerRule(StylingResult result) {
        if (result.containerRule == null) {
            return;
        }
        Rule rule = this.stylesheet.getClassRuleForPrototype(result.containerRule);
        if (rule == null) {
            if (result.containerClassName == null) {
                result.containerClassName = "d";
            }
            result.containerClassName = this.findUniqueClassName(result.containerClassName, false);
            rule = this.stylesheet.createClassRuleForPrototype(result.containerClassName, result.containerRule);
            this.classNames.add(result.containerClassName);
        } else {
            result.containerClassName = ((SimpleSelector)rule.getSelector()).getClassName();
        }
    }

    private void setContainerIfNotPresent(StylingResult result, String prop, Object value) {
        if (result.containerRule == null) {
            result.containerRule = new PrototypeRule();
        }
        StyleConverter.setIfNotPresent(result.containerRule, prop, value);
    }

    private void setElementIfNotPresent(StylingResult result, String prop, Object value) {
        StyleConverter.setIfNotPresent(result.elementRule, prop, value);
    }

    private boolean keepTogether(Hashtable wprop) {
        Object contextualSpacing = wprop.get("contextualSpacing");
        return contextualSpacing != null && contextualSpacing.equals(Boolean.TRUE);
    }

    private void convertWordToCSS(StylingResult result, Hashtable wprop, NumberingLabel label, float emScale, boolean sameStyleBefore, boolean sameStyleAfter) {
        boolean isList;
        float normalWidth = 612.0f;
        if (wprop.isEmpty()) {
            return;
        }
        double fontSize = 1.0;
        Object value = wprop.get("sz");
        if (value != null) {
            fontSize = ((Number)value).doubleValue() / ((double)emScale * this.defaultFontSize);
        }
        if ((value = wprop.get("vertAlign")) != null) {
            if (value.equals("superscript")) {
                this.setElementIfNotPresent(result, "vertical-align", "super");
                fontSize *= 0.8;
            } else if (value.equals("subscript")) {
                this.setElementIfNotPresent(result, "vertical-align", "sub");
                fontSize *= 0.8;
            }
        }
        if (fontSize != 1.0) {
            if (this.usingPX) {
                this.setElementIfNotPresent(result, "font-size", new CSSLength(fontSize * (double)emScale * this.defaultFontSize / 2.0, "px"));
            } else {
                this.setElementIfNotPresent(result, "font-size", new CSSLength(fontSize, "em"));
            }
        }
        double containerFontSize = this.defaultFontSize * (double)emScale;
        double elementFontSize = containerFontSize * fontSize;
        Number indLeft = (Number)wprop.get("ind-left");
        Number indHanging = (Number)wprop.get("ind-hanging");
        Number indFirstLine = (Number)wprop.get("ind-firstLine");
        boolean bl = isList = label != null || result.elementName != null && result.elementName.equals("li");
        if (indLeft != null || indHanging != null || indFirstLine != null) {
            double pts;
            double remSize;
            double pxSize;
            double halfPtSize;
            double left = indLeft == null ? 0.0 : indLeft.doubleValue();
            double hang = indHanging == null ? 0.0 : indHanging.doubleValue();
            double indent = indFirstLine == null ? 0.0 : indFirstLine.doubleValue();
            indent -= hang;
            if (isList) {
                halfPtSize = left / 10.0;
                if (this.usingPX || indent < 0.0 || isList) {
                    pxSize = halfPtSize / 2.0;
                    this.setElementIfNotPresent(result, "margin-left", new CSSLength(pxSize, "px"));
                } else {
                    remSize = halfPtSize / elementFontSize;
                    this.setElementIfNotPresent(result, "margin-left", new CSSLength(remSize, "em"));
                }
            } else if (left > 0.0 && (pts = left / 20.0) > 0.0) {
                if (isList) {
                    this.setElementIfNotPresent(result, "margin-left", new CSSLength(pts, "px"));
                } else {
                    double percent = 100.0 * pts / 612.0;
                    this.setContainerIfNotPresent(result, "margin-left", new CSSLength(percent, "%"));
                }
            }
            if (indent != 0.0) {
                halfPtSize = indent / 10.0;
                if (this.usingPX || indent < 0.0 || isList) {
                    pxSize = halfPtSize / 2.0;
                    this.setElementIfNotPresent(result, "text-indent", new CSSLength(pxSize, "px"));
                } else {
                    remSize = halfPtSize / elementFontSize;
                    this.setElementIfNotPresent(result, "text-indent", new CSSLength(remSize, "em"));
                }
            }
        }
        Iterator props = wprop.keySet().iterator();
        while (props.hasNext()) {
            float vSpace;
            double remSize;
            double pxSize;
            String name = (String)props.next();
            value = wprop.get(name);
            if (name.equals("b")) {
                boolean bold = value.equals(Boolean.TRUE);
                this.setElementIfNotPresent(result, "font-weight", bold ? "bold" : "normal");
                continue;
            }
            if (name.equals("i")) {
                boolean italic = value.equals(Boolean.TRUE);
                this.setElementIfNotPresent(result, "font-style", italic ? "italic" : "normal");
                continue;
            }
            if (name.equals("rFonts")) {
                FontFamily fontFamily = (FontFamily)value;
                this.setElementIfNotPresent(result, "font-family", this.getFontFamilyString(fontFamily));
                continue;
            }
            if (name.equals("u")) {
                Object val = result.elementRule.get("text-decoration");
                if (val == null || !val.equals("line-through")) {
                    result.elementRule.set("text-decoration", "underline");
                    continue;
                }
                result.elementRule.set("text-decoration", "underline, line-through");
                continue;
            }
            if (name.equals("strike")) {
                Object val = result.elementRule.get("text-decoration");
                if (val == null || !val.equals("underline")) {
                    result.elementRule.set("text-decoration", "line-through");
                    continue;
                }
                result.elementRule.set("text-decoration", "underline, line-through");
                continue;
            }
            if (name.equals("color")) {
                this.setElementIfNotPresent(result, "color", ((RGBColor)value).toCSSString());
                continue;
            }
            if (name.equals("highlight")) {
                this.setElementIfNotPresent(result, "background-color", ((RGBColor)value).toCSSString());
                continue;
            }
            if (name.equals("shd")) {
                if (!(value instanceof RGBColor)) continue;
                this.setContainerIfNotPresent(result, "background-color", ((RGBColor)value).toCSSString());
                continue;
            }
            if (name.startsWith("border-")) {
                BorderSide side = (BorderSide)value;
                CSSLength paddingDef = new CSSLength((double)side.getSpace() / 8.0, "px");
                String borderDef = this.convertBorderSide(side);
                if (name.equals("border-insideH")) {
                    if (result.tableCellRule == null) {
                        result.tableCellRule = new PrototypeRule();
                    }
                    result.tableCellRule.set("padding-top", paddingDef);
                    result.tableCellRule.set("padding-bottom", paddingDef);
                    result.tableCellRule.set("border-top", borderDef);
                    result.tableCellRule.set("border-bottom", borderDef);
                    continue;
                }
                if (name.equals("border-insideV")) {
                    if (result.tableCellRule == null) {
                        result.tableCellRule = new PrototypeRule();
                    }
                    result.tableCellRule.set("padding-left", paddingDef);
                    result.tableCellRule.set("padding-right", paddingDef);
                    result.tableCellRule.set("border-left", borderDef);
                    result.tableCellRule.set("border-right", borderDef);
                    continue;
                }
                if (name.equals("border-top")) {
                    this.setContainerIfNotPresent(result, "padding-top", paddingDef);
                    this.setContainerIfNotPresent(result, "border-top", borderDef);
                    continue;
                }
                if (name.equals("border-bottom")) {
                    this.setContainerIfNotPresent(result, "padding-bottom", paddingDef);
                    this.setContainerIfNotPresent(result, "border-bottom", borderDef);
                    continue;
                }
                if (name.equals("border-left")) {
                    this.setContainerIfNotPresent(result, "padding-left", paddingDef);
                    this.setContainerIfNotPresent(result, "border-left", borderDef);
                    continue;
                }
                if (!name.equals("border-right")) continue;
                this.setContainerIfNotPresent(result, "padding-right", paddingDef);
                this.setContainerIfNotPresent(result, "border-right", borderDef);
                continue;
            }
            if (name.equals("jc")) {
                String css = "left";
                if (value.equals("both")) {
                    css = "justify";
                } else if (value.equals("right") || value.equals("center")) {
                    css = value.toString();
                }
                this.setElementIfNotPresent(result, "text-align", css);
                continue;
            }
            if (name.equals("webHidden")) {
                boolean hidden = value.equals(Boolean.TRUE);
                if (!hidden) continue;
                this.setElementIfNotPresent(result, "display", "none");
                continue;
            }
            if (name.equals("pageBreakBefore")) {
                boolean pageBreakBefore = value.equals(Boolean.TRUE);
                if (!pageBreakBefore) continue;
                this.setContainerIfNotPresent(result, "page-break-before", "always");
                continue;
            }
            if (name.equals("keepNext")) {
                if (!value.equals(Boolean.TRUE)) continue;
                this.setContainerIfNotPresent(result, "page-break-after", "avoid");
                continue;
            }
            if (name.equals("keepLines")) {
                if (!value.equals(Boolean.TRUE)) continue;
                this.setContainerIfNotPresent(result, "page-break-inside", "avoid");
                continue;
            }
            if (name.equals("spacing-before")) {
                CSSLength len;
                if (sameStyleBefore && this.keepTogether(wprop)) continue;
                double halfPtSize = ((Number)value).doubleValue() / 10.0;
                boolean marginOnElement = sameStyleBefore;
                if (this.usingPX) {
                    pxSize = halfPtSize / 2.0;
                    len = new CSSLength(pxSize, "px");
                } else {
                    remSize = halfPtSize / containerFontSize;
                    len = new CSSLength(remSize, "em");
                }
                if (marginOnElement) {
                    this.setElementIfNotPresent(result, "margin-top", len);
                    continue;
                }
                this.setContainerIfNotPresent(result, "margin-top", len);
                continue;
            }
            if (name.equals("spacing-after")) {
                CSSLength len;
                if (sameStyleAfter && this.keepTogether(wprop)) continue;
                double halfPtSize = ((Number)value).doubleValue() / 10.0;
                boolean marginOnElement = sameStyleAfter;
                if (this.usingPX) {
                    pxSize = halfPtSize / 2.0;
                    len = new CSSLength(pxSize, "px");
                } else {
                    remSize = halfPtSize / containerFontSize;
                    len = new CSSLength(remSize, "em");
                }
                if (marginOnElement) {
                    this.setElementIfNotPresent(result, "margin-bottom", len);
                    continue;
                }
                this.setContainerIfNotPresent(result, "margin-bottom", len);
                continue;
            }
            if (name.equals("spacing-line")) {
                String lineRule = (String)wprop.get("spacing-lineRule");
                double halfPtSize = ((Number)value).doubleValue() / 10.0;
                if (!(halfPtSize > 0.0)) continue;
                if (this.usingPX && lineRule != null) {
                    double pxSize2 = halfPtSize / 2.0;
                    this.setElementIfNotPresent(result, "line-height", new CSSLength(pxSize2, "px"));
                    continue;
                }
                double base = elementFontSize;
                if (lineRule != null && lineRule.equals("auto")) {
                    base = 24.0;
                }
                double remSize2 = halfPtSize / base;
                this.setElementIfNotPresent(result, "line-height", new CSSLength(remSize2, ""));
                continue;
            }
            if (name.equals("ind-right")) {
                double pts = ((Number)value).doubleValue() / 20.0;
                if (!(pts > 0.0)) continue;
                if (isList) {
                    this.setElementIfNotPresent(result, "margin-right", new CSSLength(pts, "px"));
                    continue;
                }
                double percent = 100.0 * pts / 612.0;
                this.setContainerIfNotPresent(result, "margin-right", new CSSLength(percent, "%"));
                continue;
            }
            if (name.equals("framePr-align")) {
                String align = (String)value;
                if (align != null) {
                    this.setContainerIfNotPresent(result, "float", align);
                    continue;
                }
                this.setContainerIfNotPresent(result, "float", " left");
                continue;
            }
            if (name.equals("framePr-w")) {
                float width = ((Number)value).floatValue();
                if (!(width > 0.0f)) continue;
                float pts = width / 20.0f;
                float percent = 100.0f * pts / 612.0f;
                this.setContainerIfNotPresent(result, "width", new CSSLength(percent, "%"));
                this.setContainerIfNotPresent(result, "float", " left");
                continue;
            }
            if (name.equals("framePr-hSpace")) {
                float hSpace = ((Number)value).floatValue();
                if (!(hSpace > 0.0f)) continue;
                String align = (String)wprop.get("framePr-align");
                float pts = hSpace / 20.0f;
                CSSLength margin = new CSSLength(pts, "px");
                if (align == null || align.equals("left")) {
                    this.setContainerIfNotPresent(result, "margin-right", margin);
                    this.setContainerIfNotPresent(result, "float", " left");
                    continue;
                }
                this.setContainerIfNotPresent(result, "margin-left", margin);
                continue;
            }
            if (!name.equals("framePr-vSpace") || !((vSpace = ((Number)value).floatValue()) > 0.0f)) continue;
            float pts = vSpace / 20.0f;
            this.setContainerIfNotPresent(result, "margin-bottom", new CSSLength(pts, "px"));
            this.setContainerIfNotPresent(result, "float", " left");
        }
        if (label != null) {
            this.convertLabelToProperty(label, result.elementRule);
        }
    }

    private void cascade(Hashtable target, BaseProperties src, boolean force) {
        if (src == null || src.isEmpty()) {
            return;
        }
        Iterator props = src.properties();
        while (props.hasNext()) {
            String prop = (String)props.next();
            if (!force && target.get(prop) != null) continue;
            target.put(prop, src.get(prop));
        }
    }

    Hashtable cascadeWordProperties(BaseProperties prop) {
        ParagraphProperties pp;
        Style style;
        boolean runOnly = prop instanceof RunProperties;
        NumberingLabel label = null;
        Hashtable wprop = new Hashtable();
        if (prop instanceof RunProperties) {
            RunProperties rp = (RunProperties)prop;
            this.cascade(wprop, rp, false);
            style = rp.getRunStyle();
        } else if (prop instanceof ParagraphProperties) {
            pp = (ParagraphProperties)prop;
            label = pp.getNumberingLabel();
            this.cascade(wprop, pp, false);
            style = pp.getParagraphStyle();
        } else {
            TableProperties tp = (TableProperties)prop;
            this.cascade(wprop, tp, false);
            style = null;
        }
        while (style != null) {
            this.cascade(wprop, style.getRunProperties(), false);
            if (!runOnly) {
                this.cascade(wprop, style.getParagraphProperties(), false);
            }
            style = style.getParent();
        }
        if (label != null) {
            pp = label.getParagraphProperties();
            this.cascade(wprop, pp, true);
        }
        if (!runOnly && this.documentDefaultParagraphStyle != null) {
            this.cascade(wprop, this.documentDefaultParagraphStyle.getParagraphProperties(), false);
        }
        return wprop;
    }

    private void convertStylingRule(StylingResult result, BaseProperties prop, float emScale, boolean sameStyleBefore, boolean sameStyleAfter) {
        Hashtable wprop = this.cascadeWordProperties(prop);
        NumberingLabel label = null;
        if (prop instanceof ParagraphProperties) {
            label = ((ParagraphProperties)prop).getNumberingLabel();
        }
        this.convertWordToCSS(result, wprop, label, emScale, sameStyleBefore, sameStyleAfter);
        if (result.elementName != null && result.elementName.startsWith("h")) {
            if (result.elementRule.get("font-weight") == null) {
                result.elementRule.set("font-weight", "normal");
            }
            if (result.elementRule.get("margin-top") == null) {
                result.elementRule.set("margin-top", "0px");
            }
            if (result.elementRule.get("margin-bottom") == null) {
                result.elementRule.set("margin-bottom", "0px");
            }
            if (result.elementRule.get("margin-left") == null) {
                result.elementRule.set("margin-left", "0px");
            }
            if (result.elementRule.get("margin-right") == null) {
                result.elementRule.set("margin-right", "0px");
            }
        }
    }

    public StylingResult convertTableStylingRule(TableProperties prop, float emScale) {
        Hashtable wprop = this.cascadeWordProperties(prop);
        StylingResult result = new StylingResult();
        result.containerRule = result.elementRule;
        this.convertWordToCSS(result, wprop, null, emScale, false, false);
        return result;
    }

    StylingResult styleElement(BaseProperties prop, boolean isListElement, float emScale, boolean sameStyleBefore, boolean sameStyleAfter) {
        StylingResult result = new StylingResult();
        if (prop == null) {
            return result;
        }
        if (prop instanceof ParagraphProperties) {
            String styleId;
            boolean noInlineStyling;
            ParagraphProperties pp = (ParagraphProperties)prop;
            Style style = pp.getParagraphStyle();
            boolean bl = noInlineStyling = pp.isEmpty() && pp.getNumberingLabel() == null && pp.getRunProperties() == null;
            if (style == null) {
                if (noInlineStyling) {
                    return result;
                }
            } else {
                result.elementName = isListElement ? "li" : this.mapToElement(style.getStyleId());
            }
            result.elementClassName = result.elementName == null && style != null ? ((styleId = style.getStyleId()).equals("Normal") ? "p" : styleId) : (!noInlineStyling || result.elementName.equals("h1") || result.elementName.equals("li") || style == null ? "p" : style.getStyleId());
        } else {
            String styleId;
            RunProperties rp = (RunProperties)prop;
            int runMask = this.getRunMask(rp);
            switch (runMask) {
                case 0: {
                    return result;
                }
                case 4: {
                    result.elementName = "b";
                    return result;
                }
                case 8: {
                    result.elementName = "i";
                    return result;
                }
                case 32: {
                    result.elementName = "sub";
                    return result;
                }
                case 16: {
                    result.elementName = "sup";
                    return result;
                }
            }
            result.elementClassName = (runMask & 2) != 0 ? ((styleId = rp.getRunStyle().getStyleId()).equals("DefaultParagraphFont") ? "r" : styleId) : "r";
        }
        this.convertStylingRule(result, prop, emScale, sameStyleBefore, sameStyleAfter);
        return result;
    }
}

