/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import com.adobe.dp.epub.io.BufferedDataSource;
import com.adobe.dp.epub.io.StringDataSource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.HTMLElement;
import com.adobe.dp.epub.ops.ImageElement;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.office.conv.GDISVGSurface;
import com.adobe.dp.office.conv.ResourceWriter;
import com.adobe.dp.office.conv.StreamAndName;
import com.adobe.dp.office.metafile.WMFParser;
import com.adobe.dp.office.rtf.RTFColor;
import com.adobe.dp.office.rtf.RTFControl;
import com.adobe.dp.office.rtf.RTFControlType;
import com.adobe.dp.office.rtf.RTFDocument;
import com.adobe.dp.office.rtf.RTFFont;
import com.adobe.dp.office.rtf.RTFFormattingControlType;
import com.adobe.dp.office.rtf.RTFGroup;
import com.adobe.dp.office.rtf.RTFStyle;
import com.adobe.dp.otf.FontLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class RTFConverter {
    Stylesheet stylesheet;
    RTFDocument doc;
    Publication epub;
    OPSDocument chapter;
    Element section;
    Element paragraph;
    Element textAppendPoint;
    HashSet usedClassNames = new HashSet();
    Hashtable styleMap = new Hashtable();
    String bulletText;
    String bulletClass;
    StyleResource css;
    PrintWriter log = new PrintWriter(new OutputStreamWriter(System.out));
    int count = 1;
    static String mediaFolder = "OPS/images/";

    public RTFConverter(RTFDocument doc, Publication epub) {
        this.doc = doc;
        this.epub = epub;
    }

    private void transferProperties(Rule rule, RTFStyle style, boolean block) {
        float defaultFontSize;
        Iterator props = style.properties();
        boolean adjFontSize = false;
        float fontSize = defaultFontSize = 22.0f;
        boolean underline = false;
        boolean strike = false;
        int before = 0;
        int after = 0;
        int left = 0;
        int right = 0;
        int lineSpacing = 0;
        while (props.hasNext()) {
            RTFColor color;
            String prop = (String)props.next();
            Object val = style.get(prop);
            if (prop.equals("q_")) {
                if (val.equals("l")) {
                    rule.set("text-align", "left");
                    continue;
                }
                if (val.equals("r")) {
                    rule.set("text-align", "right");
                    continue;
                }
                if (val.equals("c")) {
                    rule.set("text-align", "center");
                    continue;
                }
                if (!val.equals("j")) continue;
                rule.set("text-align", "justify");
                continue;
            }
            if (prop.equals("f")) {
                RTFFont font = this.doc.getFont(((Number)val).intValue());
                if (font == null) continue;
                rule.set("font-family", font.toCSSString());
                continue;
            }
            if (prop.equals("fs")) {
                fontSize = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("sb")) {
                before = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("sa")) {
                after = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("li")) {
                left = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("ri")) {
                right = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("sl")) {
                lineSpacing = ((Number)val).intValue();
                continue;
            }
            if (prop.equals("fi")) {
                rule.set("text-indent", String.valueOf((double)((Number)val).intValue() / 220.0) + "em");
                continue;
            }
            if (prop.equals("i")) {
                rule.set("font-style", val.equals(Boolean.TRUE) ? "italic" : "normal");
                continue;
            }
            if (prop.equals("b")) {
                rule.set("font-weight", val.equals(Boolean.TRUE) ? "bold" : "normal");
                continue;
            }
            if (prop.equals("cf")) {
                color = this.doc.getColor((Integer)val);
                if (color == null) continue;
                rule.set("color", color.toCSSString());
                continue;
            }
            if (prop.equals("sub")) {
                if (!val.equals(Boolean.TRUE)) continue;
                rule.set("vertical-align", "sub");
                adjFontSize = true;
                continue;
            }
            if (prop.equals("super")) {
                if (!val.equals(Boolean.TRUE)) continue;
                rule.set("vertical-align", "super");
                adjFontSize = true;
                continue;
            }
            if (prop.equals("ul")) {
                if (val.equals(Boolean.FALSE)) continue;
                underline = true;
                continue;
            }
            if (prop.equals("strike")) {
                if (val.equals(Boolean.FALSE)) continue;
                strike = true;
                continue;
            }
            if (prop.equals("cf")) {
                color = this.doc.getColor((Integer)val);
                if (color == null) continue;
                rule.set("color", color.toCSSString());
                continue;
            }
            if (!prop.equals("webhidden")) continue;
            rule.set("visibility", val.equals(Boolean.TRUE) ? "hidden" : "visible");
        }
        if (adjFontSize) {
            fontSize *= 0.67f;
        }
        if (fontSize != defaultFontSize) {
            rule.set("font-size", String.valueOf(fontSize / defaultFontSize) + "em");
        }
        if (underline || strike) {
            if (underline && strike) {
                rule.set("text-decoration", "line-through, underline");
            } else if (underline) {
                rule.set("text-decoration", "underline");
            } else {
                rule.set("text-decoration", "line-through");
            }
        }
        if (block) {
            rule.set("margin", (double)before / 20.0 + "pt " + (double)right / 20.0 + "pt " + (double)after / 20.0 + "pt " + (double)left / 20.0 + " pt");
            if (lineSpacing != 0) {
                if (lineSpacing < 0) {
                    lineSpacing = -lineSpacing;
                }
                rule.set("line-height", String.valueOf((float)lineSpacing / (defaultFontSize * 10.0f)) + "em");
            }
        }
    }

    private String getClassName(RTFStyle[] styles, String prefix, Set propSet) {
        RTFStyle style = RTFStyle.collapse(styles, propSet);
        if (style.isEmpty()) {
            return String.valueOf(prefix) + "0";
        }
        String className = (String)this.styleMap.get(style);
        if (className == null) {
            className = String.valueOf(prefix) + this.count++;
            SimpleSelector selector = this.stylesheet.getSimpleSelector(null, className);
            Rule rule = this.stylesheet.getRuleForSelector(selector);
            this.transferProperties(rule, style, prefix.equals("p"));
            style.lock();
            this.styleMap.put(style, className);
        }
        return className;
    }

    private String getParagraphClassName(RTFStyle paragraphStyle, RTFStyle characterStyle) {
        RTFStyle[] styles = new RTFStyle[]{characterStyle, paragraphStyle};
        return this.getClassName(styles, "p", RTFControlType.paragraphProps);
    }

    private String getCharacterClassName(RTFStyle paragraphStyle, RTFStyle characterStyle) {
        RTFStyle[] styles = new RTFStyle[]{characterStyle, paragraphStyle};
        return this.getClassName(styles, "c", RTFControlType.characterProps);
    }

    private void ensureParagraph(RTFStyle paragraphStyle, RTFStyle characterStyle) {
        if (this.paragraph == null) {
            this.paragraph = this.chapter.createElement("p");
            this.paragraph.setClassName(this.getParagraphClassName(paragraphStyle, characterStyle));
            this.section.add(this.paragraph);
            this.textAppendPoint = null;
        }
    }

    private Element getTextAppendPoint(RTFStyle paragraphStyle, RTFStyle characterStyle) {
        this.ensureParagraph(paragraphStyle, characterStyle);
        if (this.textAppendPoint == null) {
            if (characterStyle != null && !characterStyle.isEmpty()) {
                this.textAppendPoint = this.chapter.createElement("span");
                this.textAppendPoint.setClassName(this.getCharacterClassName(paragraphStyle, characterStyle));
                this.paragraph.add(this.textAppendPoint);
            } else {
                this.textAppendPoint = this.paragraph;
            }
        }
        return this.textAppendPoint;
    }

    private void addChildren(RTFGroup g, RTFStyle paragraphStyle, RTFStyle characterStyle) {
        Object[] content = g.getContent();
        int i = 0;
        while (i < content.length) {
            block17: {
                RTFGroup sg;
                block19: {
                    RTFControl ctrl;
                    block21: {
                        String name;
                        block20: {
                            Object c;
                            block18: {
                                block16: {
                                    int index;
                                    c = content[i];
                                    if (!(c instanceof RTFControl)) break block16;
                                    ctrl = (RTFControl)c;
                                    RTFControlType ct = ctrl.getType();
                                    name = ctrl.getName();
                                    if (name.equals("par")) {
                                        this.paragraph = null;
                                        this.textAppendPoint = null;
                                    } else if (name.equals("s")) {
                                        index = ctrl.getParam();
                                        paragraphStyle = this.doc.getParagraphStyle(index);
                                        this.textAppendPoint = null;
                                    } else if (name.equals("cs")) {
                                        index = ctrl.getParam();
                                        characterStyle = RTFConverter.cloneStyle(this.doc.getCharacterStyle(index));
                                        this.textAppendPoint = null;
                                    } else if (ct instanceof RTFFormattingControlType) {
                                        if (name.equals("pard")) {
                                            paragraphStyle = null;
                                        }
                                        if (characterStyle == null) {
                                            characterStyle = new RTFStyle();
                                        }
                                        if (characterStyle.isLocked()) {
                                            characterStyle = characterStyle.cloneStyle();
                                        }
                                        ct.formattingExec(ctrl, characterStyle);
                                        this.textAppendPoint = null;
                                    }
                                    break block17;
                                }
                                if (!(c instanceof String)) break block18;
                                this.getTextAppendPoint(paragraphStyle, characterStyle);
                                if (this.bulletText != null) {
                                    HTMLElement bulletSpan = this.chapter.createElement("span");
                                    bulletSpan.setClassName(this.bulletClass);
                                    this.textAppendPoint.add(bulletSpan);
                                    bulletSpan.add(this.bulletText);
                                    this.bulletText = null;
                                }
                                this.textAppendPoint.add(c);
                                break block17;
                            }
                            if (!(c instanceof RTFGroup)) break block17;
                            sg = (RTFGroup)c;
                            ctrl = sg.getHead();
                            if (ctrl == null) break block19;
                            name = ctrl.getName();
                            if (!name.equals("pict")) break block20;
                            this.processPicture(sg);
                            break block17;
                        }
                        if (!name.equals("listtext")) break block21;
                        this.extractBulletText(sg);
                        break block17;
                    }
                    if (ctrl.isOptional()) break block17;
                }
                this.textAppendPoint = null;
                this.addChildren(sg, RTFConverter.cloneStyle(paragraphStyle), RTFConverter.cloneStyle(characterStyle));
                this.textAppendPoint = null;
            }
            ++i;
        }
    }

    private void extractBulletText(RTFGroup listtext) {
        StringBuffer sb = new StringBuffer();
        this.extractText(listtext, sb);
        this.bulletText = sb.toString();
        this.bulletClass = "listtext";
        if (this.bulletText.equals("\u00b7\t")) {
            this.bulletText = "\u2022\t";
            this.bulletClass = "bullet";
        } else if (this.bulletText.equals("o\t")) {
            this.bulletText = "\u25e6\t";
            this.bulletClass = "bullet";
        }
    }

    private void extractText(RTFGroup listtext, StringBuffer sb) {
        Object[] content = listtext.getContent();
        int i = 0;
        while (i < content.length) {
            RTFGroup g;
            RTFControl ctrl;
            Object c = content[i];
            if (c instanceof String) {
                sb.append(c);
            } else if (c instanceof RTFGroup && ((ctrl = (g = (RTFGroup)c).getHead()) == null || !ctrl.isOptional())) {
                this.extractText(g, sb);
            }
            ++i;
        }
    }

    private void processPicture(RTFGroup pict) {
        Resource res;
        this.paragraph = null;
        this.textAppendPoint = null;
        Object[] content = pict.getContent();
        if (content.length == 0) {
            return;
        }
        String contentType = null;
        int width = 0;
        int scalex = 100;
        int i = 0;
        while (i < content.length) {
            if (content[i] instanceof RTFControl) {
                RTFControl c = (RTFControl)content[i];
                String name = c.getName();
                if (name.equals("emfblip")) {
                    contentType = "image/x-emf";
                } else if (name.equals("pngblip")) {
                    contentType = "image/png";
                } else if (name.equals("jpegblip")) {
                    contentType = "image/jpeg";
                } else if (name.equals("wmetafile")) {
                    contentType = "image/x-wmf";
                } else if (name.equals("picwgoal")) {
                    width = c.getParam();
                } else if (name.equals("picscalex")) {
                    scalex = c.getParam();
                }
            }
            ++i;
        }
        if (contentType == null) {
            return;
        }
        Object last = content[content.length - 1];
        if (!(last instanceof byte[])) {
            return;
        }
        byte[] pictBytes = (byte[])last;
        if (contentType.equals("image/jpeg") || contentType.equals("image/png")) {
            BufferedDataSource dataSource = new BufferedDataSource();
            try {
                dataSource.getOutputStream().write(pictBytes);
            }
            catch (IOException e) {
                throw new Error("Unexpected IOException for memory buffer stream: " + e.getMessage());
            }
            String resName = this.epub.makeUniqueResourceName(String.valueOf(mediaFolder) + (contentType.equals("image/jpeg") ? "pict.jpeg" : "pict.png"));
            res = this.epub.createBitmapImageResource(resName, contentType, dataSource);
        } else if (contentType.equals("image/x-wmf")) {
            WMFResourceWriter dw = new WMFResourceWriter();
            GDISVGSurface svg = new GDISVGSurface(dw);
            try {
                WMFParser parser = new WMFParser(new ByteArrayInputStream(pictBytes), svg);
                parser.readAll();
            }
            catch (IOException e) {
                e.printStackTrace(this.log);
                return;
            }
            StringDataSource dataSource = new StringDataSource(svg.getSVG());
            String resName = this.epub.makeUniqueResourceName(String.valueOf(mediaFolder) + "pict.svg");
            res = this.epub.createResource(resName, "image/svg+xml", dataSource);
        } else {
            return;
        }
        ImageElement imageElement = this.chapter.createImageElement("img");
        imageElement.setImageResource(res);
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (width > 0) {
            props.put("width", String.valueOf((double)(width * scalex) / 2000.0) + "pt");
        }
        props.put("max-width", "95%");
        imageElement.setStyle(new InlineStyleRule(props));
        this.section.add(imageElement);
    }

    private static RTFStyle cloneStyle(RTFStyle s) {
        if (s == null) {
            return null;
        }
        return s.cloneStyle();
    }

    public void convert() {
        OPSResource ops = this.epub.createOPSResource("OPS/content.xhtml");
        this.css = this.epub.createStyleResource("OPS/style.css");
        this.stylesheet = this.css.getStylesheet();
        Rule bulletRule = this.stylesheet.getRuleForSelector(this.stylesheet.getSimpleSelector("span", "bullet"));
        bulletRule.set("font-family", "Arial, sans-serif");
        this.epub.addToSpine(ops);
        this.chapter = ops.getDocument();
        this.chapter.addStyleResource(this.css);
        this.section = this.chapter.getBody();
        this.addChildren(this.doc.getRoot(), null, null);
    }

    void embedFonts(FontLocator fontLocator) {
        this.epub.addFonts(this.css, fontLocator);
    }

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    class WMFResourceWriter
    implements ResourceWriter {
        WMFResourceWriter() {
        }

        public StreamAndName createResource(String base, String suffix, boolean doNotCompress) throws IOException {
            String name = String.valueOf(mediaFolder) + "wmf-" + base + suffix;
            name = RTFConverter.this.epub.makeUniqueResourceName(name);
            BufferedDataSource dataSource = new BufferedDataSource();
            RTFConverter.this.epub.createBitmapImageResource(name, "image/png", dataSource);
            return new StreamAndName(name.substring(mediaFolder.length()), dataSource.getOutputStream());
        }
    }
}

