/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.office.conv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;

public class PNGWriter {
    private static final byte[] sig = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] idat = new byte[]{73, 68, 65, 84};
    private static final byte[] end;
    int width;
    int height;
    int byteWidth;
    boolean alpha;
    byte[] prevLine;
    byte[] filterBuf;
    ByteArrayOutputStream compressedImage = new ByteArrayOutputStream();
    DeflaterOutputStream deflater = new DeflaterOutputStream(this.compressedImage);
    OutputStream out;

    static {
        byte[] byArray = new byte[12];
        byArray[4] = 73;
        byArray[5] = 69;
        byArray[6] = 78;
        byArray[7] = 68;
        byArray[8] = -82;
        byArray[9] = 66;
        byArray[10] = 96;
        byArray[11] = -126;
        end = byArray;
    }

    public PNGWriter(OutputStream out, int width, int height, boolean alpha) throws IOException {
        this.out = out;
        this.width = width;
        this.height = height;
        this.alpha = alpha;
        out.write(sig);
        byte[] byArray = new byte[4];
        byArray[3] = 13;
        byte[] len = byArray;
        out.write(len);
        byte[] byArray2 = new byte[17];
        byArray2[0] = 73;
        byArray2[1] = 72;
        byArray2[2] = 68;
        byArray2[3] = 82;
        byArray2[4] = (byte)(width >> 24);
        byArray2[5] = (byte)(width >> 16);
        byArray2[6] = (byte)(width >> 8);
        byArray2[7] = (byte)width;
        byArray2[8] = (byte)(height >> 24);
        byArray2[9] = (byte)(height >> 16);
        byArray2[10] = (byte)(height >> 8);
        byArray2[11] = (byte)height;
        byArray2[12] = 8;
        byArray2[13] = (byte)(alpha ? 6 : 2);
        byte[] ihdr = byArray2;
        out.write(ihdr);
        CRC32 crc32 = new CRC32();
        crc32.update(ihdr);
        long crc = crc32.getValue();
        byte[] checksum = new byte[]{(byte)(crc >> 24), (byte)(crc >> 16), (byte)(crc >> 8), (byte)crc};
        out.write(checksum);
        this.byteWidth = width * (alpha ? 4 : 3);
        this.filterBuf = new byte[this.byteWidth + 1];
    }

    public void writeScanline(byte[] pixels, int offset, int len) {
        if (len != this.byteWidth) {
            throw new IllegalArgumentException("len");
        }
        try {
            if (this.prevLine == null) {
                this.filterBuf[0] = 0;
                System.arraycopy(pixels, offset, this.filterBuf, 1, this.byteWidth);
                this.prevLine = new byte[this.byteWidth];
            } else {
                this.filterBuf[0] = 2;
                int i = 0;
                while (i < this.byteWidth) {
                    this.filterBuf[i + 1] = (byte)(pixels[offset + i] - this.prevLine[i]);
                    ++i;
                }
            }
            this.deflater.write(this.filterBuf);
            System.arraycopy(pixels, offset, this.prevLine, 0, this.byteWidth);
        }
        catch (IOException e) {
            throw new Error("IOException while writing to memory-based stream");
        }
    }

    public void close() throws IOException {
        this.deflater.close();
        byte[] bytes = this.compressedImage.toByteArray();
        int csz = bytes.length;
        byte[] len = new byte[]{(byte)(csz >> 24), (byte)(csz >> 16), (byte)(csz >> 8), (byte)csz};
        this.out.write(len);
        this.out.write(idat);
        this.out.write(bytes);
        CRC32 crc32 = new CRC32();
        crc32.update(idat);
        crc32.update(bytes);
        long crc = crc32.getValue();
        byte[] checksum = new byte[]{(byte)(crc >> 24), (byte)(crc >> 16), (byte)(crc >> 8), (byte)crc};
        this.out.write(checksum);
        this.out.write(end);
        this.out.close();
    }
}

