/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.servlet;

import com.adobe.dp.epub.io.OCFContainerWriter;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.epub.web.font.FontCookieSet;
import com.adobe.dp.epub.web.font.SharedFontSet;
import com.adobe.dp.epub.web.util.Initializer;
import com.adobe.dp.fb2.FB2Document;
import com.adobe.dp.fb2.FB2FormatException;
import com.adobe.dp.fb2.convert.FB2Converter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FB2ConverterServlet
extends HttpServlet {
    public static final long serialVersionUID = 0L;
    static Logger logger;
    static HashSet activeStreams;
    static /* synthetic */ Class class$0;

    static {
        activeStreams = new HashSet();
        Initializer.init();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.adobe.dp.epub.web.servlet.FB2ConverterServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        logger.setLevel(Level.ALL);
        logger.trace((Object)"servlet loaded");
    }

    void reportError(HttpServletResponse resp, String err) throws IOException {
        logger.error((Object)err);
        resp.setContentType("text/plain; charset=utf8");
        PrintWriter out = resp.getWriter();
        ((Writer)out).write(err);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(false, req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(true, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doRequest(boolean post, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block53: {
            block49: {
                streamIP = null;
                FB2ConverterServlet.logger.trace((Object)("start " + req.getRemoteAddr()));
                fb2in = null;
                templatein = null;
                book = null;
                template = null;
                translit = false;
                useurl = false;
                fb2url = null;
                if (post && ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                    itemFac = new DiskFileItemFactory();
                    repositoryPath = Initializer.getUploadDir();
                    repositoryPath.mkdir();
                    itemFac.setRepository(repositoryPath);
                    servletFileUpload = new ServletFileUpload((FileItemFactory)itemFac);
                    fileItemList = servletFileUpload.parseRequest(req);
                    list = fileItemList.iterator();
                    while (list.hasNext()) {
                        item = (FileItem)list.next();
                        t = item.getString();
                        paramName = item.getFieldName();
                        if (paramName.equals("file")) {
                            if (t.startsWith("http://")) {
                                fb2url = t;
                                continue;
                            }
                            if (t.length() <= 0) continue;
                            book = item;
                            continue;
                        }
                        if (paramName.equals("template")) {
                            if (t.length() <= 0) continue;
                            template = item;
                            continue;
                        }
                        if (paramName.equals("translit")) {
                            translit = t.equals("on") != false || t.equals("yes") != false;
                            continue;
                        }
                        if (paramName.equals("useurl")) {
                            useurl = t.equals("on") != false || t.equals("yes") != false;
                            continue;
                        }
                        if (!paramName.equals("url") || t.length() <= 0) continue;
                        fb2url = t;
                    }
                    if (!useurl && book != null) {
                        fb2in = book.getInputStream();
                    }
                    if (template != null) {
                        templatein = template.getInputStream();
                    }
                } else {
                    fb2url = req.getParameter("url");
                    t = req.getParameter("translit");
                    v0 = translit = t != null && (t.equals("on") != false || t.equals("yes") != false);
                }
                if (fb2in != null) ** GOTO lbl93
                if (fb2url != null) break block49;
                this.reportError(resp, "Invalid request: neither fb2 file nor URL is provided");
lbl55:
                // 3 sources

                while (true) {
                    if (streamIP != null) {
                        var24_23 = FB2ConverterServlet.activeStreams;
                        synchronized (var24_23) {
                            FB2ConverterServlet.activeStreams.remove(streamIP);
                        }
                    }
                    FB2ConverterServlet.logger.trace((Object)"end");
                    return;
                }
            }
            try {
                block54: {
                    url = new URL(fb2url);
                    if (url.getProtocol().equals("http")) break block54;
                    this.reportError(resp, "Invalid request: fb2 URL protocol is not http");
                    ** GOTO lbl55
                }
                host = url.getHost();
                ipaddr = InetAddress.getByName(host);
                ipstr = ipaddr.toString();
                list = FB2ConverterServlet.activeStreams;
                synchronized (list) {
                    if (!FB2ConverterServlet.activeStreams.contains(ipstr)) {
                        FB2ConverterServlet.activeStreams.add(ipstr);
                        streamIP = ipstr;
                    }
                }
                if (streamIP == null) {
                    this.reportError(resp, "Only a single connection to the server " + host + " is allowed");
                    ** continue;
                }
                FB2ConverterServlet.logger.info((Object)("downloading from " + fb2url));
                fb2in = url.openStream();
lbl93:
                // 2 sources

                doc = new FB2Document(fb2in);
                epub = new Publication();
                epub.setTranslit(translit);
                epub.useAdobeFontMangling();
                fb2in.close();
                if (book != null) {
                    book.delete();
                }
                title = (bookInfo = doc.getTitleInfo()) == null ? null : bookInfo.getBookTitle();
                fname = title == null ? "book" : Translit.translit(title).replace(' ', '_').replace('\t', '_').replace('\n', '_').replace('\r', '_').replace('\u00ab', '_').replace('\u00bb', '_');
                resp.setContentType("application/epub+zip");
                resp.setHeader("Content-Disposition", "attachment; filename=" + fname + ".epub");
                out = resp.getOutputStream();
                container = new OCFContainerWriter((OutputStream)out);
                conv = new FB2Converter();
                fontLocator = Initializer.getDefaultFontLocator();
                customFontCookies = new FontCookieSet(req);
                sharedFontSet = SharedFontSet.getInstance();
                fontLocator = sharedFontSet.getFontLocator(customFontCookies, fontLocator);
                conv.setFontLocator(fontLocator);
                if (templatein != null) {
                    conv.setTemplate(templatein);
                    if (template != null) {
                        template.delete();
                    }
                }
                conv.convert(doc, epub);
                conv.embedFonts();
                epub.serialize(container);
            }
            catch (FB2FormatException e) {
                FB2ConverterServlet.logger.error((Object)"error", (Throwable)e);
                this.reportError(resp, e.getMessage());
                e.printStackTrace();
                if (streamIP != null) {
                    var24_24 = FB2ConverterServlet.activeStreams;
                    synchronized (var24_24) {
                        FB2ConverterServlet.activeStreams.remove(streamIP);
                    }
                }
                FB2ConverterServlet.logger.trace((Object)"end");
            }
            catch (Exception e) {
                block51: {
                    FB2ConverterServlet.logger.error((Object)"error", (Throwable)e);
                    this.reportError(resp, "Internal server error: " + e.toString());
                    e.printStackTrace();
                    if (streamIP == null) break block51;
                    var24_25 = FB2ConverterServlet.activeStreams;
                    synchronized (var24_25) {
                        FB2ConverterServlet.activeStreams.remove(streamIP);
                    }
                }
                FB2ConverterServlet.logger.trace((Object)"end");
            }
            catch (Throwable e) {
                block52: {
                    FB2ConverterServlet.logger.fatal((Object)"error", e);
                    if (streamIP == null) break block52;
                    var24_26 = FB2ConverterServlet.activeStreams;
                    {
                        catch (Throwable var23_32) {
                            if (streamIP != null) {
                                var24_27 = FB2ConverterServlet.activeStreams;
                                synchronized (var24_27) {
                                    FB2ConverterServlet.activeStreams.remove(streamIP);
                                }
                            }
                            FB2ConverterServlet.logger.trace((Object)"end");
                            throw var23_32;
                        }
                    }
                    synchronized (var24_26) {
                        FB2ConverterServlet.activeStreams.remove(streamIP);
                    }
                }
                FB2ConverterServlet.logger.trace((Object)"end");
            }
            if (streamIP == null) break block53;
            var24_28 = FB2ConverterServlet.activeStreams;
            synchronized (var24_28) {
                FB2ConverterServlet.activeStreams.remove(streamIP);
            }
        }
        FB2ConverterServlet.logger.trace((Object)"end");
    }
}

