/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.font;

import com.adobe.dp.epub.web.font.FontCookieSet;
import com.adobe.dp.epub.web.util.Initializer;
import com.adobe.dp.otf.FileFontInputStream;
import com.adobe.dp.otf.FontInputStream;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.otf.FontProperties;
import com.adobe.dp.otf.OpenTypeFont;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;

public class SharedFontSet {
    private static SharedFontSet instance = new SharedFontSet();
    private File fontFolder;
    private Hashtable fontNameToKeyMap = new Hashtable();

    private SharedFontSet() {
        File home = Initializer.getEPubGenHome();
        this.fontFolder = new File(home, "uploadedFonts");
        this.fontFolder.mkdirs();
        String[] list = this.fontFolder.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].endsWith("=")) {
                    this.loadFont(list[i]);
                }
                ++i;
            }
        }
    }

    private boolean loadFont(String name) {
        File fontFile = new File(this.fontFolder, name);
        FontProperties key = this.loadFont(fontFile);
        if (key == null) {
            return false;
        }
        this.fontNameToKeyMap.put(name, key);
        return true;
    }

    private FontProperties loadFont(File fontFile) {
        OpenTypeFont font;
        block5: {
            block4: {
                try {
                    if (fontFile.exists()) break block4;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            FileFontInputStream fin = new FileFontInputStream(fontFile);
            font = new OpenTypeFont(fin, true);
            fin.close();
            if (font.canEmbedForReading()) break block5;
            return null;
        }
        return new FontProperties(font.getFamilyName(), font.getWeight(), font.getStyle());
    }

    public FontProperties getFontProperties(String sha1str) {
        FontProperties prop = (FontProperties)this.fontNameToKeyMap.get(sha1str);
        if (prop == null) {
            this.loadFont(sha1str);
            prop = (FontProperties)this.fontNameToKeyMap.get(sha1str);
        }
        return prop;
    }

    public boolean addFont(String sha1str, InputStream in) {
        FontProperties prop;
        File fontFile;
        block7: {
            block6: {
                if (this.getFontProperties(sha1str) == null) break block6;
                in.close();
                return false;
            }
            try {
                int len;
                fontFile = File.createTempFile("fnt", ".tmp", this.fontFolder);
                FileOutputStream out = new FileOutputStream(fontFile);
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.close();
                in.close();
                prop = this.loadFont(fontFile);
                if (prop != null) break block7;
                fontFile.delete();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.fontNameToKeyMap.put(sha1str, prop);
        File dest = new File(this.fontFolder, sha1str);
        if (!fontFile.renameTo(dest)) {
            fontFile.delete();
            return false;
        }
        return true;
    }

    public FontLocator getFontLocator(FontCookieSet cookies, FontLocator base) {
        Iterator it = cookies.hashes();
        Hashtable<FontProperties, String> fontSet = new Hashtable<FontProperties, String>();
        while (it.hasNext()) {
            String hash = (String)it.next();
            FontProperties key = (FontProperties)this.fontNameToKeyMap.get(hash);
            if (key == null) continue;
            fontSet.put(key, hash);
        }
        return new SharedFontLocator(fontSet, base);
    }

    public static SharedFontSet getInstance() {
        return instance;
    }

    class SharedFontLocator
    extends FontLocator {
        Hashtable keyToName;
        FontLocator base;

        SharedFontLocator(Hashtable keyToName, FontLocator base) {
            this.keyToName = keyToName;
            this.base = base;
        }

        FontProperties substitute(FontProperties key) {
            if (key.getStyle() == 1 && key.getFamilyName().equals("Tahoma")) {
                key = new FontProperties("Verdana", key.getWeight(), key.getStyle());
            }
            return key;
        }

        String getFontSource(FontProperties key) {
            FontProperties key1;
            String name = (String)this.keyToName.get(key = this.substitute(key));
            if (name == null && (name = (String)this.keyToName.get(key1 = new FontProperties(key.getFamilyName(), key.getWeight() + 100, key.getStyle()))) == null) {
                key1 = new FontProperties(key.getFamilyName(), key.getWeight() - 100, key.getStyle());
                name = (String)this.keyToName.get(key);
                if (name == null) {
                    return null;
                }
            }
            return name;
        }

        public FontInputStream locateFont(FontProperties key) throws IOException {
            String src = this.getFontSource(key);
            if (src == null) {
                if (this.base == null) {
                    return null;
                }
                return this.base.locateFont(key);
            }
            File file = new File(SharedFontSet.this.fontFolder, src);
            return new FileFontInputStream(file);
        }

        public boolean hasFont(FontProperties key) {
            return this.getFontSource(key) != null || this.base != null && this.base.hasFont(key);
        }
    }
}

