/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.web.font;

import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FontCookieSet {
    private HashSet set = new HashSet();

    public FontCookieSet() {
    }

    public FontCookieSet(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String value;
                int len;
                Cookie cookie = cookies[i];
                if (cookie.getName().startsWith("fontSet") && (len = (value = cookie.getValue()).length()) % 28 == 0) {
                    int k = 0;
                    while (k < len) {
                        String hash = value.substring(k, k + 28);
                        if (hash.endsWith("=")) {
                            this.set.add(hash);
                        }
                        k += 28;
                    }
                }
                ++i;
            }
        }
    }

    public void addFontHash(String sha1str) {
        this.set.add(sha1str);
    }

    public void removeFontHash(String sha1str) {
        this.set.remove(sha1str);
    }

    public Iterator hashes() {
        return this.set.iterator();
    }

    public void setCookies(HttpServletResponse resp, String pathURI, int expiry) {
        int maxFontSetSize = 100;
        int fontSetCount = 1;
        int fontCount = 0;
        Iterator it = this.set.iterator();
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (it.hasNext()) {
                sb.append(it.next());
                if (++fontCount < 100) continue;
            }
            Cookie cookie = new Cookie("fontSet" + fontSetCount, sb.toString());
            cookie.setPath(pathURI);
            cookie.setMaxAge(expiry);
            sb.delete(0, sb.length());
            ++fontSetCount;
            resp.addCookie(cookie);
            if (!it.hasNext()) break;
        }
    }
}

