/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.util;

public class ImageDimensions {
    private static int readInt(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    private static int readShort(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF;
    }

    private static int readShortBE(byte[] buf, int offset) {
        return buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8;
    }

    public static int[] getImageDimensions(byte[] buf) {
        if (buf[0] == -1 && buf[1] == -40 && buf[2] == -1 && buf[3] == -32 && buf[6] == 74 && buf[7] == 70 && buf[8] == 73 && buf[9] == 70) {
            int k = 2;
            while (k + 5 < buf.length && buf[k] == -1) {
                int tag = buf[k + 1] & 0xFF;
                switch (tag) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 201: 
                    case 202: 
                    case 203: {
                        int[] dim = new int[]{ImageDimensions.readShort(buf, k + 7), ImageDimensions.readShort(buf, k + 5)};
                        return dim;
                    }
                }
                int size = 2 + ((buf[k + 2] & 0xFF) << 8) + (buf[k + 3] & 0xFF);
                k += size;
            }
        } else {
            if (buf[0] == 71 && buf[1] == 73 && buf[2] == 70) {
                int[] dim = new int[]{ImageDimensions.readShortBE(buf, 6), ImageDimensions.readShortBE(buf, 8)};
                return dim;
            }
            if (buf[0] == -119 && buf[1] == 80 && buf[2] == 78 && buf[3] == 71 && buf[4] == 13 && buf[5] == 10 && buf[6] == 26 && buf[7] == 10 && buf[12] == 73 && buf[13] == 72 && buf[14] == 68 && buf[15] == 82) {
                int[] dim = new int[]{ImageDimensions.readInt(buf, 16), ImageDimensions.readInt(buf, 20)};
                return dim;
            }
        }
        return null;
    }
}

