/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.util;

import com.adobe.dp.epub.style.SimpleStylesheetParser;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.otf.ByteArrayFontInputStream;
import com.adobe.dp.otf.FileFontInputStream;
import com.adobe.dp.otf.FontInputStream;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.otf.FontProperties;
import com.adobe.dp.otf.OpenTypeFont;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConversionTemplate {
    ZipFile zip;
    File[] files;
    Stylesheet stylesheet;
    TemplateFontLocator fontLocator;
    static Hashtable sharedTemplates = new Hashtable();

    public ConversionTemplate(File zippedResources) throws IOException {
        this.zip = new ZipFile(zippedResources);
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        Vector<String> names = new Vector<String>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            names.add(name);
        }
        this.init(names);
    }

    public ConversionTemplate(File[] resourceFileSet) throws IOException {
        this.files = resourceFileSet;
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < resourceFileSet.length) {
            String name = resourceFileSet[i].getAbsolutePath();
            names.add(name);
            ++i;
        }
        this.init(names);
    }

    void init(Vector names) throws IOException {
        Enumeration entries = names.elements();
        HashSet<String> fonts = new HashSet<String>();
        Hashtable fontMap = new Hashtable();
        SimpleStylesheetParser parser = null;
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().toString();
            String lname = name.toLowerCase();
            if (lname.endsWith(".css")) {
                InputStreamReader reader = new InputStreamReader(this.getInputStream(name), "UTF-8");
                if (parser == null) {
                    parser = new SimpleStylesheetParser();
                }
                parser.readRules(reader);
                continue;
            }
            if (!lname.endsWith(".ttf") && !lname.endsWith(".otf") && !lname.endsWith(".ttc")) continue;
            fonts.add(name);
        }
        if (parser != null) {
            this.stylesheet = new Stylesheet(null, parser);
            fontMap = parser.getRules();
        }
        Enumeration srcs = fontMap.elements();
        while (srcs.hasMoreElements()) {
            Object srcobj = srcs.nextElement();
            if (!(srcobj instanceof String)) continue;
            String src = (String)srcobj;
            fonts.remove(src);
        }
        Iterator nakedFonts = fonts.iterator();
        while (nakedFonts.hasNext()) {
            try {
                String name = (String)nakedFonts.next();
                FontInputStream fin = this.fontStreamForName(name);
                OpenTypeFont font = new OpenTypeFont(fin, true);
                if (!font.canEmbedForReading()) continue;
                FontProperties key = new FontProperties(font.getFamilyName(), font.getWeight(), font.getStyle());
                fontMap.put(key, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fontLocator = new TemplateFontLocator(fontMap);
    }

    InputStream getInputStream(String src) throws IOException {
        if (this.zip != null) {
            ZipEntry entry = this.zip.getEntry(src);
            if (entry == null) {
                throw new IOException("Entry " + src + ": not found");
            }
            InputStream in = this.zip.getInputStream(entry);
            if (in == null) {
                throw new IOException("Entry " + src + ": cannot read");
            }
            return in;
        }
        return new FileInputStream(src);
    }

    FontInputStream fontStreamForName(String src) throws IOException {
        if (this.zip != null) {
            int len;
            ZipEntry entry = this.zip.getEntry(src);
            if (entry == null) {
                throw new IOException("Entry " + src + ": not found");
            }
            InputStream in = this.zip.getInputStream(entry);
            if (in == null) {
                throw new IOException("Entry " + src + ": cannot read");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                buffer.write(buf, 0, len);
            }
            return new ByteArrayFontInputStream(buffer.toByteArray());
        }
        return new FileFontInputStream(new File(src));
    }

    public FontLocator getFontLocator() {
        return this.fontLocator;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConversionTemplate getConversionTemplate(String path) throws IOException {
        Hashtable hashtable = sharedTemplates;
        synchronized (hashtable) {
            ConversionTemplate result = (ConversionTemplate)sharedTemplates.get(path);
            if (result == null) {
                result = new ConversionTemplate(new File(path));
                sharedTemplates.put(path, result);
            }
            return result;
        }
    }

    class TemplateFontLocator
    extends FontLocator {
        Hashtable fontMap;

        TemplateFontLocator(Hashtable fontMap) {
            this.fontMap = fontMap;
        }

        FontProperties substitute(FontProperties key) {
            if (key.getStyle() == 1 && key.getFamilyName().equals("Tahoma")) {
                key = new FontProperties("Verdana", key.getWeight(), key.getStyle());
            }
            return key;
        }

        String getFontSource(FontProperties key) {
            FontProperties key1;
            String fileName = (String)this.fontMap.get(key = this.substitute(key));
            if (fileName == null && (fileName = (String)this.fontMap.get(key1 = new FontProperties(key.getFamilyName(), key.getWeight() + 100, key.getStyle()))) == null) {
                key1 = new FontProperties(key.getFamilyName(), key.getWeight() - 100, key.getStyle());
                fileName = (String)this.fontMap.get(key);
                if (fileName == null) {
                    return null;
                }
            }
            return fileName;
        }

        public FontInputStream locateFont(FontProperties key) throws IOException {
            String src = this.getFontSource(key);
            if (src == null) {
                return null;
            }
            return ConversionTemplate.this.fontStreamForName(src);
        }

        public boolean hasFont(FontProperties key) {
            return this.getFontSource(key) != null;
        }
    }
}

