/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.style;

import com.adobe.dp.epub.opf.FontResource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.style.FontFace;
import com.adobe.dp.epub.style.PrototypeRule;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.Selector;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.SimpleStylesheetParser;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Stylesheet {
    StyleResource owner;
    Hashtable rulesBySelector = new Hashtable();
    Hashtable lockedRulesByProperties = new Hashtable();
    Vector content = new Vector();

    public Stylesheet(StyleResource owner) {
        this.owner = owner;
    }

    public Stylesheet(StyleResource owner, Reader reader) throws IOException {
        this.owner = owner;
        SimpleStylesheetParser parser = new SimpleStylesheetParser();
        parser.readRules(reader);
        this.initWithParser(parser);
    }

    public Stylesheet(StyleResource owner, SimpleStylesheetParser parser) throws IOException {
        this.owner = owner;
        this.initWithParser(parser);
    }

    private void initWithParser(SimpleStylesheetParser parser) {
        this.rulesBySelector = parser.getRules();
        Enumeration rules = this.rulesBySelector.elements();
        while (rules.hasMoreElements()) {
            Object robj = rules.nextElement();
            if (!(robj instanceof Rule)) continue;
            Rule rule = (Rule)robj;
            this.content.add(rule);
        }
    }

    public SimpleSelector getSimpleSelector(String elementName, String className) {
        return new SimpleSelector(elementName, className);
    }

    public Rule findRuleForSelector(Selector selector) {
        return (Rule)this.rulesBySelector.get(selector);
    }

    public Rule getRuleForSelector(Selector selector) {
        Rule rule = (Rule)this.rulesBySelector.get(selector);
        if (rule == null) {
            rule = new Rule(selector);
            this.content.add(rule);
            this.rulesBySelector.put(selector, rule);
        }
        return rule;
    }

    public FontFace createFontFace(FontResource fontResource) {
        FontFace fontFace = new FontFace(this, fontResource);
        this.content.add(fontFace);
        return fontFace;
    }

    public void lock(Rule rule) {
        rule.lock();
        if (rule.selector instanceof SimpleSelector && ((SimpleSelector)rule.selector).getElementName() == null) {
            this.lockedRulesByProperties.put(rule.properties, rule);
        }
    }

    public PrototypeRule createPrototypeRule() {
        return new PrototypeRule();
    }

    public Rule getClassRuleForPrototype(PrototypeRule props) {
        Rule rule = (Rule)this.lockedRulesByProperties.get(props.properties);
        return rule;
    }

    public Rule createRuleForPrototype(SimpleSelector selector, PrototypeRule props) {
        if (this.rulesBySelector.get(selector) != null) {
            throw new RuntimeException("rule already exists for ." + selector.toString());
        }
        Rule rule = new Rule(selector, props);
        this.content.add(rule);
        this.rulesBySelector.put(selector, rule);
        props.properties = null;
        this.lockedRulesByProperties.put(rule.properties, rule);
        return rule;
    }

    public Rule createClassRuleForPrototype(String className, PrototypeRule props) {
        SimpleSelector selector = this.getSimpleSelector(null, className);
        return this.createRuleForPrototype(selector, props);
    }

    public Rule createRuleForPrototype(String elementName, String className, PrototypeRule props) {
        SimpleSelector selector = this.getSimpleSelector(elementName, className);
        return this.createRuleForPrototype(selector, props);
    }

    public Iterator content() {
        return this.content.iterator();
    }

    public Hashtable getRules() {
        return this.rulesBySelector;
    }

    public void serialize(PrintWriter pout) {
        Iterator it = this.content();
        while (it.hasNext()) {
            Object cp = it.next();
            if (cp instanceof Rule) {
                ((Rule)cp).serialize(pout);
                continue;
            }
            if (!(cp instanceof FontFace)) continue;
            ((FontFace)cp).serialize(pout);
        }
    }

    public void addDirectStyles(Reader reader) throws IOException {
        SimpleStylesheetParser parser = new SimpleStylesheetParser();
        parser.readRules(reader);
        this.initWithParser(parser);
    }
}

