/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.otf;

import com.adobe.dp.epub.io.BufferedDataSource;
import com.adobe.dp.epub.opf.FontResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.otf.FontEmbeddingReport;
import com.adobe.dp.epub.style.BaseRule;
import com.adobe.dp.epub.style.FontFace;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.epub.style.QuotedString;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.Selector;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.SimpleStylesheetParser;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.epub.style.ValueList;
import com.adobe.dp.otf.FontInputStream;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.otf.FontProperties;
import com.adobe.dp.otf.OpenTypeFont;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public class FontSubsetter
implements FontEmbeddingReport {
    Publication epub;
    Stack entryStack = new Stack();
    FontListEntry currentEntry;
    StyleResource styleResource;
    Vector styles;
    Hashtable subsetters = new Hashtable();
    Hashtable subsetterLists = new Hashtable();
    FontLocator fontLocator;
    Set missingFonts = new TreeSet();
    Set prohibitedFonts = new TreeSet();
    long totalPlay;

    public FontSubsetter(Publication epub, StyleResource styleResource, FontLocator locator) {
        this.styleResource = styleResource;
        this.fontLocator = locator;
    }

    public Iterator missingFonts() {
        return this.missingFonts.iterator();
    }

    public Iterator prohibitedFonts() {
        return this.prohibitedFonts.iterator();
    }

    public Iterator usedFonts() {
        Iterator keys = this.subsetters.keySet().iterator();
        TreeSet<FontProperties> usedFonts = new TreeSet<FontProperties>();
        while (keys.hasNext()) {
            FontEntry entry = (FontEntry)keys.next();
            if (!entry.subsetter.used) continue;
            FontProperties prop = new FontProperties(entry.familyName, entry.weight, entry.style);
            usedFonts.add(prop);
        }
        return usedFonts.iterator();
    }

    public void setStyles(Vector styles) {
        this.styles = styles;
    }

    private ValueList parseFamily(Object family) {
        if (family instanceof ValueList) {
            return (ValueList)family;
        }
        try {
            return SimpleStylesheetParser.readValueList(family.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int parseWeight(String weight) {
        if (weight.length() == 3 && weight.endsWith("00") && Character.isDigit(weight.charAt(0))) {
            try {
                return Integer.parseInt(weight);
            }
            catch (Exception exception) {
            }
        } else if (weight.toLowerCase().equals("bold")) {
            return 700;
        }
        return 400;
    }

    private int parseStyle(String style) {
        if ((style = style.toLowerCase()).equals("italic")) {
            return 1;
        }
        if (style.equals("oblique")) {
            return 2;
        }
        return 0;
    }

    private void processSelector(Stylesheet stylesheet, Selector selector) {
        Rule rule = stylesheet.findRuleForSelector(selector);
        if (rule != null) {
            Object style;
            Object weight;
            Object family = rule.get("font-family");
            if (family != null) {
                this.currentEntry.familyName = this.parseFamily(family.toString());
            }
            if ((weight = rule.get("font-weight")) != null) {
                this.currentEntry.weight = this.parseWeight(weight.toString());
            }
            if ((style = rule.get("font-style")) != null) {
                this.currentEntry.style = this.parseStyle(style.toString());
            }
        }
    }

    private void processRule(BaseRule rule) {
        Object style;
        Object weight;
        Object family = rule.get("font-family");
        if (family != null) {
            this.currentEntry.familyName = this.parseFamily(family.toString());
        }
        if ((weight = rule.get("font-weight")) != null) {
            this.currentEntry.weight = this.parseWeight(weight.toString());
        }
        if ((style = rule.get("font-style")) != null) {
            this.currentEntry.style = this.parseStyle(style.toString());
        }
    }

    private void builtInStyles(String name) {
        if (name.equals("h1") || name.equals("h2") || name.equals("h3") || name.equals("h4") || name.equals("h5") || name.equals("h6") || name.equals("b") || name.equals("strong")) {
            this.currentEntry.weight = 700;
        } else if (name.equals("i") || name.equals("em")) {
            this.currentEntry.style = 1;
        }
    }

    private String getStringValue(Object val) {
        if (val instanceof QuotedString) {
            return ((QuotedString)val).getText();
        }
        return val.toString();
    }

    public void push(Element e) {
        if (this.currentEntry == null) {
            this.currentEntry = new FontListEntry();
        } else {
            this.entryStack.push(this.currentEntry);
            this.currentEntry = this.currentEntry.cloneEntry();
        }
        String name = e.getElementName();
        this.builtInStyles(name);
        int len = this.styles.size();
        int i = 0;
        while (i < len) {
            StyleResource res = (StyleResource)this.styles.elementAt(i);
            Stylesheet stylesheet = res.getStylesheet();
            String className = e.getClassName();
            SimpleSelector selector = stylesheet.getSimpleSelector(name, null);
            this.processSelector(stylesheet, selector);
            if (className != null) {
                selector = stylesheet.getSimpleSelector(null, className);
                this.processSelector(stylesheet, selector);
                selector = stylesheet.getSimpleSelector(name, className);
                this.processSelector(stylesheet, selector);
            }
            ++i;
        }
        InlineStyleRule style = e.getStyle();
        if (style != null) {
            this.processRule(style);
        }
        if (this.currentEntry.familyName != null) {
            this.currentEntry.subsetterList = (SubsetterEntry[])this.subsetterLists.get(this.currentEntry);
            if (this.currentEntry.subsetterList == null) {
                Vector<SubsetterEntry> subsetterList = new Vector<SubsetterEntry>();
                Iterator families = this.currentEntry.familyName.values();
                while (families.hasNext()) {
                    String family = this.getStringValue(families.next());
                    if (family.equals("serif") || family.equals("sans-serif") || family.equals("monospace")) continue;
                    FontEntry entry = new FontEntry();
                    entry.familyName = family;
                    entry.style = this.currentEntry.style;
                    entry.weight = this.currentEntry.weight;
                    SubsetterEntry subsetter = (SubsetterEntry)this.subsetters.get(entry);
                    if (subsetter == null) {
                        try {
                            FontProperties prop = new FontProperties(entry.familyName, entry.weight, entry.style);
                            FontInputStream stream = this.fontLocator.locateFont(prop);
                            if (stream != null) {
                                OpenTypeFont font = new OpenTypeFont(stream);
                                if (font.canEmbedForReading() && font.canSubset()) {
                                    subsetter = new SubsetterEntry();
                                    subsetter.font = font;
                                    this.subsetters.put(entry, subsetter);
                                    entry.subsetter = subsetter;
                                } else {
                                    this.prohibitedFonts.add(prop);
                                }
                            } else {
                                this.missingFonts.add(prop);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (subsetter == null) continue;
                    subsetterList.add(subsetter);
                }
                this.currentEntry.subsetterList = new SubsetterEntry[subsetterList.size()];
                subsetterList.copyInto(this.currentEntry.subsetterList);
                this.subsetterLists.put(this.currentEntry, this.currentEntry.subsetterList);
            }
        }
    }

    public void pop(Element e) {
        this.currentEntry = this.entryStack.isEmpty() ? null : (FontListEntry)this.entryStack.pop();
    }

    public void play(String text) {
        if (this.currentEntry != null && this.currentEntry.subsetterList != null) {
            long t0 = System.currentTimeMillis();
            int subsetterListLen = this.currentEntry.subsetterList.length;
            int stringLength = text.length();
            int i = 0;
            while (i < stringLength) {
                char c = text.charAt(i);
                int j = 0;
                while (j < subsetterListLen) {
                    SubsetterEntry subsetter = this.currentEntry.subsetterList[j];
                    if (subsetter.font != null && subsetter.font.play(c)) {
                        subsetter.used = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            long t1 = System.currentTimeMillis();
            this.totalPlay += t1 - t0;
        }
    }

    public void addFonts(Publication epub) {
        Enumeration list = this.subsetters.keys();
        while (list.hasMoreElements()) {
            FontEntry entry = (FontEntry)list.nextElement();
            if (!entry.subsetter.used) continue;
            BufferedDataSource bds = new BufferedDataSource();
            try {
                OpenTypeFont font = entry.subsetter.font;
                String resName = String.valueOf(entry.familyName.replaceAll(" ", "-")) + "-" + entry.weight;
                switch (entry.style) {
                    case 1: {
                        resName = String.valueOf(resName) + "-Italic";
                        break;
                    }
                    case 2: {
                        resName = String.valueOf(resName) + "-Oblique";
                    }
                }
                String primaryUUID = epub.getPrimaryIdentifier();
                if (primaryUUID != null && primaryUUID.startsWith("urn:uuid:")) {
                    resName = String.valueOf(resName) + "-" + primaryUUID.substring(9);
                }
                bds.getOutputStream().write(font.getSubsettedFont());
                FontResource fontResource = epub.createFontResource(String.valueOf(epub.getContentFolder()) + "/fonts/" + resName + ".otf", bds);
                FontFace face = this.styleResource.getStylesheet().createFontFace(fontResource);
                face.set("font-family", String.valueOf('\'') + entry.familyName + '\'');
                switch (entry.weight) {
                    case 400: {
                        face.set("font-weight", "normal");
                        break;
                    }
                    case 700: {
                        face.set("font-weight", "bold");
                        break;
                    }
                    default: {
                        face.set("font-weight", Integer.toString(entry.weight));
                    }
                }
                switch (entry.style) {
                    case 1: {
                        face.set("font-style", "italic");
                        break;
                    }
                    case 2: {
                        face.set("font-style", "oblique");
                        break;
                    }
                    default: {
                        face.set("font-style", "normal");
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class FontEntry {
        SubsetterEntry subsetter;
        String familyName;
        int weight = 400;
        int style = 0;

        FontEntry() {
        }

        FontEntry cloneEntry() {
            FontEntry entry = new FontEntry();
            entry.familyName = this.familyName;
            entry.weight = this.weight;
            entry.style = this.style;
            return entry;
        }

        public int hashCode() {
            return this.familyName.hashCode() + this.weight + this.style;
        }

        public boolean equals(Object other) {
            if (other.getClass() != this.getClass()) {
                return false;
            }
            FontEntry o = (FontEntry)other;
            return o.familyName.equals(this.familyName) && o.weight == this.weight && o.style == this.style;
        }
    }

    static class FontListEntry {
        SubsetterEntry[] subsetterList;
        ValueList familyName;
        int weight = 400;
        int style = 0;

        FontListEntry() {
        }

        FontListEntry cloneEntry() {
            FontListEntry entry = new FontListEntry();
            entry.familyName = this.familyName;
            entry.weight = this.weight;
            entry.style = this.style;
            return entry;
        }

        public int hashCode() {
            return this.familyName.hashCode() + this.weight + this.style;
        }

        public boolean equals(Object other) {
            if (other.getClass() != this.getClass()) {
                return false;
            }
            FontListEntry o = (FontListEntry)other;
            return o.familyName.equals(this.familyName) && o.weight == this.weight && o.style == this.style;
        }
    }

    class SubsetterEntry {
        OpenTypeFont font;
        boolean used;

        SubsetterEntry() {
        }
    }
}

