/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.ops;

import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.ops.Element;

public class XRef {
    OPSResource targetResource;
    Element targetElement;
    int playOrder;
    int usage;
    public static final int USAGE_TOC = 1;
    public static final int USAGE_PAGE = 2;
    public static final int USAGE_REF = 4;

    public XRef(OPSResource resource, Element element) {
        this.targetElement = element;
        this.targetResource = resource;
    }

    public Element getTagetElement() {
        return this.targetElement;
    }

    public String getTargetId() {
        if (this.targetElement == null) {
            return null;
        }
        if (this.targetElement.id == null) {
            // empty if block
        }
        this.targetElement.document.assignId(this.targetElement);
        return this.targetElement.id;
    }

    public OPSResource getTargetResource() {
        return this.targetResource;
    }

    public String makeReference(Resource fromResource) {
        return fromResource.makeReference(this.targetResource, this.getTargetId());
    }

    public int getPlayOrder() {
        return this.playOrder;
    }

    public void setPlayOrder(int playOrder) {
        this.playOrder = playOrder;
    }

    public void requestPlayOrder() {
        this.playOrder = -1;
    }

    public boolean playOrderNeeded() {
        return this.playOrder != 0;
    }

    public void addUsage(int usage) {
        this.usage |= usage;
    }

    public int getUsage() {
        return this.usage;
    }
}

