/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.ops;

import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.otf.FontSubsetter;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.Selector;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public abstract class Element {
    OPSDocument document;
    String className;
    InlineStyleRule style;
    String elementName;
    String id;
    Vector children = new Vector();
    XRef selfRef;

    Element(OPSDocument document, String name) {
        this.document = document;
        this.elementName = name;
    }

    public abstract String getNamespaceURI();

    abstract Element cloneElementShallow(OPSDocument var1);

    public Element cloneElementShallow() {
        return this.cloneElementShallow(this.document);
    }

    protected Object getBuiltInProperty(String propName) {
        return null;
    }

    static Object getValue(Stylesheet stylesheet, Selector selector, String propName) {
        Rule rule = stylesheet.findRuleForSelector(selector);
        if (rule != null) {
            return rule.get(propName);
        }
        return null;
    }

    public Object getCascadedProperty(String propName) {
        Object value;
        InlineStyleRule style = this.getStyle();
        if (style != null && (value = style.get(propName)) != null) {
            return value;
        }
        Vector styleResources = this.document.styleResources;
        int len = styleResources.size();
        int i = len - 1;
        while (i >= 0) {
            Object value2;
            SimpleSelector selector;
            Stylesheet stylesheet = ((StyleResource)styleResources.get(i)).getStylesheet();
            if (this.className != null) {
                selector = stylesheet.getSimpleSelector(this.elementName, this.className);
                value2 = Element.getValue(stylesheet, selector, propName);
                if (value2 != null) {
                    return value2;
                }
                selector = stylesheet.getSimpleSelector(null, this.className);
                value2 = Element.getValue(stylesheet, selector, propName);
                if (value2 != null) {
                    return value2;
                }
            }
            if ((value2 = Element.getValue(stylesheet, selector = stylesheet.getSimpleSelector(this.elementName, null), propName)) != null) {
                return value2;
            }
            --i;
        }
        return this.getBuiltInProperty(propName);
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void add(Object child) {
        this.children.add(child);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.document.setElementId(this, id);
    }

    public Iterator content() {
        return this.children.iterator();
    }

    public Object getLastChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.lastElement();
    }

    public XRef getSelfRef() {
        if (this.selfRef == null) {
            this.document.assignId(this);
            this.selfRef = new XRef(this.document.resource, this);
        }
        return this.selfRef;
    }

    SMapImpl getAttributes() {
        SMapImpl attrs = new SMapImpl();
        if (this.className != null) {
            attrs.put(null, "class", this.className);
        }
        if (this.id != null) {
            attrs.put(null, "id", this.id);
        }
        if (this.style != null) {
            attrs.put(null, "style", this.style);
        }
        return attrs;
    }

    public void addFonts(FontSubsetter subsetter) {
        subsetter.push(this);
        try {
            Iterator children = this.content();
            if (children != null) {
                while (children.hasNext()) {
                    Object child = children.next();
                    if (child instanceof Element) {
                        ((Element)child).addFonts(subsetter);
                        continue;
                    }
                    if (!(child instanceof String)) continue;
                    subsetter.play((String)child);
                }
            }
        }
        finally {
            subsetter.pop(this);
        }
    }

    boolean isSection() {
        return false;
    }

    private static int getUTF8Length(String s) {
        try {
            return s.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 unsupported???");
        }
    }

    int getElementSize() {
        int size = this.elementName.length() + 3;
        if (this.className != null) {
            size += this.className.length() + 9;
        }
        if (this.selfRef != null) {
            size += 10;
        }
        size = this.children.size() == 0 ? ++size : (size += this.elementName.length() + 5);
        return size;
    }

    int getPeelingBonus() {
        return 0;
    }

    boolean canPeelChild() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    final int getEstimatedSize() {
        size = this.getElementSize();
        it = this.content();
        if (it.hasNext()) ** GOTO lbl12
        return size;
lbl-1000:
        // 1 sources

        {
            next = it.next();
            if (next instanceof Element) {
                size += ((Element)next).getEstimatedSize();
            } else if (next instanceof String) {
                size += Element.getUTF8Length((String)next);
            }
            ++size;
lbl12:
            // 2 sources

            ** while (it.hasNext())
        }
lbl13:
        // 1 sources

        return size;
    }

    void transferToDocument(OPSDocument newDoc) {
        if (this.id != null) {
            this.document.idMap.remove(this.id);
        }
        this.document = newDoc;
        if (this.id != null) {
            this.document.idMap.put(this.id, this);
        }
        if (this.selfRef != null) {
            this.selfRef.targetResource = newDoc.resource;
        }
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Element)) continue;
            ((Element)next).transferToDocument(newDoc);
        }
    }

    final Element peelElements(OPSDocument newDoc, int targetSize) {
        SizeRemains sr = new SizeRemains();
        sr.size = targetSize + 1000;
        return this.peelElements(newDoc, sr);
    }

    /*
     * Enabled aggressive block sorting
     */
    final Element peelElements(OPSDocument newDoc, SizeRemains remains) {
        int size = this.getElementSize();
        int bonus = this.getPeelingBonus();
        remains.size -= size;
        if (bonus >= 0 && bonus > remains.size) {
            this.transferToDocument(newDoc);
            return this;
        }
        Element result = null;
        boolean canPeelChild = this.canPeelChild();
        int i = 0;
        while (i < this.children.size()) {
            block9: {
                Object next;
                block10: {
                    next = this.children.elementAt(i);
                    if (!(next instanceof Element)) break block10;
                    Element child = (Element)next;
                    if (result == null) {
                        if (canPeelChild) {
                            Element p = child.peelElements(newDoc, remains);
                            if (p != null) {
                                result = this.cloneElementShallow(newDoc);
                                result.add(p);
                                if (p == child) {
                                    this.children.remove(i);
                                    continue;
                                }
                            }
                            break block9;
                        } else {
                            remains.size -= child.getEstimatedSize();
                        }
                        break block9;
                    } else {
                        this.children.remove(i);
                        child.transferToDocument(newDoc);
                        result.add(child);
                        continue;
                    }
                }
                if (next instanceof String) {
                    remains.size -= Element.getUTF8Length((String)next);
                }
            }
            --remains.size;
            ++i;
        }
        return result;
    }

    public void generateTOCFromHeadings(Stack headings, int depth) {
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Element)) continue;
            ((Element)next).generateTOCFromHeadings(headings, depth);
        }
    }

    void serializeChildren(XMLSerializer ser) {
        boolean section = this.isSection();
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Element) {
                ((Element)next).serialize(ser);
            } else if (next instanceof String) {
                char[] arr = ((String)next).toCharArray();
                ser.text(arr, 0, arr.length);
            }
            if (!section) continue;
            ser.newLine();
        }
    }

    boolean makeNSDefault() {
        return false;
    }

    void serialize(XMLSerializer ser) {
        boolean section = this.isSection();
        String ns = this.getNamespaceURI();
        ser.startElement(ns, this.elementName, this.getAttributes(), this.makeNSDefault());
        if (section) {
            ser.newLine();
        }
        this.serializeChildren(ser);
        ser.endElement(ns, this.elementName);
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Element) {
                sb.append(((Element)next).getText());
                continue;
            }
            if (!(next instanceof String)) continue;
            sb.append((String)next);
        }
        return sb.toString();
    }

    public InlineStyleRule getStyle() {
        return this.style;
    }

    public void setStyle(InlineStyleRule style) {
        this.style = style;
    }

    public int assignPlayOrder(int playOrder) {
        if (this.selfRef != null && this.selfRef.playOrderNeeded()) {
            this.selfRef.setPlayOrder(++playOrder);
        }
        Iterator it = this.content();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Element)) continue;
            playOrder = ((Element)next).assignPlayOrder(playOrder);
        }
        return playOrder;
    }

    private static class SizeRemains {
        int size;

        private SizeRemains() {
        }
    }
}

