/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.ops.OPSDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import java.util.Vector;

public class OPSResource
extends Resource {
    OPSDocument document;

    OPSResource(String name) {
        super(name, "application/xhtml+xml", null);
    }

    OPSResource(String name, String mediaType) {
        super(name, mediaType, null);
    }

    public OPSDocument getDocument() {
        if (this.document == null) {
            this.document = new OPSDocument(this);
        }
        return this.document;
    }

    OPSResource[] splitLargeChapter(Publication pub, int sizeToSplit) {
        OPSResource r;
        if (!this.mediaType.equals("application/xhtml+xml")) {
            return null;
        }
        int targetSize = sizeToSplit;
        Vector<OPSResource> res = new Vector<OPSResource>();
        res.add(this);
        OPSDocument doc = this.document;
        while (true) {
            String name;
            if (!doc.peelOffBack((r = pub.createOPSResource(name = pub.makeUniqueResourceName(this.getName()))).getDocument(), targetSize)) break;
            doc = r.getDocument();
            res.add(r);
        }
        pub.removeResource(r);
        Object[] result = new OPSResource[res.size()];
        res.copyInto(result);
        return result;
    }

    public void generateTOCFromHeadings(Stack headings, int depth) {
        if (this.mediaType.equals("application/xhtml+xml")) {
            this.getDocument().getBody().generateTOCFromHeadings(headings, depth);
        }
    }

    public void serialize(OutputStream out) throws IOException {
        this.getDocument().serialize(out);
    }
}

