/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.io.DataSource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class FontResource
extends Resource {
    Publication owner;

    FontResource(Publication owner, String name, DataSource source) {
        super(name, "application/octet-stream", source);
        this.owner = owner;
    }

    public void serialize(OutputStream out) throws IOException {
        block14: {
            byte[] mask;
            int headerLen;
            if (this.owner.useIDPFFontMangling) {
                headerLen = 1040;
                mask = this.owner.makeIDPFXORMask();
            } else {
                headerLen = 1024;
                mask = this.owner.makeAdobeXORMask();
            }
            Deflater def = null;
            try {
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    InputStream in = this.source.getInputStream();
                    if (mask != null) {
                        def = new Deflater(9, true);
                        in = new DeflaterInputStreamImpl(in, def);
                    }
                    boolean first = true;
                    while ((len = in.read(buffer)) > 0) {
                        if (first && mask != null) {
                            first = false;
                            int i = 0;
                            while (i < headerLen) {
                                buffer[i] = (byte)(buffer[i] ^ mask[i % mask.length]);
                                ++i;
                            }
                        }
                        out.write(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (def != null) {
                        def.end();
                        def = null;
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (def != null) {
                    def.end();
                    def = null;
                }
                throw throwable;
            }
            if (def != null) {
                def.end();
                def = null;
            }
        }
        out.close();
    }

    public boolean canCompress() {
        return false;
    }

    static class DeflaterInputStreamImpl
    extends InputStream {
        InputStream in;
        Deflater def;

        DeflaterInputStreamImpl(InputStream in, Deflater def) {
            this.in = in;
            this.def = def;
        }

        public void close() throws IOException {
            this.def.end();
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            while (len > 0) {
                int got = this.def.deflate(b, off, len);
                if (got <= 0) {
                    if (this.in == null || !this.def.needsInput()) break;
                    byte[] buffer = new byte[4096];
                    int rlen = this.in.read(buffer);
                    if (rlen <= 0) {
                        this.def.finish();
                        this.in.close();
                        this.in = null;
                        continue;
                    }
                    this.def.setInput(buffer, 0, rlen);
                    continue;
                }
                total += got;
                off += got;
                len -= got;
            }
            return total;
        }
    }
}

