﻿/**
 * 画廊卡片
 * @module speechui/cards
 * @author yuwang@iflytek.com
 * @date 2013/06/09
 */
define(function (require, exports, module) {
    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');
    var speechuiCommon = require('../common/common');
    var speechUIDir = speechuiCommon.getSpeechUIBase();

    /**
     * 画廊卡片类构造函数
     * @constructor
     */
    function GalleryCard(option) {
        var _galleryObj = option;                               //图片信息集合
        var _dom;                                               //dom
        var _self = this;                                       //画廊卡片对象
        this._currIndex = 0;                                     //当前图片的索引
        this.isAnimating=false;
        var _imageEles;                                         //图片列表集合
        var _imageDes;                                          //图片描述信息的集合
        var _imageCount;                                        //图片的个数
        var _imagePages;
        var _galleryImgContainer
        var _galleryImgdiv;
        var _eleImgs;

        /**
         *初始化画廊卡片
         */
        function init() {
            //取原始模版
            _self.getTemplate().done(function(tpl){
                //给每张画廊图片赋值index
                for (var i = 0; i < _galleryObj.imageInfos.length; i++) {
                    var obj = _galleryObj.imageInfos[i];
                    obj.index++;
                }

                //对option对象的infoList排序
                _self._sortImgByIndex(_galleryObj.imageInfos);
                option.speechUIDir = speechUIDir;
                console.log("%c 【画廊卡片信息】 %o","color:green",option);
                var html = tplparse.render(tpl, option);          //模版解析
                _dom = $(html);                                   //为防止卡片间相互影响，使用dom
                _self.dom = _dom;

                _galleryImgContainer = _dom.find('.classified_box');
                _galleryImgdiv = _dom.find('.btn_gallery_add');
                _eleImgs = _dom.find('.btn_gallery_add span img');
                _imageEles = _dom.find('.btn_gallery_add span');
                _imageDes = _dom.find('.gallery_ms p');
                _imagePages = _dom.find('.gallery_btn_group2 a');
                _imageCount = _galleryObj.imageInfos.length;
                //初始化样式
                _self._showImages(0);
                _self._displayDes(0);

                setTimeout(function(){
                    var domHeight = parseInt(_dom[0].style.height);
                    console.log(domHeight);
                    _galleryImgContainer[0].style.height = domHeight - 140+"px";
                    _galleryImgdiv[0].style.height = domHeight - 140+"px";
                    for(var i=0;i<+_imageEles.length;i++){
                        _imageEles[i].style.lineHeight = domHeight - 160+"px";
                    }
                    $(_imageEles[0]).hide();
                    $(_imageEles[0]).fadeIn();
                },100);

                //默认显示第一个按钮的样式
                _imagePages.eq(0).addClass("gbg_active2");

                _bindEvents();
            });
        }

        /**
         * 事件绑定
         * @private
         */
        function _bindEvents() {
            // 上一张图片
            _dom.find('.btn_scene_prev').bind("vclick",function () {
                if(_self.isAnimating){return;}
                _self.isAnimating = true;
                _self.onPreImg();
            });

            // 下一张图片
            _dom.find('.btn_scene_next').bind("vclick",function () {
                if(_self.isAnimating){return;}
                _self.isAnimating = true;
                _self.onNexImg();
            });

            // 按钮
            _dom.find(".gallery_btn_group2 a").bind("vclick",function () {
                if(_self.isAnimating){return;}
                _self.isAnimating = true;
                var button = $(this);
                var imageIndex = button.index();
                var pageNum = _self._getimagePages();

                $(pageNum).removeClass("gbg_active2");
                button.addClass("gbg_active2");
                _self._showImages(imageIndex);
                _self._displayDes(imageIndex);
            });
        }

        /**
         * 上一张
         * @private
         */
        this.onPreImg = function () {
            var pageNum = _self._getimagePages();
            var desIndex=0;
            if (this._currIndex === 0) {
                //desIndex = _imageCount - 1;
                _self.isAnimating=false;
                return;
            } else {
                desIndex = this._currIndex - 1;
            }
            pageNum.removeClass("gbg_active2");
            pageNum.eq(desIndex).addClass("gbg_active2");

            _self._showImages(desIndex);
            _self._displayDes(desIndex);
        }

        /**
         * 下一张
         * @private
         */
        this.onNexImg = function () {
            var pageNum = _self._getimagePages();
            var desIndex=0;
            if (this._currIndex === _imageCount - 1) {
                _self.isAnimating=false;
                return;
            } else {
                desIndex = this._currIndex + 1;
            }
            pageNum.removeClass("gbg_active2");
            pageNum.eq(desIndex).addClass("gbg_active2");

            _self._showImages(desIndex);
            _self._displayDes(desIndex);
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageEles = function () {
            return  _imageEles;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getImageDes = function () {
            return  _imageDes;
        }

        /**
         *
         * @returns {Array.<jQuery>}
         * @private
         */
        this._getimagePages = function () {
            return  _imagePages;
        }

        /**
         *
         * @returns {jQuery}
         */
        this.getContent = function () {
            return  _dom;
        }

        init();
    }

    GalleryCard.prototype = new _cardbase.CardBase();
    GalleryCard.prototype.constructor = GalleryCard;

    /**
     * 根据图片的index，用冒泡排序法进行排序
     * @param { Array.<GalleryImageInfo> } imgInfoArr 图片信息列表
     * @private
     */
    GalleryCard.prototype._sortImgByIndex = function (imgInfoArr) {
        //外层循环，共要进行arr.length次求最大值操作
        for (var i = 0; i < imgInfoArr.length; i++) {
            //内层循环，找到第i大的元素，并将其和第i个元素交换
            for (var j = i; j < imgInfoArr.length; j++) {
                if (imgInfoArr[i].index > imgInfoArr[j].index) {
                    //交换两个对象的位置
                    var temp = imgInfoArr[i];
                    imgInfoArr[i] = imgInfoArr[j];
                    imgInfoArr[j] = temp;
                }
            }
        }
    }

    /**
     * 图片切换
     * @param {number} index
     */
    GalleryCard.prototype._showImages = function (index) {
        var _self= this;
        setTimeout(function(){
            _self.isAnimating = false;
        },350);
        console.log(this._currIndex,index);
        var imageEles = this._getImageEles();
        if(this._currIndex === index){
            if(this._currIndex === 0){
                $.each(imageEles, function (eleIdx, imageEle) {
                    if (index == eleIdx) {
                        $(imageEle).css("display","block");
                        $(imageEle).show();
                    }else {
                        $(imageEle).hide();
                    }
                });
            }
            return;
        }
        if(index<this._currIndex){
            //说明向左翻页，动画向右
            $.each(imageEles, function (eleIdx, imageEle) {
                if (index == eleIdx) {
                    $(imageEle).css({"left":"-600px"});
                    $(imageEle).animate({"left":"0px"},300,function(){
                        //_self.isAnimating = false;
                    });
                    $(imageEle).show();
                }else {
                    $(imageEle).hide();
                    $(imageEle).animate({"left":"600px"},300,function(){
                        $(imageEle).hide();
                    });
                }
            });
        }
        if(index>this._currIndex){
            //说明向右翻页，动画向左
            $.each(imageEles, function (eleIdx, imageEle) {
                if (index == eleIdx) {
                    $(imageEle).css({"left":"600px"});
                    $(imageEle).animate({"left":"0px"},300,function(){
                        //_self.isAnimating = false;
                    });
                    $(imageEle).show();
                }else {
                    $(imageEle).hide();
                    $(imageEle).animate({"left":"-600px"},300,function(){
                        $(imageEle).hide();
                    });
                }
            });
        }

        this._currIndex = index;
    }

    /**
     * 显示匹配元素的描述信息
     * @param {number} index
     */
    GalleryCard.prototype._displayDes = function (index) {

        var imageDes = this._getImageDes();

        $.each(imageDes, function (eleIdx, imageDes) {
            if (index == eleIdx) {
                $(imageDes).show();
            } else {
                $(imageDes).hide();
            }
        });
    }

    /**
     * @inheritDoc
     */
    GalleryCard.prototype.getCardName = function () {
        return _define.CardName.Gallery;
    };

    /**
     * @export
     */
    exports.Constructor = GalleryCard;

});