var fs = require('fs');
var assert = require('assert');
var thrift = window.require('./node_modules/logcenter/lib/thrift');
var uploadSvc = window.require('./node_modules/logcenter/gen_js/UploadSvc');
var ttypes = window.require('./node_modules/logcenter/gen_js/api_upload_types');
var TrackParam = require('./paramType').TrackParam;

function TrackService() {

	var _self = this;
	var access_token = '';
	var initialzed = false;
	var client = null;
	var paramFactort = new TrackParam(); 
	var userTracks = new Array();
	var _config = {
		appkey		: "",
		appsecret	: "",
		username	: "",
		userid		: "",
		host		: "",
		port		: 80,
		path		: ""
	};

	//初始化客户端
	function initClient(callback) {
		var options = {
			transport : thrift.TBufferedTransport,
			protocol : thrift.TBinaryProtocol,
			path: _config["path"] + '/upload_log',
	  		headers: {"Connection": "keep-alive"},
	  		https:false
		};
		// 创建http连接
		var connection = thrift.createHttpConnection(_config.host, _config.port, options);
		connection.on('error', function(err) {
			//assert(false, err);
			console.log('thrift.createHttpConnection error: maybe offline, please check');
		});
		client = thrift.createHttpClient(uploadSvc, connection);
		//测试客户端是否可连接
		client.test_connect(function(err,res) {
			callback(err, res);
		});
	}

	//初始化配置和客户端
	this.Init = function(config, callback) {
		if(!initialzed) {
			for(var attr in config) {
				if(_config[attr] != undefined) {
					_config[attr] = config[attr];
				}
			}
			initClient(function(err, response) {
				if('success' == response) {
					initialzed = true;
				}
				else {
					initialzed = false;
				}
				callback(err, response);
			});
		}
	}

	this.AddTrack = function(param) {
		if(paramFactort.CheckParam(param)) {
			userTracks.push(param);
			return true;
		} else {
			return false;
		}
	}

	this.AddEntryTrack = function(module) {
		var param = paramFactort.CreateParam();
		param.action = "entry";
		param.module = module;
		return _self.AddTrack(param);
	}

	this.AddQuiteTrack = function(module) {
		var param = paramFactort.CreateParam();
		param.action = "quit";
		param.module = module;
		return _self.AddTrack(param);
	}

	this.AddTiggerTrack = function(module, action, params, result) {
		var param = paramFactort.CreateParam();
		param.action = action;
		param.module = module;
		param.param = params;
		param.result = result;
		return _self.AddTrack(param);
	}

	//上传监控日志
	this.UploadTrackLog = function(callback) {
		if(initialzed) {
			if(userTracks.length > 0) {
				console.log(JSON.stringify(userTracks));
				client.upload_log(JSON.stringify(userTracks), function(err, res) {
					if("success" == res) {
						userTracks = [];
					}
					callback(err, res);
				});
			} else {
				callback(400, "上传数据为空");
			}
			
		} else {
			callback(500, "服务未初始化");
		}
	}

	//获取token
	this.GetToken = function(callback) {
		if(initialzed) {
			client.get_token(function(err, res) {
				callback(err, res);
			})
		}
		else {
			callback(500, "服务未初始化");
		}
	}
}

exports.TrackService = TrackService;