/**
 * Created with JetBrains WebStorm.
 * User: Cmma
 * Date: 7/11/14
 * Time: 4:46 PM
 * To change this template use File | Settings | File Templates.
 */



function PPTTemplate() {
    var _self = this;

    this.controls = {
        pptDes: $("#pptDescription"),
        pptFile:$("#filePath"),
        pptTitle:$("#pptTitle")
    }

    this.PPTContext = {
        "ClickToAddTittle": "单击此处添加标题",
        "ClickToAddDescription": "单击此处添加描述"
    }

    this.pptFilePath = "";

    this.setFilePath = function(path) {
        _self.pptFilePath = path;
        $("#pptFilePanel")[0].innerHTML = path;
    }


    this.init = function() {
        $("#pptDescriptionPanel").focus(function () {
            if (this.value == "单击此处添加描述")
                this.value = '';
        });

        $("#pptDescriptionPanel").blur(function () {
            if (this.value == '')
                this.value = "单击此处添加描述";
        });

        $("#pptTitle").bind('input propertychange', function() {
            var titleLengthArr= _calcStrLength(this.value);
            var titleStrLength = titleLengthArr[0];
            var mostIndex = titleLengthArr[1];
            if (titleStrLength>62) {
                //标题过长，截断处理
                this.value = this.value.substr(0, mostIndex+1);
            }
        });

        $("#pptDescription").bind('input propertychange', function() {
            var descriptLengthArr= _calcStrLength( $("#pptDescription").val());
            var descriptStrLength = descriptLengthArr[0];
            var mostIndex = descriptLengthArr[1];
            if (descriptStrLength>62) {
                //标题过长，截断处理
                $("#pptDescription").val($("#pptDescription").val().substr(0, mostIndex+1));
            }
        });

        //计算标题整体字符所占长度
        function _calcStrLength(str){
            var len = 0;
            //最多实际能放下的“当前”字符串的长度位置
            var mostIndex = 0;
            for (var i = 0; i < str.length; i++) {
                var char = str.charCodeAt(i);
                //单字节加1
                if ((char >= 0x0001 && char <= 0x007e) || (0xff60 <= char && char <= 0xff9f)) {
                    len++;
                }
                else {
                    len += 1.7;
                }
                if(len<62){
                    mostIndex = i;
                }
            }
            return [len,mostIndex];
        }
    }

    this.getFilePath = function() {
        return _self.pptFilePath;
    }


    this.setOperMsg = function(msg) {
        $("#pptMsg")[0].innerHTML = msg;
    }
    this.cleanOperMsg = function() {
        $("#pptMsg")[0].innerHTML = "";
    }

    this.setThumbNailPath = function(path) {
        $("#pptImgBtn")[0].src = path;

    }

    this.SetBusyStatus = function() {
        $("#pptConverting").show();
        $("#pptImgBtn").hide();
    }

    this.SetFinishedStatus = function() {
        $("#pptConverting").hide();
        $("#pptImgBtn").show();
    }

    this.UpdateWidgetInfo = function(jsonObj) {

        _self.controls.pptTitle.val(jsonObj.title);
        _self.controls.pptDes.val(jsonObj.des);
        _self.setThumbNailPath(jsonObj.thumbnail);

    }

//    this.selectFile = function(callback) {
//        var option = {multiple: true, accept: ".ppt, .pptx"};
//        DialogUtil.openFileDialog(option).done(function (filePath) {
//            callback(filePath);
//        });
//    }


    this.PPT2Images = function(filePath, desDir, modulePath,baseName, callback) {



    }

    this.getpptInfo = function(callback) {
        var imgArrJson = [];
        var pptInfo = {"cardtype": "PPT", "file":"", "title": _self.controls.pptTitle.val(), "thumbnail": '', "des": _self.controls.pptDes.val(), "images": imgArrJson};
        _self.getThumbImgCanvasData().done(function (thumbData) {
            if(callback) {
                callback(pptInfo, thumbData);
            }
        });
    }

    this.getThumbImgCanvasData = function() {
        var def = $.Deferred();
        $("#pptTitle").css("border","0px");
        $("#pptTitlePanel").css("border","1px solid #bec3c7");
        $("#pptDescription").css("border","0px");
        $("#pptDescriptionPanel").css("border","1px solid #bec3c7");
        $("#galleryImgBtnExt").css("border","0px");

        if($("#pptTitle").val() == _self.PPTContext.ClickToAddTittle || $("#pptTitle").val() == ""){$("#pptTitle").val(" ");}
        if($("#pptDescription").val() == _self.PPTContext.ClickToAddDescription || $("#pptDescription").val() == ""){$("#pptDescription").val(" ");}

        var pptPanel = document.getElementById("pptEditPanel");
        html2canvas(pptPanel, {
            onrendered: function (canvas) {
                var data = canvas.toDataURL("image/jpeg");
                //console.log(data);
                def.resolve(data);
                $("#pptTitle").show();
                $("#pptDescription").show();
            }
        });
        return def.promise();
    }
}
