/**
 * 翻翻卡模板功能类
 * Created by ythuang on 14-7-9.
 */

function FlipCardItem() {
    this.front;
    this.back;
};
function OneSide() {
    this.type; // text,img
    this.value;
}


function FlipCardTemplate() {

    var _flipCardNum = 2;
    var _self = this;
    var _uEditorDlg = false;
    var _currentCardIndex = 0;
    var _side = "front";
    this.FlipCardItems = [];

    this.init = function () {

        /**
         * 选择翻翻卡数量
         */
        $("#list_num").change(function () {
            _self.chooseFlipCardNum();
            _self.createFipCardArray();
            _self.createFlipCardBar();
        });

        $(".flip_title").focusout(function () {
            var title = $(this).val();
            if (title != "请输入标题" && title != "") {
                $(".flip_title").val(title);
            } else {
                $(".flip_title").val("");
            }
        })

        // 翻翻卡标题限制
        $(".flip_title").bind('input propertychange', function () {
            var titleLengthArr = calcStrLength(this.value, 70);
            var titleStrLength = titleLengthArr[0];
            var mostIndex = titleLengthArr[1];
            if (titleStrLength > 70) {
                //标题过长，截断处理
                $(this).val($(this).val().substr(0, mostIndex + 1));
            }
        });

        $(".hot_area_close").click(function () {
            $("#edit_flip_text").hide();
            _self.showCardFrontBack();
        });
    }

    //计算标题整体字符所占长度
    function calcStrLength(str, charLength) {
        var len = 0;
        //最多实际能放下的“当前”字符串的长度位置
        var mostIndex = 0;
        for (var i = 0; i < str.length; i++) {
            var char = str.charCodeAt(i);
            //单字节加1
            if ((char >= 0x0001 && char <= 0x007e) || (0xff60 <= char && char <= 0xff9f)) {
                len++;
            }
            else {
                len += 1.7;
            }
            if (len <= charLength) {
                mostIndex = i;
            }
        }
        return [len, mostIndex];
    }

    /**
     * 选择翻翻卡数量
     */
    this.chooseFlipCardNum = function () {
        var num = parseInt($("#list_num option:selected").val());
        _flipCardNum = num;
        if (_currentCardIndex >= _flipCardNum) {
            _currentCardIndex = 0;
        }
    }

    /**
     * 展示选择条
     */
    this.createFlipCardBar = function () {
        var html = '<ul class="card_list4 text-center" id="card_sel_bar">'
        for (var i = 0; i < _flipCardNum; i++) {
            html += '<li class="flipcard_' + (i + 1) + '">卡' + (i + 1) + '</li>'
        }
        html += '</ul>'
        var dom = $(html);
        dom.find('li:eq(' + _currentCardIndex + ')').addClass('current');

        $("#btn_selcard").html(dom);
        _self.showCardFrontBack();

//        dom.dragsort({ dragSelector: "li", dragBetween: false, dragEnd: saveOrder, placeHolderTemplate: "<li style='border: 1px dashed #c8c8c8;'>卡</li>" });
//        function saveOrder() {
//            var flipCardItemsTmp = [];
//            $('#card_sel_bar').find('li').each(function (i) {
//                var index = parseInt($(this).attr('class').replace('flipcard_', '')) - 1;
//                var flipCardItem = new FlipCardItem;
//                flipCardItem.front = _self.FlipCardItems[index].front;
//                flipCardItem.back = _self.FlipCardItems[index].back;
//                flipCardItemsTmp.push(flipCardItem);
//                $(this).attr('class', 'flipcard_' + (i + 1));
//                $(this).html('卡' + (i + 1));
//            });
//            _self.FlipCardItems = flipCardItemsTmp;
//            $('#card_sel_bar').find('li:eq(' + _currentCardIndex + ')').addClass('current');
//            _self.showCardFrontBack();
//        }

        if (_flipCardNum <= 5) {
            $('#btn_card_next').addClass('disabled');
            $('#btn_card_pre').addClass('disabled');
        } else {
            $('#btn_card_next').removeClass('disabled').addClass('arrow_active');
            $('#btn_card_pre').addClass('disabled');
        }

        var flag = 0;
        $('#btn_card_next').unbind('click');
        $('#btn_card_next').on('click', function () {
            if (flag + 5 < _flipCardNum) {
                $('.card_list4 li:lt(' + (flag + 1) + ')').hide();
                flag++;
                $('#btn_card_pre').removeClass('disabled').addClass('arrow_active');

                if (flag == 4) {
                    $('#btn_card_next').removeClass('arrow_active').addClass('disabled');
                }
                if(flag + 5 == _flipCardNum){
                    $('#btn_card_next').removeClass('arrow_active').addClass('disabled');
                }
            } else {
                $('#btn_card_next').removeClass('arrow_active').addClass('disabled');
            }

            /**/
            _currentCardIndex = flag;
            dom.find("li").removeClass("current");
            dom.find("li:eq(" + flag + ")").addClass("current");
            $("#edit_flip_text").hide();
            _self.showCardFrontBack();
            /**/
        });

        $('#btn_card_pre').unbind('click');
        $('#btn_card_pre').on('click', function () {
            if (flag == 0 || flag == 1) {
                $('.card_list4 li:eq(0)').show();
                if (flag == 1) {
                    flag--;
                }
                if (_flipCardNum > 5) {
                    $('#btn_card_next').removeClass('disabled').addClass('arrow_active');
                    $('#btn_card_pre').removeClass('arrow_active').addClass('disabled');
                }
            } else {
                $('.card_list4 li:eq(' + (flag - 1) + ')').show();
                flag--;
                if (_flipCardNum > 5) {
                    $('#btn_card_next').removeClass('disabled').addClass('arrow_active');
                }
            }

            /**/
            _currentCardIndex = flag;
            dom.find("li").removeClass("current");
            dom.find("li:eq(" + flag + ")").addClass("current");
            $("#edit_flip_text").hide();
            _self.showCardFrontBack();
            /**/
        });

        dom.find("li").click(function () {
            _currentCardIndex = parseInt($(this).index());
            dom.find("li").removeClass("current");
            $(this).addClass("current");
            $("#edit_flip_text").hide();
            _self.showCardFrontBack();
        });
    }

    /**
     * 展示翻翻卡正反面
     */
    this.showCardFrontBack = function () {
        var htmlFront = '';
        if (_self.FlipCardItems[_currentCardIndex].front.type == 'img') {
            htmlFront = '<a style="line-height: 141px;" href="javascript:;">' +
                '<img alt="" src="' + _self.FlipCardItems[_currentCardIndex].front.value + '"/>' +
                '</a>';
            $("#tst_edit_span_front").parent('li').find('.graph_list_close').show();
            $('.front_add_pop').hide();
        } else if (_self.FlipCardItems[_currentCardIndex].front.type == 'text') {
            htmlFront = _self.FlipCardItems[_currentCardIndex].front.value;
            $("#tst_edit_span_front").parent('li').find('.graph_list_close').show();
            $('.front_add_pop').hide();
        } else {
            $("#tst_edit_span_front").parent('li').find('.graph_list_close').hide();
            $('.front_add_pop').show();
        }

        $("#tst_edit_span_front").html(htmlFront);

        var htmlBack = '';
        if (_self.FlipCardItems[_currentCardIndex].back.type == 'img') {
            htmlBack = '<a style="line-height: 141px;" href="javascript:;">' +
                '<img alt="" src="' + _self.FlipCardItems[_currentCardIndex].back.value + '"/>' +
                '</a>';
            $("#tst_edit_span_back").parent('li').find('.graph_list_close').show();
            $('.back_add_pop').hide();
        } else if (_self.FlipCardItems[_currentCardIndex].back.type == 'text') {
            htmlBack = _self.FlipCardItems[_currentCardIndex].back.value;
            $("#tst_edit_span_back").parent('li').find('.graph_list_close').show();
            $('.back_add_pop').hide();
        } else {
            $("#tst_edit_span_back").parent('li').find('.graph_list_close').hide();
            $('.back_add_pop').show();
        }
        $("#tst_edit_span_back").html(htmlBack);

        // 先解绑
        $('#front_add_text').unbind('click');
        $("#back_add_text").unbind('click');
        $('#front_add_img').unbind('click');
        $("#back_add_img").unbind('click');
        $('#tst_edit_span_front').unbind('click');
        $('#tst_edit_span_back').unbind('click');
        $('.graph_list_close').unbind('click');

        // 再重绑
        _self.eidtFrontCard();
        _self.eidtBackCard();
    }

    /**
     * 编辑翻翻卡正面
     */
    this.eidtFrontCard = function () {
        // 点击删除
        $('#tst_edit_span_front').parent('li').find('.graph_list_close').click(function () {
            _self.FlipCardItems[_currentCardIndex].front.type = '';
            _self.FlipCardItems[_currentCardIndex].front.value = '';
            _self.showCardFrontBack();
        });

        // 选择图片
        $('#front_add_img').click(function () {
            _self.selectImg().done(function (filePath) {
                if (filePath !== null) {
                    _self.FlipCardItems[_currentCardIndex].front.type = 'img';
                    _self.FlipCardItems[_currentCardIndex].front.value = filePath;
                }
                _self.showCardFrontBack();
            });
        });
        // 正面编辑文字文字
        $('#tst_edit_span_front').click(function () {
            if (_self.FlipCardItems[_currentCardIndex].front.type === 'text') {
                $('.graph_list_close').hide();
                var _tar = $(this);
                uEditorPlg(_tar, 'front');
            }
        });

        // 正面选择文字
        $('#front_add_text').click(function () {
            $('.graph_list_close').hide();
            var _tar = $(this).parents('li').find('#tst_edit_span_front');
            if (_self.FlipCardItems[_currentCardIndex].front.type !== 'text') {
                _tar.html('');
            }
            uEditorPlg(_tar, 'front');
        });
    }

    /**
     * 调用UEidtor
     * @param _tar 对象
     * @param par 正反面
     */
    function uEditorPlg(_tar, par) {
        var _prog = _tar[0].getBoundingClientRect();
        var _str = _tar[0].innerHTML || '';
        _tar.html('');

        $(_tar).off();
        var _uedtorDom = $('<div id ="editor_dom" style="font-size: 16px;position:absolute;z-index:1988;word-wrap: break-word;border: 1px solid #c6c6c6;border-radius: 5px;"></div>');
        _uedtorDom.css('width', _prog.width);
        _uedtorDom.css('height', 133);
        _uedtorDom.css('left', _prog.left);
        _uedtorDom.css('top', _prog.top);
        $('body').append(_uedtorDom);
        var editor = UE.getEditor('editor_dom', {
            initialFrameWidth: '100%'
        });

        var _textMask = '<div id="ue_text_mask" class="ue-text-mask"></div>';
        $('body').append(_textMask);
        editor.addListener('ready', function (e) {
            editor.setContent(_str);
            _uEditorDlg = true;
        });
        editor.addListener('destroy', function (e) {
            _uEditorDlg = false;
        });

        $('#ue_text_mask').on('click', function (e) {
            $(this).remove();
            _str = editor.getContent();
            editor.destroy();
            _uedtorDom.remove();
            _tar.html(_str);
            if (_str.trim() !== '') {
                if (par === 'front') {
                    _self.FlipCardItems[_currentCardIndex].front.type = 'text';
                    _self.FlipCardItems[_currentCardIndex].front.value = _str;
                } else {
                    _self.FlipCardItems[_currentCardIndex].back.type = 'text';
                    _self.FlipCardItems[_currentCardIndex].back.value = _str;
                }
            }
            _self.showCardFrontBack();
        });
    }


    this.destroyUEditorDlg = function () {
      $('#editor_dom').destroy();
    }

    /**
     *编辑翻翻卡反面
     */
    this.eidtBackCard = function () {
        // 点击删除
        $('#tst_edit_span_back').parent('li').find('.graph_list_close').click(function () {
            _self.FlipCardItems[_currentCardIndex].back.type = '';
            _self.FlipCardItems[_currentCardIndex].back.value = '';
            _self.showCardFrontBack();
        });

        // 选择图片
        $('#back_add_img').click(function () {
            _self.selectImg().done(function (filePath) {
                if (filePath !== null) {
                    _self.FlipCardItems[_currentCardIndex].back.type = 'img';
                    _self.FlipCardItems[_currentCardIndex].back.value = filePath;
                }
                _self.showCardFrontBack();
            });
        });

        // 反面编辑文字
        $('#tst_edit_span_back').click(function () {
            var _tar = $(this);
            if (_self.FlipCardItems[_currentCardIndex].back.type === 'text') {
                $('.graph_list_close').hide();
                uEditorPlg(_tar, 'back');
            }
        });

        // 反面选择文字
        $('#back_add_text').click(function () {
            $('.graph_list_close').hide();
            var _tar = $(this).parents('li').find('#tst_edit_span_back');
            if (_self.FlipCardItems[_currentCardIndex].back.type !== 'text') {
                _tar.html('');
            }
            uEditorPlg(_tar, 'back');
        });
    }

    /**
     * 创建翻翻卡数组
     */
    this.createFipCardArray = function () {
        for (var i = 0; i < _flipCardNum; i++) {
            if (_self.FlipCardItems.length > 0) {
                if (i >= _self.FlipCardItems.length) {
                    var flipCardItem = new FlipCardItem();
                    flipCardItem.front = new OneSide();
                    flipCardItem.back = new OneSide();
                    _self.FlipCardItems.push(flipCardItem);
                }
            } else {
                var flipCardItem = new FlipCardItem();
                flipCardItem.front = new OneSide();
                flipCardItem.back = new OneSide();
                _self.FlipCardItems.push(flipCardItem);
            }
        }
    }

    /**
     * 选择图片
     * @param side "front" "back"  正反面
     * @return filePath 图片路径
     */
    this.selectImg = function (side) {
        $("#edit_flip_text").hide();
        var def = $.Deferred();
        var options = {multiple: false, accept: "image/jpg, image/jpeg, image/bmp, image/gif, image/png"};
        DialogUtil.openFileDialog(options).done(function (filePath) {
            if (filePath.indexOf('#') >= 0) {
                filePath = null;
                _self.warmAlert(parent.COMMANDS.getErrorMsg(2021));
            }
            def.resolve(filePath);
        });
        return def.promise();
    }

    /**
     *获取翻翻卡信息
     */
    this.getFlipCardInfo = function (callback) {
        _self.getThumbImgCanvasData().done(function (thumbData) {
            var flipcardInfoJson = [];
            for (var i = 0; i < _flipCardNum; i++) {
                flipcardInfoJson.push(_self.FlipCardItems[i]);
            }

            var flipcardInfo = {"cardtype": "flipcard", "thumbnail": 'thumbnail.jpg', "title": $(".flip_title").val(), "cards": flipcardInfoJson};
            if (callback) {
                callback(flipcardInfo, thumbData);
            }
        });
    }

    /**
     * 定位未编辑的翻翻卡
     * @param index
     */
    this.orientateFlip = function (index) {
        _currentCardIndex = index;
        _self.createFlipCardBar();
    }

    this.isUEditorDlgShow = function (callback) {
        if (callback) {
            callback(_uEditorDlg);
        }
    }

    /**
     * 删除翻翻卡
     */
    this.deleteFlipCard = function () {
        if (_flipCardNum == 1) return;
        var flipCardArray = [];
        for (var i = 0; i < _flipCardNum; i++) {
            if (_currentCardIndex != i) {
                flipCardArray.push(_self.FlipCardItems[i]);
            }
        }
        _self.FlipCardItems = flipCardArray;
        _flipCardNum--;
        if (_flipCardNum <= _currentCardIndex) {
            _currentCardIndex--;
        }
        $("#list_num").val(_flipCardNum);
        _self.createFlipCardBar();
    }

    /**
     * 截取当前卡片的缩略图canvas
     */
    this.getThumbImgCanvasData = function () {
        var def = $.Deferred();
        if ($(".flip_title").val() == "") {
            $(".flip_title").hide();
        }
        html2canvas($(".cont")[0], {
            onrendered: function (canvas) {
                var data = canvas.toDataURL('image/jpeg');
                $(".flip_title").show();
                def.resolve(data);
            }
        });
        return def.promise();
    }

    /**
     * 编辑翻翻卡内容页面
     */
    this.showEditFlip = function () {
        $("#preview_flipcard").hide();
        $("#sort_flipcard").hide();
        $("#edit_flipcard").show();
    }

    /**
     * 预览翻翻卡页面
     */
    this.showPreviewCard = function () {
        $("#edit_flipcard").hide();
        $("#sort_flipcard").hide();
        $("#preview_flipcard").show();
    }

    /**
     * 排序翻翻卡页面
     */
    this.showSortCard = function () {
        $("#edit_flipcard").hide();
        $("#preview_flipcard").hide();
        $("#sort_flipcard").show();
    }

    this.setCmdText = function (cmd) {
        _self.FlipCardItems.length = 0;
        for (var i = 0; i < cmd.cards.length; i++) {
            var flipCardItem = new FlipCardItem();
            flipCardItem.front = new OneSide();
            flipCardItem.back = new OneSide();
            flipCardItem.front.type = cmd.cards[i].front.type;
            flipCardItem.front.value = cmd.cards[i].front.value;
            flipCardItem.back.type = cmd.cards[i].back.type;
            flipCardItem.back.value = cmd.cards[i].back.value;
            _self.FlipCardItems.push(flipCardItem);
        }
        _flipCardNum = cmd.cards.length;
        $("#list_num").val(_flipCardNum);
        $(".flip_title").val(cmd.title);
    }

    this.previewCard = function () {
        $('#preview_flip_title').html($(".flip_title").val());

        var cardNum = _flipCardNum;
        var option = {"cards": _self.FlipCardItems};
        var tmphtml = '';
        if (cardNum < 3) {
            tmphtml = '<tr>';
            for (var i = 0; i < cardNum; i++) {
                if (option.cards[i].front.type == 'img') {
                    tmphtml += '<td><div><img src="' + option.cards[i].front.value + '" alt="正面"/></div></td>';
                } else {
                    tmphtml += '<td><div>' + option.cards[i].front.value + '</div></td>'
                }
            }
            tmphtml += '</tr>';
        } else if (cardNum < 5) {
            for (var i = 0; i < cardNum; i++) {
                if (i < 3) {
                    if (i == 0) {
                        tmphtml += '<tr>';
                    }
                    if (option.cards[i].front.type == 'img') {
                        tmphtml += '<td><div><img src="' + option.cards[i].front.value + '" alt="正面"/></div></td>';
                    } else {
                        tmphtml += '<td><div>' + option.cards[i].front.value + '</div></td>'
                    }

                    if (i == 1) {
                        tmphtml += '</tr>';
                    }
                } else {
                    if (i == 2) {
                        tmphtml += '<tr>';
                    }


                    if (option.cards[i].front.type == 'img') {
                        tmphtml += '<td><div><img src="' + option.cards[i].front.value + '" alt="正面"/></div></td>';
                    } else {
                        tmphtml += '<td><div>' + option.cards[i].front.value + '</div></td>'
                    }

                    if (i == 3) {
                        tmphtml += '</tr>';
                    }
                }
            }

        } else if (cardNum < 10) {
            for (var i = 0; i < cardNum; i++) {
                if (i == 0 || i == 3 || i == 6) {
                    tmphtml += '<tr>';
                }

                if (option.cards[i].front.type == 'img') {
                    tmphtml += '<td><div><img src="' + option.cards[i].front.value + '" alt="正面"/></div></td>';
                } else {
                    tmphtml += '<td><div>' + option.cards[i].front.value + '</div></td>'
                }

                if (i == 2 || i == 5 || i == 8) {
                    tmphtml += '</tr>';
                }
            }
        }

        $('#pre_card_list').html(tmphtml);

        if (_flipCardNum == 1) {
            $('#pre_card_list td').css({'height': '400px', 'width': '600px'});
            $('#pre_card_list td div').css({'max-height': '380px', 'width': '590px', 'word-wrap': 'break-word', 'text-align': 'center', 'font-size': '16px'});
        } else if (_flipCardNum == 2) {
            $('#pre_card_list td').css({'height': '400px', 'width': '300px'});
            $('#pre_card_list td div').css({'max-height': '390px', 'width': '290px', 'word-wrap': 'break-word', 'text-align': 'center', 'font-size': '16px'});
        } else if (_flipCardNum < 5) {
            $('#pre_card_list td').css({'height': '200px', 'width': '298px'});
            $('#pre_card_list td div').css({'max-height': '186px', 'width': '290px', 'word-wrap': 'break-word', 'text-align': 'center', 'font-size': '16px'});
        } else if (_flipCardNum < 7) {
            $('#pre_card_list td').css({'height': '200px', 'width': '200px'});
            $('#pre_card_list td div').css({'max-height': '186px', 'width': '190px', 'word-wrap': 'break-word', 'text-align': 'center', 'font-size': '16px'});
        } else {
            $('#pre_card_list td').css({'height': '133px', 'width': '200px'});
            $('#pre_card_list td div').css({'max-height': '125px', 'width': '190px', 'word-wrap': 'break-word', 'text-align': 'center', 'font-size': '16px'});
        }
    }

    /**
     * 展示翻翻卡排序页面
     */
    this.sortCard = function () {
        var tmphtml = '<ul>';
        for (var i = 0; i < _flipCardNum; i++) {
            if (_self.FlipCardItems[i].front.type == 'img') {
                tmphtml += '<li class="flipcard_' + (i + 1) + '"><div><img src="' + _self.FlipCardItems[i].front.value + '"/></div><span>' + (i + 1) + '</span></li>';
            } else if (_self.FlipCardItems[i].front.type == 'text') {
                tmphtml += '<li class="flipcard_' + (i + 1) + '"><div>' + _self.FlipCardItems[i].front.value + '</div><span>' + (i + 1) + '</span></li>'
            } else {
                tmphtml += '<li class="flipcard_' + (i + 1) + '"><div></div><span>' + (i + 1) + '</span></li>'
            }
        }
        tmphtml += '</ul>';
        var dom = $(tmphtml);
        $('#sort_html_ul').html(dom);

        dom.dragsort({ dragSelector: "li", dragBetween: false, dragEnd: changeCardIndex, placeHolderTemplate: "<li><div>&nbsp;</div><span>&nbsp;</span></li>" });
        function changeCardIndex(){
            dom.find('li').each(function (i) {
                var index = parseInt($(this).attr('class').replace('flipcard_', '')) - 1;

                $(this).children('span').html(i + 1);
            });
        }

    }

    this.saveSortOrder = function (_callback) {
        var flipCardItemsTmp = [];
        $('#sort_html_ul').find('li').each(function (i) {
            var index = parseInt($(this).attr('class').replace('flipcard_', '')) - 1;
            var flipCardItem = new FlipCardItem;
            flipCardItem.front = _self.FlipCardItems[index].front;
            flipCardItem.back = _self.FlipCardItems[index].back;
            flipCardItemsTmp.push(flipCardItem);
            $(this).children('span').html(i + 1);
        });
        _self.FlipCardItems = flipCardItemsTmp;

        _callback(true);
    }

    /**
     * 温馨提示弹框
     * @param {string} info 提示语
     */
    this.warmAlert = function (info) {
        parent.COMMANDS.showSelectorPop(info, null, null, this, [
            {
                label: '确定',
                cssClass: 'btn-primary',
                action: function () {
                    parent.COMMANDS.hidePop();
                }}
        ]
        );
    }
}