/*
 * Common methods for webdialogs.
 *
 * Requires jQuery
 */

$(document).ready(init_UI);

// Assigns events to common UI elements.
function init_UI()
{
	// Focus property
	add_focus_property()
	
	// Buttons
	$(document).on('mousedown', '.button', function() {
    $(this).addClass('pressed');
    return false;
  });
	$(document).on('mouseup', '.button', function() {
    $(this).removeClass('pressed');
    return false;
  });
	$(document).on('selectstart', '.button', function() {
    return false;
  });
}

// Loops over all input elements and ensure that they get an .focus class added
// upon focus and remove it when it loses focus. This is a workaround for IE7's 
// lack of :hover support.
function add_focus_property()
{
  $(document).on('focus', 'input', function() {
    $(this).addClass('focus');
  });
  $(document).on('blur', 'input', function() {
    $(this).removeClass('focus');
  });
}