#-------------------------------------------------------------------------------
#
# Thomas Thomassen
# thomas[at]thomthom[dot]net
# Copyright 2010-2015
#
#-------------------------------------------------------------------------------

require 'sketchup.rb'
require 'extensions.rb'

#-------------------------------------------------------------------------------

# @since 1.0.0
module TT_Vertex
  
  ### SYSTEM METHODS ### -------------------------------------------------------
  
  # @since 1.0.0
  PLATFORM_OSX = (Object::RUBY_PLATFORM =~ /darwin/i) ? true : false
  PLATFORM_WIN = !PLATFORM_OSX
  
  
  ### MENU & TOOLBARS ### ------------------------------------------------------
  
  unless file_loaded?( __FILE__ )   
    ### CONSTANTS ### ----------------------------------------------------------
    PLUGIN_ID         = 'TT_Vertex'.freeze
    PLUGIN_NAME       = 'Vertex Tools'.freeze
    PLUGIN_VERSION    = '1.1.15'.freeze
    PLUGIN_BUILD_DATE = '2015-07-30'.freeze
    
    ROOT_PATH       = File.dirname( File.expand_path(__FILE__) ).freeze
    PATH            = File.join(ROOT_PATH, 'TT_Vertex').freeze
    CURSOR_PATH     = File.join(PATH, 'Cursors').freeze
    ICONS_PATH      = File.join(PATH, 'Icons').freeze
    WEBDIALOG_PATH  = File.join(PATH, 'webdialog').freeze
    L10N_PATH       = File.join(PATH, 'Localisation').freeze
    CEXT_ROOT_PATH  = File.join(PATH, 'CExt').freeze
    
    ### EXTENSION ### ----------------------------------------------------------
    PROXY_LOADER = File.join(PATH, 'loader.rb').freeze
    # When loading core.rbs via SketchupExtension the namespaces get mixed up.
    # Instead of TT_Vertex::PATH it tries to look in
    # SketchupExtension::TT_Vertex::PATH.
    # And the .rbs are probably all loaded under the SketchupExtension namespace.
    
    @ex = SketchupExtension.new( PLUGIN_NAME, PROXY_LOADER )
    @ex.description = "Tool to manipulate vertices.\n\nhttp://www.thomthom.net/software/vertex_tools/"
    @ex.version = PLUGIN_VERSION
    @ex.copyright = 'Thomas Thomassen © 2010–2015'
    @ex.creator = 'Thomas Thomassen (thomas@thomthom.net)'
    Sketchup.register_extension(@ex, true)
  end
  
  # @since 1.0.0
  def self.extension
    @ex
  end
  
  # <debug>
  @debug = false
  # @since 1.1.0
  def self.debug
    @debug
  end
  # @since 1.1.0
  def self.debug=( value )
    @debug = value
  end

  # @since 1.0.0
  def self.debug_info
    bitness = pointer_size = ['a'].pack('P').size * 8 # 32 or 64
    pro_ness = (Sketchup.is_pro?) ? ' Pro' : ''
    puts "\n===== Vertex Tools Debug Info =====\n\n"
    
    puts "PLUGIN_NAME: #{PLUGIN_NAME}"
    puts "PLUGIN_VERSION: #{PLUGIN_VERSION}"
    puts "PLUGIN_BUILD_DATE: #{PLUGIN_BUILD_DATE}"
    puts ''
    puts "SketchUp#{pro_ness}: #{Sketchup.version} (#{bitness}bit)"
    puts ''
    puts "RUBY_VERSION: #{RUBY_VERSION}"
    puts "RUBY_PATCHLEVEL: #{RUBY_PATCHLEVEL}" if defined?( RUBY_PATCHLEVEL )
    puts "RUBY_RELEASE_DATE: #{RUBY_RELEASE_DATE}"
    puts "RUBY_PLATFORM: #{RUBY_PLATFORM}"
    puts ''
    puts "__FILE__:       #{__FILE__}"
    puts "PROXY_LOADER:   #{PROXY_LOADER}"
    puts ''
    puts "ROOT_PATH:      #{ROOT_PATH}"
    puts "PATH:           #{PATH}"
    puts "CEXT_PATH:      #{CEXT_PATH}"
    puts "CURSOR_PATH:    #{CURSOR_PATH}"
    puts "ICONS_PATH:     #{ICONS_PATH}"
    puts "L10N_PATH:      #{L10N_PATH}"
    puts "WEBDIALOG_PATH: #{WEBDIALOG_PATH}"
    puts ''
    if defined?( CEXT_VERSION )
      puts "CEXT_VERSION: #{CEXT_VERSION}"
    else
      puts "CEXT_VERSION: <undefined>"
    end
    puts "\n-----------------------------------\n\n"
  end
  # </debug>

end # module TT_Vertex

#-------------------------------------------------------------------------------
file_loaded( __FILE__ )
#-------------------------------------------------------------------------------
