/*
 * jqFilter  jQuery jqGrid filter addon.
 * Copyright (c) 2011, Tony Tomov, tony@trirand.com
 * Dual licensed under the MIT and GPL licenses
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * The work is inspired from this Stefan Pirvu
 * http://www.codeproject.com/KB/scripting/json-filtering.aspx
 *
 * The filter uses JSON entities to hold filter rules and groups. Here is an example of a filter:

{ "groupOp": "AND",
      "groups" : [ 
        { "groupOp": "OR",
            "rules": [
                { "field": "name", "op": "eq", "data": "England" }, 
                { "field": "id", "op": "le", "data": "5"}
             ]
        } 
      ],
      "rules": [
        { "field": "name", "op": "eq", "data": "Romania" }, 
        { "field": "id", "op": "le", "data": "1"}
      ]
}
*/
/*global jQuery, $, window, navigator */

(function($){$.fn.jqFilter=function(w){if(typeof w==='string'){var x=$.fn.jqFilter[w];if(!x){throw("jqFilter - No such method: "+w);}var y=$.makeArray(arguments).slice(1);return x.apply(this,y)}var p=$.extend(true,{filter:null,columns:[],onChange:null,afterRedraw:null,checkValues:null,error:false,errmsg:"",errorcheck:true,showQuery:true,sopt:null,ops:[{"name":"eq","description":"equal","operator":"="},{"name":"ne","description":"not equal","operator":"<>"},{"name":"lt","description":"less","operator":"<"},{"name":"le","description":"less or equal","operator":"<="},{"name":"gt","description":"greater","operator":">"},{"name":"ge","description":"greater or equal","operator":">="},{"name":"bw","description":"begins with","operator":"LIKE"},{"name":"bn","description":"does not begin with","operator":"NOT LIKE"},{"name":"in","description":"in","operator":"IN"},{"name":"ni","description":"not in","operator":"NOT IN"},{"name":"ew","description":"ends with","operator":"LIKE"},{"name":"en","description":"does not end with","operator":"NOT LIKE"},{"name":"cn","description":"contains","operator":"LIKE"},{"name":"nc","description":"does not contain","operator":"NOT LIKE"},{"name":"nu","description":"is null","operator":"IS NULL"},{"name":"nn","description":"is not null","operator":"IS NOT NULL"}],numopts:['eq','ne','lt','le','gt','ge','nu','nn','in','ni'],stropts:['eq','ne','bw','bn','ew','en','cn','nc','nu','nn','in','ni'],_gridsopt:[],groupOps:[{op:"AND",text:"AND"},{op:"OR",text:"OR"}],groupButton:true,ruleButtons:true,direction:"ltr"},$.jgrid.filter,w||{});return this.each(function(){if(this.filter){return}this.p=p;if(this.p.filter===null||this.p.filter===undefined){this.p.filter={groupOp:this.p.groupOps[0].op,rules:[],groups:[]}}var i,len=this.p.columns.length,cl,isIE=/msie/i.test(navigator.userAgent)&&!window.opera;if(this.p._gridsopt.length){for(i=0;i<this.p._gridsopt.length;i++){this.p.ops[i].description=this.p._gridsopt[i]}}this.p.initFilter=$.extend(true,{},this.p.filter);if(!len){return}for(i=0;i<len;i++){cl=this.p.columns[i];if(cl.stype){cl.inputtype=cl.stype}else if(!cl.inputtype){cl.inputtype='text'}if(cl.sorttype){cl.searchtype=cl.sorttype}else if(!cl.searchtype){cl.searchtype='string'}if(cl.hidden===undefined){cl.hidden=false}if(!cl.label){cl.label=cl.name}if(cl.index){cl.name=cl.index}if(!cl.hasOwnProperty('searchoptions')){cl.searchoptions={}}if(!cl.hasOwnProperty('searchrules')){cl.searchrules={}}}if(this.p.showQuery){$(this).append("<table class='queryresult ui-widget ui-widget-content' style='display:block;max-width:440px;border:0px none;' dir='"+this.p.direction+"'><tbody><tr><td class='query'></td></tr></tbody></table>")}var v=function(a,b){var c=[true,""];if($.isFunction(b.searchrules)){c=b.searchrules(a,b)}else if($.jgrid&&$.jgrid.checkValues){try{c=$.jgrid.checkValues(a,-1,null,b.searchrules,b.label)}catch(e){}}if(c&&c.length&&c[0]===false){p.error=!c[0];p.errmsg=c[1]}};this.onchange=function(){this.p.error=false;this.p.errmsg="";return $.isFunction(this.p.onChange)?this.p.onChange.call(this,this.p):false};this.reDraw=function(){$("table.group:first",this).remove();var t=this.createTableForGroup(p.filter,null);$(this).append(t);if($.isFunction(this.p.afterRedraw)){this.p.afterRedraw.call(this,this.p)}};this.createTableForGroup=function(c,d){var e=this,i;var f=$("<table class='group ui-widget ui-widget-content' style='border:0px none;'><tbody></tbody></table>"),align="left";if(this.p.direction=="rtl"){align="right";f.attr("dir","rtl")}if(d===null){f.append("<tr class='error' style='display:none;'><th colspan='5' class='ui-state-error' align='"+align+"'></th></tr>")}var g=$("<tr></tr>");f.append(g);var h=$("<th colspan='5' align='"+align+"'></th>");g.append(h);if(this.p.ruleButtons===true){var j=$("<select class='opsel'></select>");h.append(j);var k="",selected;for(i=0;i<p.groupOps.length;i++){selected=c.groupOp===e.p.groupOps[i].op?" selected='selected'":"";k+="<option value='"+e.p.groupOps[i].op+"'"+selected+">"+e.p.groupOps[i].text+"</option>"}j.append(k).bind('change',function(){c.groupOp=$(j).val();e.onchange()})}var l="<span></span>";if(this.p.groupButton){l=$("<input type='button' value='+ {}' title='Add subgroup' class='add-group'/>");l.bind('click',function(){if(c.groups===undefined){c.groups=[]}c.groups.push({groupOp:p.groupOps[0].op,rules:[],groups:[]});e.reDraw();e.onchange();return false})}h.append(l);if(this.p.ruleButtons===true){var m=$("<input type='button' value='+' title='Add rule' class='add-rule ui-add'/>"),cm;m.bind('click',function(){if(c.rules===undefined){c.rules=[]}for(i=0;i<e.p.columns.length;i++){var a=(typeof e.p.columns[i].search==='undefined')?true:e.p.columns[i].search,hidden=(e.p.columns[i].hidden===true),ignoreHiding=(e.p.columns[i].searchoptions.searchhidden===true);if((ignoreHiding&&a)||(a&&!hidden)){cm=e.p.columns[i];break}}var b;if(cm.searchoptions.sopt){b=cm.searchoptions.sopt}else if(e.p.sopt){b=e.p.sopt}else if(cm.searchtype==='string'){b=e.p.stropts}else{b=e.p.numopts}c.rules.push({field:cm.name,op:b[0],data:""});e.reDraw();return false});h.append(m)}if(d!==null){var n=$("<input type='button' value='-' title='Delete group' class='delete-group'/>");h.append(n);n.bind('click',function(){for(i=0;i<d.groups.length;i++){if(d.groups[i]===c){d.groups.splice(i,1);break}}e.reDraw();e.onchange();return false})}if(c.groups!==undefined){for(i=0;i<c.groups.length;i++){var o=$("<tr></tr>");f.append(o);var q=$("<td class='first'></td>");o.append(q);var r=$("<td colspan='4'></td>");r.append(this.createTableForGroup(c.groups[i],c));o.append(r)}}if(c.groupOp===undefined){c.groupOp=e.p.groupOps[0].op}if(c.rules!==undefined){for(i=0;i<c.rules.length;i++){f.append(this.createTableRowForRule(c.rules[i],c))}}return f};this.createTableRowForRule=function(f,g){var h=this,tr=$("<tr></tr>"),i,op,trpar,cm,str="",selected;tr.append("<td class='first'></td>");var k=$("<td class='columns'></td>");tr.append(k);var l=$("<select></select>"),ina,aoprs=[];k.append(l);l.bind('change',function(){f.field=$(l).val();trpar=$(this).parents("tr:first");for(i=0;i<h.p.columns.length;i++){if(h.p.columns[i].name===f.field){cm=h.p.columns[i];break}}if(!cm){return}cm.searchoptions.id=$.jgrid.randId();if(isIE&&cm.inputtype==="text"){if(!cm.searchoptions.size){cm.searchoptions.size=10}}var c=$.jgrid.createEl(cm.inputtype,cm.searchoptions,"",true,h.p.ajaxSelectOptions,true);$(c).addClass("input-elm");if(cm.searchoptions.sopt){op=cm.searchoptions.sopt}else if(h.p.sopt){op=h.p.sopt}else if(cm.searchtype==='string'){op=h.p.stropts}else{op=h.p.numopts}var s="",so=0;aoprs=[];$.each(h.p.ops,function(){aoprs.push(this.name)});for(i=0;i<op.length;i++){ina=$.inArray(op[i],aoprs);if(ina!==-1){if(so===0){f.op=h.p.ops[ina].name}s+="<option value='"+h.p.ops[ina].name+"'>"+h.p.ops[ina].description+"</option>";so++}}$(".selectopts",trpar).empty().append(s);$(".selectopts",trpar)[0].selectedIndex=0;if($.browser.msie&&$.browser.version<9){var d=parseInt($("select.selectopts",trpar)[0].offsetWidth)+1;$(".selectopts",trpar).width(d);$(".selectopts",trpar).css("width","auto")}$(".data",trpar).empty().append(c);$(".input-elm",trpar).bind('change',function(e){var b=$(this).hasClass("ui-autocomplete-input")?200:0;setTimeout(function(){var a=e.target;f.data=a.nodeName.toUpperCase()==="SPAN"&&cm.searchoptions&&$.isFunction(cm.searchoptions.custom_value)?cm.searchoptions.custom_value($(a).children(".customelement:first"),'get'):a.value;h.onchange()},b)});setTimeout(function(){f.data=$(c).val();h.onchange()},0)});var j=0;for(i=0;i<h.p.columns.length;i++){var m=(typeof h.p.columns[i].search==='undefined')?true:h.p.columns[i].search,hidden=(h.p.columns[i].hidden===true),ignoreHiding=(h.p.columns[i].searchoptions.searchhidden===true);if((ignoreHiding&&m)||(m&&!hidden)){selected="";if(f.field===h.p.columns[i].name){selected=" selected='selected'";j=i}str+="<option value='"+h.p.columns[i].name+"'"+selected+">"+h.p.columns[i].label+"</option>"}}l.append(str);var n=$("<td class='operators'></td>");tr.append(n);cm=p.columns[j];cm.searchoptions.id=$.jgrid.randId();if(isIE&&cm.inputtype==="text"){if(!cm.searchoptions.size){cm.searchoptions.size=10}}var o=$.jgrid.createEl(cm.inputtype,cm.searchoptions,f.data,true,h.p.ajaxSelectOptions,true);var q=$("<select class='selectopts'></select>");n.append(q);q.bind('change',function(){f.op=$(q).val();trpar=$(this).parents("tr:first");var a=$(".input-elm",trpar)[0];if(f.op==="nu"||f.op==="nn"){f.data="";a.value="";a.setAttribute("readonly","true");a.setAttribute("disabled","true")}else{a.removeAttribute("readonly");a.removeAttribute("disabled")}h.onchange()});if(cm.searchoptions.sopt){op=cm.searchoptions.sopt}else if(h.p.sopt){op=h.p.sopt}else if(cm.searchtype==='string'){op=p.stropts}else{op=h.p.numopts}str="";$.each(h.p.ops,function(){aoprs.push(this.name)});for(i=0;i<op.length;i++){ina=$.inArray(op[i],aoprs);if(ina!==-1){selected=f.op===h.p.ops[ina].name?" selected='selected'":"";str+="<option value='"+h.p.ops[ina].name+"'"+selected+">"+h.p.ops[ina].description+"</option>"}}q.append(str);var r=$("<td class='data'></td>");tr.append(r);r.append(o);$(o).addClass("input-elm").bind('change',function(){f.data=cm.inputtype==='custom'?cm.searchoptions.custom_value($(this).children(".customelement:first"),'get'):$(this).val();h.onchange()});var t=$("<td></td>");tr.append(t);if(this.p.ruleButtons===true){var u=$("<input type='button' value='-' title='Delete rule' class='delete-rule ui-del'/>");t.append(u);u.bind('click',function(){for(i=0;i<g.rules.length;i++){if(g.rules[i]===f){g.rules.splice(i,1);break}}h.reDraw();h.onchange();return false})}return tr};this.getStringForGroup=function(a){var s="(",index;if(a.groups!==undefined){for(index=0;index<a.groups.length;index++){if(s.length>1){s+=" "+a.groupOp+" "}try{s+=this.getStringForGroup(a.groups[index])}catch(eg){alert(eg)}}}if(a.rules!==undefined){try{for(index=0;index<a.rules.length;index++){if(s.length>1){s+=" "+a.groupOp+" "}s+=this.getStringForRule(a.rules[index])}}catch(e){alert(e)}}s+=")";if(s==="()"){return""}else{return s}};this.getStringForRule=function(a){var b="",opC="",i,cm,ret,val,numtypes=['int','integer','float','number','currency'];for(i=0;i<this.p.ops.length;i++){if(this.p.ops[i].name===a.op){b=this.p.ops[i].operator;opC=this.p.ops[i].name;break}}for(i=0;i<this.p.columns.length;i++){if(this.p.columns[i].name===a.field){cm=this.p.columns[i];break}}val=a.data;if(opC==='bw'||opC==='bn'){val=val+"%"}if(opC==='ew'||opC==='en'){val="%"+val}if(opC==='cn'||opC==='nc'){val="%"+val+"%"}if(opC==='in'||opC==='ni'){val=" ("+val+")"}if(p.errorcheck){v(a.data,cm)}if($.inArray(cm.searchtype,numtypes)!==-1||opC==='nn'||opC==='nu'){ret=a.field+" "+b+" "+val}else{ret=a.field+" "+b+" \""+val+"\""}return ret};this.resetFilter=function(){this.p.filter=$.extend(true,{},this.p.initFilter);this.reDraw();this.onchange()};this.hideError=function(){$("th.ui-state-error",this).html("");$("tr.error",this).hide()};this.showError=function(){$("th.ui-state-error",this).html(this.p.errmsg);$("tr.error",this).show()};this.toUserFriendlyString=function(){return this.getStringForGroup(p.filter)};this.toString=function(){var b=this;function getStringRule(a){if(b.p.errorcheck){var i,cm;for(i=0;i<b.p.columns.length;i++){if(b.p.columns[i].name===a.field){cm=b.p.columns[i];break}}if(cm){v(a.data,cm)}}return a.op+"(item."+a.field+",'"+a.data+"')"}function getStringForGroup(a){var s="(",index;if(a.groups!==undefined){for(index=0;index<a.groups.length;index++){if(s.length>1){if(a.groupOp==="OR"){s+=" || "}else{s+=" && "}}s+=getStringForGroup(a.groups[index])}}if(a.rules!==undefined){for(index=0;index<a.rules.length;index++){if(s.length>1){if(a.groupOp==="OR"){s+=" || "}else{s+=" && "}}s+=getStringRule(a.rules[index])}}s+=")";if(s==="()"){return""}else{return s}}return getStringForGroup(this.p.filter)};this.reDraw();if(this.p.showQuery){this.onchange()}this.filter=true})};$.extend($.fn.jqFilter,{toSQLString:function(){var s="";this.each(function(){s=this.toUserFriendlyString()});return s},filterData:function(){var s;this.each(function(){s=this.p.filter});return s},getParameter:function(a){if(a!==undefined){if(this.p.hasOwnProperty(a)){return this.p[a]}}return this.p},resetFilter:function(){return this.each(function(){this.resetFilter()})},addFilter:function(a){if(typeof a==="string"){a=jQuery.jgrid.parse(a)}this.each(function(){this.p.filter=a;this.reDraw();this.onchange()})}})})(jQuery);

