
local common = LibStub("LibAddon"):GetAddon("common")
local simplemsgbox = common:NewModule("simplemsgbox", "LibEvent", "LibTimer")

local l_ChatState 			= true; --true 表示不再聊天状态，1 表示
local l_IsStartChat 		= true;
function simplemsgbox:OnInitialize()	
	--xlog("@@@:OnInitialize你好，%d",11);	
	local SwtichVar 	= CTransLua:getSingleton():GetSwitchState();
--	xlog("@@@:switch:%d",SwtichVar);

	self:init_wnd();
	self.obj_main_wnd:hide();
	if (SwtichVar == 0 ) then
		xlog("@@@:关闭聊天翻译");	
		l_IsStartChat 		 	= false;
		self.obj_SysChatInput:setSelected(true);
		return;
	end	
	
	--self:init_wnd();
	--self:debug("common simplemsgbox:OnInitialize end")
	--self.obj_center_text:setText("11111111111111111111111111111111111111111111111111111111111111111");
end

function simplemsgbox:init_wnd()
	
	self.wnd_mgr = CEGUI.WindowManager:getSingleton();
	self.root = CEGUI.System:getSingleton():getGUISheet();
	self.obj_main_wnd = self.wnd_mgr:getWindow("CommonOneBtnwnd")
	self.obj_main_wnd = CEGUI.toFrameWindow(self.obj_main_wnd)
	self.root:subscribeEvent("Sized", self.on_root_sized, self);
	

	
--	local autoTitle = self.obj_main_wnd:getName() .. "__auto_vscrollbar__";  
--	autoTitle 			= self.wnd_mgr:getWindow(hscrollbarName);
--	autoTitle:hide();
	
	self.obj_center_text = self.wnd_mgr:getWindow("CommonOneChatInfo")
	--self.obj_center_text = CEGUI.toStaticText(self.obj_center_text);
	self.obj_center_text:setTextParsingEnabled(true);
	local hscrollbarName = self.obj_center_text:getName() .. "__auto_vscrollbar__";    
		--xlog("@@@,%s",hscrollbarName);	
	self.obj_center_scroll = CEGUI.toScrollbar(self.wnd_mgr:getWindow(hscrollbarName));
	--hscrollbar:setVisible(true)
	self.obj_center_scroll:show();
	
	self.obj_ChatSend 	= self.wnd_mgr:getWindow("CommonOneChatSend")
	self.obj_ChatSend 	= CEGUI.toEditbox(self.obj_ChatSend);	
	--self.obj_bottom_btn = self.wnd_mgr:getWindow("CommonOneBtnwndBtn")	

	self.obj_SysChatInput 	= self.wnd_mgr:getWindow("SysChatInput")
	
	self.obj_SysChatInput 	= CEGUI.toCheckbox(self.obj_SysChatInput);	

	self:RegistrEvents()	
	
	-- 重置窗口
	--self:resetMainwnd()
	--self.obj_main_wnd:hide()	
	--self.obj_main_wnd.activate();	
	self.obj_ChatSend:activate()
	--xlog("@@@:init_wnd");
end

function simplemsgbox:RegistrEvents()
	self.obj_main_wnd:subscribeEvent("Moved", 	self.on_moved, self)
	self.obj_main_wnd:subscribeEvent("CloseClicked", self.on_click_close, self)
	
	self.root:subscribeEvent("KeyDown", self.on_Key_Down, self)	
	--self.obj_bottom_btn:subscribeEvent("Clicked", self.on_bottom_btn_clicked, self)
	
	self.obj_ChatSend:subscribeEvent("KeyDown", self.on_SendEdt_KeyDown, self)
	self.obj_ChatSend:subscribeEvent("Activated", self.on_ChatSendActivated, self)
	self.obj_ChatSend:subscribeEvent("Deactivated", self.on_ChatSendDeactivated, self)
	self.obj_SysChatInput:subscribeEvent("CheckStateChanged", self.on_SysChatInputClick, self)
	
	self:RegisterEvent("YYT_TO_PIP_RecvMsg", "on_RecvChatMsg")
	
	--self:RegisterMessage("COMMON_NOTIFY_HIDE_SMARTYY", "on_hide_smartyy")

--	self:RegisterMessage("MAINWND_HIDE_ALL", "hideMainWnd")
end

function simplemsgbox:on_SysChatInputClick(args)
		if self.obj_SysChatInput:isSelected()== true then 
			self.obj_ChatSend:hide();
			l_ChatState 					= false;
			self:SetTalkerTimer();
		end
		--xlog("@@@:chatInput");
end

function simplemsgbox:on_ChatSendActivated(args)
	--修改按键，屏蔽游戏快捷键	
	CTransLua:getSingleton():TurnON_OFFKeyboard(true,true);
end

function simplemsgbox:on_ChatSendDeactivated(args)
	--修改按键，屏蔽游戏快捷键	
	CTransLua:getSingleton():TurnON_OFFKeyboard(false,false);
end

function simplemsgbox:on_RecvChatMsg(event, szName)		
		local nChatType 			= 0;
		
		self.obj_center_text:appendText(szName.."\r\n");
		self.obj_center_scroll:show();		
	--self.obj_center_scroll:setProperty("ScrollPosition", "100");

		self.obj_center_scroll:setScrollPosition(0x7FFFFFFF);
		self.obj_main_wnd:show()				
		
	  nChatType							= l_ChatState;
		if nChatType == true then --1在聊天状态时
			return;
		end
		self:SetTalkerTimer();
end

function simplemsgbox:SetTalkerTimer()		
		if l_ChatState == true then
				return;
		end		
		if self.timer_talk ~= nil then
			self:CancelTimer(self.timer_talk);
		end	
		self.timer_talk 					= self:ScheduleRepeatingTimer(self.on_talking_timer,10000,self);	
		self.obj_ChatSend:hide();
end

-- 保证窗口在屏幕内
function simplemsgbox:clamped_to_screen()
	local pos = self.obj_main_wnd:getPosition();
	local new_x, new_y = pos.x.offset, pos.y.offset;
	local size = self.obj_main_wnd:getPixelSize();
	local rootSize = CEGUI.System:getSingleton():getGUISheet():getPixelSize();
	
	if (pos.x.offset < 0) then new_x = 0; end
	if (pos.y.offset < 0) then new_y = 0; end
	if (pos.x.offset > (rootSize.width - size.width)) then new_x = rootSize.width - size.width; end
	if (pos.y.offset > (rootSize.height - size.height)) then new_y = rootSize.height - size.height; end

	if (new_x ~= pos.x.offset or new_y ~= pos.y.offset) then
		self.obj_main_wnd:setPosition(CEGUI.UVector2(CEGUI.UDim(0,new_x),CEGUI.UDim(0,new_y)));
	end
end

function simplemsgbox:on_root_sized(args)
	self:debug("root:on_sized")
	-- 窗口大小改变时，窗口保持在游戏窗口内
	if self.obj_main_wnd ~= nil and
		self.obj_main_wnd:isVisible() then
		self:clamped_to_screen()
	end
end

function simplemsgbox:on_moved(args)
	return true;
end

function simplemsgbox:on_click_close(args)
	local window_args = CEGUI.toWindowEventArgs(args)
	window_args.window:hide()
end

function simplemsgbox:on_bottom_btn_clicked(args)
	local szInfo			= self.obj_ChatSend:getText()				
	local nInfoLen 		= string.len(szInfo)
	
	self:SetTalkerTimer();
	if (nInfoLen > 0) then
		CTransLua:getSingleton():LolSendChatMsg(szInfo);
		self.obj_ChatSend:setText("");	
	end 			
	
	--xlog("@@@:on_bottom_btn_clicked");	
	self.obj_ChatSend:hide()
end

function simplemsgbox:on_SendEdt_KeyDown(args)
	local window_args = CEGUI.toKeyEventArgs(args)--toWindowEventArgs(args)
	--xlog("@@@:keScanCode11:%x",window_args.scancode)
	if window_args.scancode == 0x1C or window_args.scancode == 0x9C then		
		if self.obj_SysChatInput:isSelected() == true then
			return 0
		end
		l_ChatState 		= not l_ChatState;
		self:on_bottom_btn_clicked(1);
		
		window_args.handled = -1
	elseif window_args.scancode == 0x1b then			
			self:SetTalkerTimer();		
			l_ChatState 					= false;			
	else
		window_args.handled = -1
	end		
end

function simplemsgbox:on_Key_Down(args)
	local window_args = CEGUI.toKeyEventArgs(args)
	local nChatType			= false;	

	if l_IsStartChat == false then
		return 0;
	end
	if window_args.scancode == 0x1c or window_args.scancode==0x9c then 
		local nVkShift 			= 0;
		self.obj_main_wnd:show()			
		nChatType 								= l_ChatState;		
		--xlog("@@@:chatType::%d",nSysChatBl);	
		if self.obj_SysChatInput:isSelected() == true then			
			return 0;
		end
		l_ChatState 							= not l_ChatState;
		if nChatType == true then			
			--xlog("@@@:on_bottom_btn_clicked TRUE");
			self:on_bottom_btn_clicked(1);			
		else 
			--xlog("@@@:on_bottom_btn_clicked FALSE");
			if self.timer_talk ~= nil then
				self:CancelTimer(self.timer_talk);
				self.timer_talk 			= nil;
			end	
			self.obj_ChatSend:show();
			self.obj_ChatSend:activate();				
			nVkShift 				= CTransLua:getSingleton():GetKbdKeyState(0x10);
			--xlog("@@@:%s",nVkShift);	
			
			if (nVkShift < 0) then
				self.obj_ChatSend:setText("/all:");
				self.obj_ChatSend:setCaratIndex(5);
			end
			--self.obj_main_wnd:hide()				
		end					
	
--		if l_IsShowSysChat == false then		
--			--xlog("@@@:l_IsShowSysChat:%x",window_args.scancode);
--			window_args.handled  = -1;
--			return 0;
--		end
		window_args.handled  = -1;
			--self.obj_ChatSend:setText("111");			
	elseif window_args.scancode == 0x1b then
			self:SetTalkerTimer();
			l_ChatState 					= false;
		--	xlog("@@@: esc");
	elseif window_args.scancode == 0x2c then
		self.obj_main_wnd:show()
		self:on_bottom_btn_clicked(1);
	elseif window_args.scancode >= 2 and window_args.scancode <= 11 then -- 一键喊话
		--xlog("@@@:%x",window_args.scancode);
		local lKeyState 	=  CTransLua:getSingleton():GetKbdKeyState(0xc0);
		if lKeyState < 0 then
			CTransLua:getSingleton():LolSendShutMsg((window_args.scancode-1));
		end	 	 
	else				
		window_args.handled  = -1;
	end	

	--xlog("@@@:MaxPos:%d",lMaxPos);
	
	return 0;
end

function simplemsgbox:showSimpleMsgbox(title,msg,pos_x,pos_y)
	if (title ~= nil) then
		self.obj_main_wnd:setText(title)
	end
	if (msg ~= nil) then
		self.obj_center_text:setText(msg)
	end
	if (self.obj_main_wnd and pos_x ~= nil and pos_y ~= nil) then
		self.obj_main_wnd:setPosition(CEGUI.UVector2(CEGUI.UDim(0, pos_x),CEGUI.UDim(0, pos_y)))
		self.obj_main_wnd:show()
		self.obj_main_wnd:moveToFront()
	end
end

function simplemsgbox:hideMainWnd()
	self.obj_main_wnd:hide()
end

function simplemsgbox:on_talking_timer()
	self.obj_main_wnd:hide()
	self:CancelTimer(self.timer_talk);
	self.timer_talk 		= nil;
--	xlog("@@@:on_talking_timer");
end