--[[
enum LoggingLevel
{
	Errors,			//!< Only actual error conditions will be logged.
  Warnings,       //!< Warnings will be logged as well.
	Standard,		//!< Basic events will be logged (default level).
	Informative,	//!< Useful tracing (object creations etc) information will be logged.
	Insane			//!< Mostly everything gets logged (use for heavy tracing only, log WILL be big).
};
--]]

-- flg ο LoggingLevelֵ
function __LOG__(msg, ...)
	local log_level

	if select('#', ...) == 0 then
		log_level = CEGUI.Standard
	else
		log_level = select(1, ...)
	end

	CEGUI.Logger:getSingleton():logEvent(msg, log_level)
end

local l_logOn 			= true;

function xlog(formatStr,...)
	local szLog;

	if formatStr == nil then
		szlog 			= "nil";
	elseif ... ~= nil then
		szLog 			= string.format(formatStr,...);
	else
		szLog 			= formatStr;
	end
	if l_logOn == true then
		CTransLua:OutPutLog(szLog);
	end
end

function MakRetn(a,b)

	return a*10 + b;
end
