--------------------------------------------------------------------------------
-- ļ: util.lua
-- : 2013-12-06
-- : Ӹ
-- : 豣ȫ÷װ
--------------------------------------------------------------------------------

local common = LibStub("LibAddon"):GetAddon("common")
local util = common.util

--------------------------
-- Ĭurlҳ
function util:open_web_page(url)
	CUIControl:getSingleton():OpenWebUrl( url )
end

-------------------------
-- ݴڻȡʾַ
-- text: ԭʼַ
-- font: 
-- width: 
-- app: ַ, ȱʡΪ"..."
-- ֵ: ʾַ
function util:get_display_text(text, font, width, app)
	local app = app or "...";

	if (font:getTextExtent(text) <= width) then		
		return text;
	end

	width = width - font:getTextExtent(app);
	local new_text = text;
	while (font:getTextExtent(new_text) > width and width > 0) do	
		new_text = string.utf8sub(new_text, 1, -2);		
	end	
	
	return new_text .. app;
end

-------------------------
-- ȡϷ(̱ʶ)
function util:get_game_id()
	 return common.global["g_game_id"] or -1
end

------------------------
-- ȡϷʶ
function util:get_server_id()
	return common.global["g_game_server_id"] or 0
end

------------------------
-- ӡ
function util:PrintTable(table, rowname, level, print_func)
	local print_func = print_func or __LOG__
	if ( rowname == nil ) then rowname = "ROOT"; end
	if ( level == nil ) then level = 1; end

	local msg = "";
	for i=1,level, 1 do
		msg = msg .. "   ";
	end

	if ( table == nil ) then print_func (msg.."["..rowname.."] := nil "); return end
	if ( type(table) == "table" ) then
		print_func (msg..rowname.." { ");
		for k,v in pairs(table) do
			self:PrintTable(v,k,level+1, print_func);
		end
		print_func (msg.."} ");
	elseif (type(table) == "function" ) then
		print_func (msg.."["..rowname.."] => {{FunctionPtr*}}");
	elseif (type(table) == "userdata" ) then
		print_func (msg.."["..rowname.."] => {{UserData}}");
	elseif (type(table) == "boolean" ) then
		local value = "true";
		if ( not table ) then
			value = "false";
		end
		print_func (msg.."["..rowname.."] => "..value);
	else
		print_func (msg.."["..rowname.."] => "..table);
	end
end

