--------------------------------------------------------------------------------
-- ļ: const_value.lua
-- : 2013-12-06
-- : Ӹ
-- : ȫֵĳ, ȫֵĳ
--------------------------------------------------------------------------------
local common = LibStub("LibAddon"):GetAddon("common")
local type = type
local CONST_TABLE = {}
local t = CONST_TABLE

t.g_login_mode_normal = 1 	-- ¼ģʽ
t.g_login_mode_fast = 2	-- ٵ¼ģʽ

-- ¼״̬
t.g_Unlogin = 0           -- δ¼
t.g_Normal = 1            -- ¼
t.g_Anonymous = 2        -- ¼

t.Enhance_On = 1;
t.Enhance_Off = 0;
t.Mute_On = 1;
t.Mute_Off = 0;   --1=״̬0=ر״̬
t.obj_Mic = 2;
t.obj_Voice = 1;  --2=ʾˡ1=ʾ
t.g_type_team=1;
t.g_type_channel=2;   --ʾ顢ʾƵ
t.g_speak_key=0;
t.g_speak_mouse=1;
t.g_speak_free=2;
t.g_strHover  = "HoverImage"
t.g_strPushed = "PushedImage"
t.g_strNormal = "NormalImage" 
t.g_strDisabled = "DisabledImage"

t.g_defaultMainbarposX = -91
t.g_defaultMainbarposY = 30
t.g_defaultMainbarscaleX = 0.5
t.g_defaultMainbarscaleY = 0

--¼ͺ͵¼־
t.type_fast_login 	 = 0	--ٵ¼
t.type_normal_login  = 1	--ͨ¼
t.type_visitor_login = 2	--ο͵¼

t.login_flag_normal  = 0	--Ĭ޲
t.login_flag_killyy  = 1	--˳YY

local mt = {
	__index = function (t, k)
		return CONST_TABLE[k]
	end,
	__newindex = function (t, k, v)
		geterrorhandler()("can't update const value " .. tostring(k))
	end
}

setmetatable(common.const, mt)


function common:add_const(key, value)
	if (type(key) == "table") then
		for k, v in pairs(key) do
			self:add_const(k, v)
		end
	elseif (type(key) == "string") then
		if (self.const[key]) then
			geterrorhandler()("common:add_const(key, value) failed. 'key' "..key.." exist.")
		end
		
		CONST_TABLE[key] = value
	else
		geterrorhandler()("common:add_const(key, value): 'key'  - string expected.")
	end
	
end

function common:print_all_const(print_func)
	local print_func = print_func or function(...) self:print(...) end
	print_func("const value count:", #CONST_TABLE)
	for k, v in pairs(CONST_TABLE) do
		print_func("    ", k, "=", tostring(self.const[k]))
	end
end