/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.Header;
import com.flazr.Packet;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlvWriter {
    private static final Logger logger = LoggerFactory.getLogger(FlvWriter.class);
    private ByteBuffer out;
    private FileChannel channel;
    private FileOutputStream fos;
    private int videoTs;
    private int audioTs;
    private int lastLoggedSeconds;

    public FlvWriter(String fileName) {
        try {
            File file = new File(fileName);
            this.fos = new FileOutputStream(file);
            this.channel = this.fos.getChannel();
            logger.info("opened file for writing: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.out = ByteBuffer.allocate((int)1024);
        this.out.setAutoExpand(true);
        this.writeHeader();
    }

    public void close() {
        try {
            this.channel.close();
            this.fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        double duration = this.videoTs / 1000;
        logger.info("closed file, video duration: " + duration + " seconds");
    }

    private void writeHeader() {
        this.out.put((byte)70);
        this.out.put((byte)76);
        this.out.put((byte)86);
        this.out.put((byte)1);
        this.out.put((byte)5);
        this.out.putInt(9);
        this.out.putInt(0);
        this.out.flip();
        this.write(this.out);
    }

    public void write(Packet packet) {
        Header header = packet.getHeader();
        if (header.getSize() == 0) {
            logger.debug("skipping packet where size == 0");
            return;
        }
        this.write(header.getPacketType(), packet.getData(), header.getTime(), header.isRelative());
    }

    public void writeFlvData(ByteBuffer data) {
        while (true) {
            if (data.remaining() < 1) break;
            Packet.Type packetType = Packet.Type.parseByte(data.get());
            int size = FlvWriter.readInt24(data);
            int timestamp = FlvWriter.readInt24(data);
            data.getInt();
            byte[] bytes = new byte[size];
            data.get(bytes);
            ByteBuffer temp = ByteBuffer.wrap((byte[])bytes);
            this.write(packetType, temp, timestamp, false);
            int endSize = data.getInt();
            if (endSize == size + 11) continue;
            logger.debug("unexpected FLV tag size: " + endSize + ", expected: " + size);
        }
        logger.debug("no data remaining, stop writing FLV bulk data");
    }

    private void write(Packet.Type packetType, ByteBuffer data, int timer, boolean relative) {
        int timestamp = 0;
        if (relative) {
            if (packetType == Packet.Type.VIDEO_DATA) {
                this.videoTs += timer;
                timestamp = this.videoTs;
            } else if (packetType == Packet.Type.AUDIO_DATA) {
                this.audioTs += timer;
                timestamp = this.audioTs;
            }
        } else {
            timestamp = timer;
            if (packetType == Packet.Type.VIDEO_DATA) {
                this.videoTs = timestamp;
            } else if (packetType == Packet.Type.AUDIO_DATA) {
                this.audioTs = timestamp;
            }
        }
        int seconds = this.videoTs / 1000;
        if (seconds >= this.lastLoggedSeconds + 10) {
            logger.info("video write progress: " + seconds + " seconds");
            this.lastLoggedSeconds += 10;
        }
        this.out.clear();
        this.out.put(packetType.byteValue());
        FlvWriter.writeInt24(this.out, data.limit());
        FlvWriter.writeInt24(this.out, timestamp);
        this.out.putInt(0);
        this.out.flip();
        this.write(this.out);
        this.write(data);
        this.out.clear();
        this.out.putInt(data.limit() + 11);
        this.out.flip();
        this.write(this.out);
    }

    private void write(ByteBuffer buffer) {
        try {
            this.channel.write(buffer.buf());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int readInt24(ByteBuffer in) {
        int val = 0;
        val += (in.get() & 0xFF) * 256 * 256;
        val += (in.get() & 0xFF) * 256;
        return val += in.get() & 0xFF;
    }

    private static void writeInt24(ByteBuffer out, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        out.put(bytes);
    }
}

