/*
 * Decompiled with CFR 0.152.
 */
package com.flazr;

import com.flazr.AmfObject;
import com.flazr.ByteToEnum;
import java.util.Date;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmfProperty {
    private static final Logger logger = LoggerFactory.getLogger(AmfProperty.class);
    private Type type;
    private String name;
    private Object value;

    public AmfProperty() {
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public AmfProperty(Object o) {
        this(null, o);
    }

    public AmfProperty(String name, Object o) {
        this.name = name;
        this.value = o;
        if (o instanceof Number) {
            this.type = Type.NUMBER;
            this.value = Double.parseDouble(o.toString());
        } else if (o instanceof Boolean) {
            this.type = Type.BOOLEAN;
        } else if (o instanceof String) {
            this.type = Type.STRING;
        } else if (o instanceof AmfObject) {
            this.type = Type.OBJECT;
        } else if (o == null) {
            this.type = Type.NULL;
        } else if (o instanceof Map) {
            this.type = Type.MIXED_ARRAY;
        } else {
            throw new RuntimeException("unexpected parameter type: " + o.getClass());
        }
    }

    private static String decodeString(ByteBuffer in) {
        short size = in.getShort();
        byte[] bytes = new byte[size];
        in.get(bytes);
        return new String(bytes);
    }

    private static void encodeString(ByteBuffer out, String value) {
        byte[] bytes = value.getBytes();
        out.putShort((short)bytes.length);
        out.put(bytes);
    }

    public static void encode(ByteBuffer out, Object ... values) {
        for (Object value : values) {
            AmfProperty temp = new AmfProperty(value);
            temp.encode(out);
        }
    }

    public static ByteBuffer encode(Object ... values) {
        ByteBuffer out = ByteBuffer.allocate((int)1024);
        AmfProperty.encode(out, values);
        return out;
    }

    public void decode(ByteBuffer in, boolean decodeName) {
        if (decodeName) {
            this.name = AmfProperty.decodeString(in);
        }
        this.type = Type.parseByte(in.get());
        switch (this.type) {
            case NUMBER: {
                this.value = in.getDouble();
                break;
            }
            case BOOLEAN: {
                this.value = in.get() == 1;
                break;
            }
            case STRING: {
                this.value = AmfProperty.decodeString(in);
                break;
            }
            case OBJECT: {
                logger.debug("decoding nested object");
                AmfObject object = new AmfObject();
                object.decode(in, true);
                this.value = object;
                break;
            }
            case NULL: {
                break;
            }
            case ARRAY: {
                int arraySize = in.getInt();
                logger.debug("decoding nested array of size: " + arraySize);
                AmfObject array = new AmfObject();
                array.decode(in, false);
                this.value = array;
                break;
            }
            case MIXED_ARRAY: {
                int mixedArraySize = in.getInt();
                logger.debug("decoding nested mixed array of size: " + mixedArraySize);
                AmfObject map = new AmfObject();
                map.decode(in, true);
                this.value = map;
                break;
            }
            case DATE: {
                this.value = new Date((long)in.getDouble());
                break;
            }
            case UNDEFINED: 
            case UNSUPPORTED: {
                break;
            }
            default: {
                throw new RuntimeException("unknown type");
            }
        }
        logger.debug("decoded property: " + this.toString());
    }

    public void encode(ByteBuffer out) {
        logger.debug("encoding property: " + this.toString());
        if (this.name != null) {
            AmfProperty.encodeString(out, this.name);
        }
        out.put(this.type.value);
        switch (this.type) {
            case NUMBER: {
                out.putDouble(((Double)this.value).doubleValue());
                break;
            }
            case BOOLEAN: {
                boolean bool = (Boolean)this.value != false;
                out.put((byte)(bool ? 1 : 0));
                break;
            }
            case STRING: {
                AmfProperty.encodeString(out, (String)this.value);
                break;
            }
            case NULL: {
                break;
            }
            case OBJECT: {
                logger.debug("encoding nested object");
                AmfObject object = (AmfObject)this.value;
                object.encode(out);
                break;
            }
            default: {
                throw new RuntimeException("unexpected type: " + this.type);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.type).append(" ");
        if (this.name != null) {
            sb.append(this.name).append(": ");
        }
        sb.append(this.value).append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ByteToEnum.Convert
    {
        NUMBER(0),
        BOOLEAN(1),
        STRING(2),
        OBJECT(3),
        NULL(5),
        UNDEFINED(6),
        MIXED_ARRAY(8),
        ARRAY(10),
        DATE(11),
        UNSUPPORTED(13);

        private final byte value;
        private static ByteToEnum<Type> converter;

        private Type(int byteValue) {
            this.value = (byte)byteValue;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        public static Type parseByte(byte b) {
            return converter.parseByte(b);
        }

        public String toString() {
            return converter.toString(this);
        }

        static {
            converter = new ByteToEnum((Enum[])Type.values());
        }
    }
}

