/*=======================================================================
*
*   Copyright (C) 2014 Lysine.
*
*   Filename:    Display.js
*   Time:        2014/07/05
*   Author:      Lysine
*
*   Lysine is a student majoring in Software Engineering
*   from the School of Software, SUN YAT-SEN UNIVERSITY.
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 3 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.

*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
=========================================================================*/

Display={};

Display.createProperty=function(pro,obj){
    var self={};
    self.fromValue=0;
    self.startDelay=0;
    self.easing="None";
    self.repeat=1;
    self.lifeTime=obj.lifeTime;
    self.finished=false;
    for(var p in pro){
        self[p]=pro[p];
    }
    self.lifeTime*=1000;
    self.currentValue=function(time){
        if(self.toValue!==undefined){
            if(self.finished){
                return self.toValue;
            }
            var dur=self.startDelay+self.lifeTime;
            if((time/dur)<=self.repeat){
                var pos=time%dur-self.startDelay;
                if(pos<=0){
                    return time>self.startDelay?self.toValue:self.fromValue;
                }
                else{
                    return self.fromValue+(self.toValue-self.fromValue)*(pos/self.lifeTime);
                }
            }
            else{
                self.finished=true;
                return self.toValue;
            }
        }
        else{
            self.finished=true;
            return self.fromValue;
        }
    }
    return self;
}

Display.createElement=function(obj){
    var self={};
    self.x=0;
    self.y=0;
    self.alpha=1;
    self.lifeTime=2;
    self.rotationX=0;
    self.rotationY=0;
    self.rotationZ=0;
	self.scaleX=1;
	self.scaleY=1;
    self.filters=[];
    for(var p in obj){
        self[p]=obj[p];
    }
    self.lifeTime*=1000;
    self.liveTime=0;
    self.skipTime=0;
    if(!self.parent){
        self.parent=Display.root;
    }
    self.children=[];

    self.addChild=function(ele){
        self.children.push(ele);
    }

    if(self.motionGroup){
        for(var i=0;i<self.motionGroup.length;i++){
            var m=self.motionGroup[i];
            for(var p in m){
                m[p]=Display.createProperty(m[p],self);
            }
        }
    }
    else if(self.motion){
        for(var p in self.motion){
            self.motion[p]=Display.createProperty(self.motion[p],self);
        }
    }

    self.step=function(time){
        self.liveTime+=time;
        for(var i=0;i<self.children.length;i++){
            var c=self.children[i];
            c.step(time);
            if(c.liveTime>c.lifeTime){
                self.children.splice(i,1);
            }
        }

        if(self.motionGroup){
            var head=self.motionGroup[0];
            var flag=(head!==undefined);
            for(var p in head){
                if(!head[p].finished){
                    flag=false;
                    break;
                }
            }
            if(flag){
                self.motionGroup.splice(0,1);
                self.skipTime=self.liveTime;
            }
            self.motion=self.motionGroup[0];
        }

        if(self.motion){
            for(var p in self.motion){
                self[p]=self.motion[p].currentValue(self.liveTime-self.skipTime);
            }
        }
    }

    if(self.parent){
        self.parent.addChild(self);

        self.remove=function(){
            var list=self.parent.children;
            for(var i in list){
                if(list[i]===self){
                    list.splice(i,1);
                    break;
                }
            }
        }
    }
    return self;
}

Display.createComment=function(str,obj){
    var self=Display.createElement(obj);
	var set=function(p,v){
		self[p]=self[p]===undefined?v:self[p];
	}
    set('fontsize',25);
    self.alwaysShowSelection=false;
    set('background',false);
    set('backgroundColor',0);
    set('border',false);
    set('borderColor',0xffffff);
    self.bottomScrollV=1;
    self.condenseWhite=true;
    self.defaultTextFormat=null;
    self.gridFitType=null;
    self.htmlText=str;
    self.length=str.length;
    self.multiline=false;
    self.numLines=0;
    self.restrict=null;
    self.sharpness=1;
    self.text=str;
    self.textColor=self.color===undefined?0xffffff:self.color;
    self.textHeight=0;
    self.textWidth=0;
    self.thickness=1;
    self.wordWrap=false;
    self.bold=false;

    self.appendText=function(add){
        self.text+=add;
    }

    self.getTextFormat=function(){
        return {};
    }
    self.setTextFormat=function(){}

    return self;
}

Display.createGraphic=function(){
    var self={};
    self.commands=[];
    var createCommand=function(a,m){
        var c=[m];
        for(var i in a){
            c.push(a[i]);
        }
        return c;
    };
    self.beginFill=function(){
        self.commands.push(createCommand(arguments,"Drawer.beginFill"));
    }
    self.beginGradientFill=function(){
        self.commands.push(createCommand(arguments,"Drawer.beginGradientFill"));
    }
    self.beginGradientFill=function(){
        self.commands.push(createCommand(arguments,"Drawer.beginGradientFill"));
    }
    self.clear=function(){
        self.commands=[];
    }
    self.curveTo=function(){
        self.commands.push(createCommand(arguments,"Drawer.curveTo"));
    }
    self.drawCircle=function(){
        self.commands.push(createCommand(arguments,"Drawer.drawCircle"));
    }
    self.drawEllipse=function(){
        self.commands.push(createCommand(arguments,"Drawer.drawEllipse"));
    }
    self.drawRect=function(){
        self.commands.push(createCommand(arguments,"Drawer.drawRect"));
    }
    self.drawRoundRect=function(){
        self.commands.push(createCommand(arguments,"Drawer.drawRoundRect"));
    }
    self.endFill=function(){
        self.commands.push(createCommand(arguments,"Drawer.endFill"));
    }
    self.lineGradientStyle=function(){
        self.commands.push(createCommand(arguments,"Drawer.lineGradientStyle"));
    }
    self.lineStyle=function(){
        self.commands.push(createCommand(arguments,"Drawer.lineStyle"));
    }
    self.lineTo=function(){
        self.commands.push(createCommand(arguments,"Drawer.lineTo"));
    }
    self.moveTo=function(){
        self.commands.push(createCommand(arguments,"Drawer.moveTo"));
    }
    return self;
}

Display.createShape=function(obj){
    var self=Display.createElement(obj);
    self.graphics=Display.createGraphic();
    return self;
}

Display.createButton=function(){};

Display.createCanvas=Display.createElement;

Display.root=Display.createCanvas();
Display.root.clear=function(){
    Display.root.children=[];
};

Display.draw=function(element)
{
    if(element===undefined){
        element=Display.root;
    }
    callNative("Drawer.begin");
    callNative('Drawer.fade',element.alpha);
    callNative('Drawer.translate',element.x,element.y);
    callNative('Drawer.rotate',element.rotationX,element.rotationY,element.rotationZ);
    callNative('Drawer.scale',element.scaleX,element.scaleY);
    if(element){
        if(element.graphics){
            var commands=element.graphics.commands;
            for(var i in commands){
                callNative.apply(undefined,commands[i]);
            }
        }
        else if(element.text){
            callNative('Drawer.drawText',element.text,element.textColor,element.fontsize);
        }
    }
    for(var i in element.children){
        Display.draw(element.children[i]);
    }
    for(var i in element.filters){
        var f=element.filters[i];
		switch(f.type){
		case 'blur':
		    callNative('Drawer.blur',f.blurX,f.blurY,f.quality);
		    break;
		case 'glow':
		    callNative('Drawer.glow',f.color,f.alpha,f.blurX,f.blurY,f.strength,f.quality);
		    break;
	    }
    }
    callNative('Drawer.end');
}

Display.createGlowFilter=function(color,alpha,blurX,blurY,strength,quality){
	self={};
	self.type='glow';
	self.color=color;
	self.alpha=alpha;
	self.blurX=blurX;
	self.blurY=blurY;
	self.strength=strength;
	self.quality=quality;
	return self;
};

Display.createBlurFilter=function(blurX,blurY,quality){
	self={};
	self.type='blur';
	self.blurX=blurX;
	self.blurY=blurY;
	self.quality=quality;
	return self;
};

$=Display;
