/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.util.AbstractDumpDexCodeAdapter;
import com.googlecode.dex2jar.util.DexOpcodeDump;
import com.googlecode.dex2jar.util.Dump;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpDexCodeAdapter
extends AbstractDumpDexCodeAdapter {
    private List<DexLabel> labels = new ArrayList<DexLabel>();
    private Method method;
    private PrintWriter out;
    private List<TryCatch> trys = new ArrayList<TryCatch>();
    private Map<DexLabel, Integer> lines = new HashMap<DexLabel, Integer>();
    private boolean isStatic;

    public DumpDexCodeAdapter(boolean isStatic, Method m, PrintWriter out) {
        this.method = m;
        this.out = out;
        this.isStatic = isStatic;
    }

    @Override
    protected void info(int opcode, String format, Object ... args) {
        String s = String.format(format, args);
        if (opcode < 0) {
            this.out.printf("%-20s|%5s|%s\n", "", "", s);
        } else {
            this.out.printf("%-20s|%5s|%s\n", DexOpcodeDump.dump(opcode), "", s);
        }
    }

    @Override
    protected String labelToString(DexLabel label) {
        int i = this.labels.indexOf(label);
        if (i > -1) {
            return "L" + i;
        }
        this.labels.add(label);
        return "L" + this.labels.indexOf(label);
    }

    @Override
    public void visitArguments(int total, int[] args) {
        int i = 0;
        if (!this.isStatic) {
            int reg = args[i++];
            String type = Dump.toJavaClass(this.method.getOwner());
            this.out.printf("%20s:v%d   //%s\n", "this", reg, type);
        }
        String[] stringArray = this.method.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            int reg = args[i++];
            type = Dump.toJavaClass(type);
            this.out.printf("%20s:v%d   //%s\n", "", reg, type);
            ++n2;
        }
    }

    @Override
    public void visitLabel(DexLabel label) {
        boolean find = false;
        for (TryCatch tc : this.trys) {
            if (!label.equals(tc.end)) continue;
            this.info(-1, " } // TC_%d", this.trys.indexOf(tc));
            find = true;
            break;
        }
        Integer line = this.lines.get(label);
        if (line != null) {
            this.out.printf("%-20s|%5s: line %d\n", "LABEL", "L" + this.labelToString(label), line);
        } else {
            this.out.printf("%-20s|%5s:\n", "LABEL", "L" + this.labelToString(label));
        }
        if (!find) {
            block1: for (TryCatch tc : this.trys) {
                if (label.equals(tc.start)) {
                    this.info(-1, "try { // TC_%d ", this.trys.indexOf(tc));
                    break;
                }
                int i = 0;
                while (i < tc.handlers.length) {
                    String type = tc.types[i];
                    DexLabel handler = tc.handlers[i];
                    if (label.equals(handler)) {
                        String t = type;
                        this.info(-1, "catch(%s) // TC_%d", t == null ? "all" : t, this.trys.indexOf(tc));
                        continue block1;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handlers, String[] types) {
        TryCatch tc = new TryCatch(start, end, handlers, types);
        this.trys.add(tc);
        int id = this.trys.indexOf(tc);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            DexLabel handler = handlers[i];
            if (type == null) {
                this.out.printf("TR_%d L%s ~ L%s > L%s all\n", id, this.labelToString(start), this.labelToString(end), this.labelToString(handler));
            } else {
                this.out.printf("TR_%d L%s ~ L%s > L%s %s\n", id, this.labelToString(start), this.labelToString(end), this.labelToString(handler), type);
            }
            ++i;
        }
        super.visitTryCatch(start, end, handlers, types);
    }

    @Override
    public void visitLineNumber(int line, DexLabel label) {
        this.lines.put(label, line);
    }

    @Override
    public void visitLocalVariable(String name, String type, String signature, DexLabel start, DexLabel end, int reg) {
        this.out.printf("LOCAL_VARIABLE L%s ~ L%s v%d -> %s // %s \n", this.labelToString(start), this.labelToString(end), reg, name, type);
    }

    private static class TryCatch {
        public DexLabel end;
        public DexLabel[] handlers;
        public DexLabel start;
        public String[] types;

        public TryCatch(DexLabel start, DexLabel end, DexLabel[] handlers, String[] types) {
            this.start = start;
            this.end = end;
            this.handlers = handlers;
            this.types = types;
        }
    }
}

