/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

@BaseCmd.Syntax(cmd="d2j-decrpyt-string", syntax="[options] <jar>", desc="Decrypt in class file", onlineHelp="https://code.google.com/p/dex2jar/wiki/DecryptStrings")
public class DecryptStringCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output of .jar files, default is $current_dir/[jar-name]-decrypted.jar", argName="out")
    private File output;
    @BaseCmd.Opt(opt="mo", longOpt="decrypt-method-owner", description="the owner of the mothed which can decrypt the stings, example: java.lang.String", argName="owner")
    private String methodOwner;
    @BaseCmd.Opt(opt="mn", longOpt="decrypt-method-name", description="the owner of the mothed which can decrypt the stings, the method's signature must be static (type)Ljava/lang/String;", argName="name")
    private String methodName;
    @BaseCmd.Opt(opt="cp", longOpt="classpath", description="add extra lib to classpath", argName="cp")
    private String classpath;
    @BaseCmd.Opt(opt="t", longOpt="arg-type", description="the type of the method's argument, int,string. default is string", argName="type")
    private String type = "string";

    public static void main(String[] args) {
        new DecryptStringCmd().doMain(args);
    }

    @Override
    protected void doCommandLine() throws Exception {
        String targetMethodDesc;
        Method jmethod;
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File jar = new File(this.remainingArgs[0]);
        if (!jar.exists()) {
            System.err.println(jar + " is not exists");
            return;
        }
        if (this.methodName == null || this.methodOwner == null) {
            System.err.println("Please set --decrypt-method-owner and --decrypt-method-name");
            return;
        }
        if (this.output == null) {
            this.output = jar.isDirectory() ? new File(String.valueOf(jar.getName()) + "-decrypted.jar") : new File(String.valueOf(FilenameUtils.getBaseName((String)jar.getName())) + "-decrypted.jar");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            return;
        }
        System.err.println(jar + " -> " + this.output);
        ArrayList<String> list = new ArrayList<String>();
        if (this.classpath != null) {
            list.addAll(Arrays.asList(this.classpath.split(";|:")));
        }
        list.add(jar.getAbsolutePath());
        URL[] urls = new URL[list.size()];
        int i = 0;
        while (i < list.size()) {
            urls[i] = new File((String)list.get(i)).toURI().toURL();
            ++i;
        }
        try {
            Class argType = "string".equals(this.type) ? String.class : Integer.TYPE;
            URLClassLoader cl = new URLClassLoader(urls);
            jmethod = cl.loadClass(this.methodOwner).getDeclaredMethod(this.methodName, argType);
            jmethod.setAccessible(true);
            targetMethodDesc = Type.getMethodDescriptor((Method)jmethod);
        }
        catch (Exception ex) {
            System.err.println("can't load method: String " + this.methodOwner + "." + this.methodName + "(" + this.type + ")");
            ex.printStackTrace();
            return;
        }
        final String methodOwnerInternalType = this.methodOwner.replace('.', '/');
        final FileOut.OutHandler fo = FileOut.create((File)this.output, (boolean)true);
        try {
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    if (isDir || !name.endsWith(".class")) {
                        fo.write(isDir, name, current == null ? null : current.get(), nameObject);
                        return;
                    }
                    ClassReader cr = new ClassReader(current.get());
                    ClassNode cn = new ClassNode();
                    cr.accept((ClassVisitor)cn, 8);
                    for (Object m0 : cn.methods) {
                        MethodNode m = (MethodNode)m0;
                        if (m.instructions == null) continue;
                        AbstractInsnNode p = m.instructions.getFirst();
                        while (p != null) {
                            if (p.getOpcode() == 184) {
                                MethodInsnNode mn = (MethodInsnNode)p;
                                if (mn.name.equals(DecryptStringCmd.this.methodName) && mn.desc.equals(targetMethodDesc) && mn.owner.equals(methodOwnerInternalType)) {
                                    AbstractInsnNode q = p.getPrevious();
                                    AbstractInsnNode next = p.getNext();
                                    if (q.getOpcode() == 18) {
                                        LdcInsnNode ldc = (LdcInsnNode)q;
                                        DecryptStringCmd.tryReplace(m.instructions, p, q, jmethod, ldc.cst);
                                    } else if (q.getType() == 1) {
                                        IntInsnNode in = (IntInsnNode)q;
                                        DecryptStringCmd.tryReplace(m.instructions, p, q, jmethod, in.operand);
                                    } else {
                                        switch (q.getOpcode()) {
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                int x = ((InsnNode)q).getOpcode() - 3;
                                                DecryptStringCmd.tryReplace(m.instructions, p, q, jmethod, x);
                                            }
                                        }
                                    }
                                    p = next;
                                    continue;
                                }
                            }
                            p = p.getNext();
                        }
                    }
                    ClassWriter cw = new ClassWriter(0);
                    cn.accept((ClassVisitor)cw);
                    fo.write(false, String.valueOf(cr.getClassName()) + ".class", cw.toByteArray(), null);
                }
            }).walk(jar);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fo);
        }
    }

    public static AbstractInsnNode tryReplace(InsnList instructions, AbstractInsnNode p, AbstractInsnNode q, Method jmethod, Object arg) {
        try {
            String newValue = (String)jmethod.invoke(null, arg);
            LdcInsnNode nLdc = new LdcInsnNode((Object)newValue);
            instructions.insertBefore(p, (AbstractInsnNode)nLdc);
            instructions.remove(p);
            instructions.remove(q);
            return nLdc.getNext();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

