/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import com.iflytek.skintool.util.BufferedImageBuilder;
import com.iflytek.skintool.util.Logger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PictureUtil {
    private static final String FILE_DIR = "E:/j_workspace/IFlyImeSkinObersveApp3/src/skin/";
    private static Image mImage;

    public static Image getCombinPicture(String backfilepath, int newWidth, int newHeight, String forefilepath) {
        backfilepath = FILE_DIR + backfilepath;
        ImageIcon backfile = new ImageIcon(backfilepath);
        ImageIcon forefile = new ImageIcon(forefilepath);
        ImageIcon newIcon = new ImageIcon(backfile.getImage().getScaledInstance(newWidth, newHeight, 1));
        Image backImage = newIcon.getImage();
        Image foreImage = forefile.getImage();
        int backWidth = backImage.getWidth(null);
        int backHeight = backImage.getHeight(null);
        int foreWidth = foreImage.getWidth(null);
        int foreHeight = foreImage.getHeight(null);
        BufferedImage image = new BufferedImage(backWidth, backHeight, 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(backImage, 0, 0, backWidth, backHeight, null);
        g.drawImage(foreImage, (backWidth - foreWidth) / 2, (backHeight - foreHeight) / 2, foreWidth, foreHeight, null);
        g.dispose();
        mImage = image;
        return mImage;
    }

    public static Image getCombinPicture(ImageIcon backIcon, int newWidth, int newHeight, ImageIcon foreIcon) {
        Image backImage = backIcon.getImage();
        Image foreImage = foreIcon.getImage();
        int backWidth = backImage.getWidth(null);
        int backHeight = backImage.getHeight(null);
        int foreWidth = foreImage.getWidth(null);
        int foreHeight = foreImage.getHeight(null);
        BufferedImage image = new BufferedImage(backWidth, backHeight, 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(backImage, 0, 0, backWidth, backHeight, null);
        g.drawImage(foreImage, (backWidth - foreWidth) / 2 + 5, (backHeight - foreHeight) / 2, foreWidth - 10, foreHeight, null);
        g.dispose();
        mImage = image;
        return mImage;
    }

    public static ImageIcon getCombinPicture(ImageIcon backIcon, ImageIcon foreIcon) {
        if (backIcon == null) {
            return foreIcon;
        }
        if (foreIcon == null) {
            return backIcon;
        }
        Image backImage = backIcon.getImage();
        Image foreImage = foreIcon.getImage();
        int backWidth = backImage.getWidth(null);
        int backHeight = backImage.getHeight(null);
        int foreWidth = foreImage.getWidth(null);
        int foreHeight = foreImage.getHeight(null);
        BufferedImage image = new BufferedImage(backWidth, backHeight, 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(backImage, 0, 0, backWidth, backHeight, null);
        g.drawImage(foreImage, (backWidth - foreWidth) / 2, (backHeight - foreHeight) / 2, foreWidth, foreHeight, null);
        g.dispose();
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }

    public static Icon createBiggerSmallerIcon(Icon icon, int width, int height) {
        ImageIcon icon1 = (ImageIcon)icon;
        Image img = icon1.getImage().getScaledInstance(width, height, 4);
        ImageIcon icon2 = new ImageIcon(img);
        icon2.setImage(img);
        return icon2;
    }

    public static BufferedImage createResizedImage(Image image, int width, int height) {
        BufferedImage scaleBI = new BufferedImage(width, height, 2);
        Graphics2D g = scaleBI.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return scaleBI;
    }

    public static ImageIcon setImageColor(ImageIcon image, int filter) {
        BufferedImage bf = BufferedImageBuilder.getInstance().bufferImage(image.getImage());
        int i = 0;
        while (i < image.getIconWidth()) {
            int j = 0;
            while (j < image.getIconHeight()) {
                bf.setRGB(i, j, PictureUtil.getFilteredColor(bf.getRGB(i, j), filter));
                ++j;
            }
            ++i;
        }
        bf.flush();
        return new ImageIcon(bf);
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getFilteredColor(int color, int filter) {
        int red = PictureUtil.getRed(filter);
        int green = PictureUtil.getGreen(filter);
        int blue = PictureUtil.getBlue(filter);
        int filteredColor = PictureUtil.getAlpha(color) << 24 | red << 16 | green << 8 | blue;
        return filteredColor;
    }

    public static ImageIcon setImageOpacity(ImageIcon image, int alpha) {
        if (image != null) {
            BufferedImage bf = BufferedImageBuilder.getInstance().bufferImage(image.getImage());
            int i = 0;
            while (i < image.getIconWidth()) {
                int j = 0;
                while (j < image.getIconHeight()) {
                    bf.setRGB(i, j, PictureUtil.getOpacityColor(bf.getRGB(i, j), alpha));
                    ++j;
                }
                ++i;
            }
            return new ImageIcon(bf);
        }
        return null;
    }

    public static int getOpacityColor(int color, int alpha) {
        int red = PictureUtil.getRed(color);
        int green = PictureUtil.getGreen(color);
        int blue = PictureUtil.getBlue(color);
        int changedAlpha = alpha * PictureUtil.getAlpha(color) / 255;
        int opacityColor = changedAlpha << 24 | red << 16 | green << 8 | blue;
        return opacityColor;
    }

    public static void getTiledImage(Graphics g, Image image, int x1, int x2, int y1, int y2, int width, int height) {
        try {
            g.drawImage(image, 0, 0, x1, y1, 0, 0, x1, y1, null);
            int x = 0;
            int y = 0;
            while (x <= width - image.getWidth(null) + x2 - x1) {
                if (x + (x2 - x1) < width + x2 - image.getWidth(null)) {
                    g.drawImage(image, x + x1, 0, x + x2, y1, x1, 0, x2, y1, null);
                } else {
                    g.drawImage(image, x + x1, 0, width + x2 - image.getWidth(null), y1, x1, 0, width + x2 - image.getWidth(null) - x, y1, null);
                }
                x += x2 - x1;
            }
            g.drawImage(image, width + x2 - image.getWidth(null), 0, width, y1, x2, 0, image.getWidth(null), y1, null);
            while (y <= height - image.getHeight(null) + y2 - y1) {
                if (y + (y2 - y1) < height - image.getHeight(null) + y2 - y1) {
                    g.drawImage(image, 0, y + y1, x1, y + y2, 0, y1, x1, y2, null);
                } else {
                    g.drawImage(image, 0, y + y1, x1, height - image.getHeight(null) + y2, 0, y1, x1, height - image.getHeight(null) + y2 - y, null);
                }
                y += y2 - y1;
            }
            x = 0;
            y = 0;
            while (y <= height - image.getHeight(null) + y2 - y1) {
                if (y + (y2 - y1) < height - image.getHeight(null) + y2 - y1) {
                    if (x + (x2 - x1) < width - image.getWidth(null) + x2 - x1) {
                        g.drawImage(image, x + x1, y + y1, x + x2, y + y2, x1, y1, x2, y2, null);
                        x += x2 - x1;
                        continue;
                    }
                    g.drawImage(image, x + x1, y + y1, width - image.getWidth(null) + x2, y + y2, x1, y1, width - image.getWidth(null) + x2 - x, y2, null);
                    y += y2 - y1;
                    x = 0;
                    continue;
                }
                if (x + (x2 - x1) < width - image.getWidth(null) + x2 - x1) {
                    g.drawImage(image, x + x1, y + y1, x + x2, height - image.getHeight(null) + y2, x1, y1, x2, height - image.getHeight(null) + y2 - y, null);
                    x += x2 - x1;
                    continue;
                }
                g.drawImage(image, x + x1, y + y1, width - image.getWidth(null) + x2, height - image.getHeight(null) + y2, x1, y1, width - image.getWidth(null) + x2 - x, height - image.getHeight(null) + y2 - y, null);
                y += y2 - y1;
                x = 0;
            }
            y = 0;
            while (y < height - image.getHeight(null) + y2 - y1) {
                if (y < height - image.getHeight(null)) {
                    g.drawImage(image, width - image.getWidth(null) + x2, y + y1, width, y + y2, x2, y1, image.getWidth(null), y2, null);
                } else {
                    g.drawImage(image, width - image.getWidth(null) + x2, y + y1, width, height - image.getHeight(null) + y2, x2, y1, image.getWidth(null), height - image.getHeight(null) + y2 - y, null);
                }
                y += y2 - y1;
            }
            g.drawImage(image, 0, height - image.getHeight(null) + y2, x1, height, 0, y2, x1, image.getHeight(null), null);
            x = 0;
            while (x < width - image.getWidth(null) + x2 - x1) {
                if (x < width - image.getWidth(null)) {
                    g.drawImage(image, x + x1, height - image.getHeight(null) + y2, x + x2, height, x1, y2, x2, image.getHeight(null), null);
                } else {
                    g.drawImage(image, x + x1, height - image.getHeight(null) + y2, width - image.getWidth(null) + x2, height, x1, y2, width - image.getWidth(null) + x2 - x, image.getHeight(null), null);
                }
                x += x2 - x1;
            }
            g.drawImage(image, width - image.getWidth(null) + x2, height - image.getHeight(null) + y2, width, height, x2, y2, image.getWidth(null), image.getHeight(null), null);
        }
        catch (Exception e) {
            Logger.DEBUG(e.getMessage());
        }
    }
}

