/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import com.iflytek.skintool.util.BaseFile;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class IniFile
extends BaseFile {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String COMMENT_TAG = "#";
    private static final String PROPERTY_START_TAG = "[";
    private static final String PROPERTY_END_TAG = "]";
    private static final String SEPARATE_TAG = "=";
    private static final String NEW_LINE = "\n";
    protected HashMap<String, HashMap<String, String>> mPropertiesMap;

    public IniFile(Object context, String path, boolean inAssets) {
        super(context, path, inAssets);
    }

    public IniFile(InputStream is) {
        super(is);
    }

    public IniFile(InputStream is, String format) {
        super(is, format);
    }

    public IniFile(BufferedReader br) throws IOException {
        this.mIsDamaged = true;
        if (br != null) {
            this.mPropertiesMap = new HashMap();
            this.realLoadFile(br);
        }
    }

    public IniFile(IniFile iniFile) {
        super(iniFile);
        this.mPropertiesMap = new HashMap<String, HashMap<String, String>>(iniFile.mPropertiesMap);
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public boolean inAssets() {
        return this.mInAssets;
    }

    @Override
    public void loadFile(InputStream is) {
        this.mIsDamaged = true;
        if (is != null) {
            this.mPropertiesMap = new HashMap();
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(is, this.mFormat);
                    br = new BufferedReader(isr, 8192);
                    this.realLoadFile(br);
                }
                catch (IOException iOException) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException4) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void realLoadFile(BufferedReader br) throws IOException {
        String str = null;
        HashMap<String, String> properties = null;
        while ((str = br.readLine()) != null) {
            str = str.trim();
            String key = null;
            String value = null;
            if (str.startsWith(COMMENT_TAG)) continue;
            if (str.startsWith(PROPERTY_START_TAG) && str.endsWith(PROPERTY_END_TAG)) {
                key = str.substring(1, str.length() - 1);
                if (key.length() <= 0) continue;
                properties = new HashMap<String, String>();
                this.mPropertiesMap.put(key, properties);
                continue;
            }
            if (!str.contains(SEPARATE_TAG)) continue;
            int index = str.indexOf(SEPARATE_TAG);
            key = str.substring(0, index).trim();
            value = str.substring(index + 1).trim();
            if (key.length() <= 0 || properties == null) continue;
            properties.put(key, value);
        }
        this.mIsDamaged = false;
    }

    public void freeProperties(String key) {
        if (this.mPropertiesMap != null) {
            this.mPropertiesMap.remove(key);
        }
    }

    public void freeProperties() {
        if (this.mPropertiesMap != null) {
            this.mPropertiesMap.clear();
            this.mPropertiesMap = null;
        }
    }

    public HashMap<String, String> getProperties(String key) {
        if (!this.mIsDamaged && this.mPropertiesMap != null) {
            return this.mPropertiesMap.get(key);
        }
        return null;
    }

    public HashMap<String, HashMap<String, String>> getAllProperties() {
        if (!this.mIsDamaged) {
            return this.mPropertiesMap;
        }
        return null;
    }

    public boolean merge(IniFile file) {
        if (file.isDamaged()) {
            return false;
        }
        if (this.mPropertiesMap == null) {
            this.mPropertiesMap = new HashMap();
        }
        HashMap<String, HashMap<String, String>> allProperties = file.getAllProperties();
        for (Map.Entry<String, HashMap<String, String>> entry : allProperties.entrySet()) {
            this.mPropertiesMap.put(entry.getKey(), entry.getValue());
        }
        this.mIsDamaged = false;
        return true;
    }

    public void writeToFile(String path) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, HashMap<String, String>> enOut : this.mPropertiesMap.entrySet()) {
            String keyStr = PROPERTY_START_TAG + enOut.getKey() + "]\n";
            sb.append(keyStr);
            for (Map.Entry<String, String> enIn : enOut.getValue().entrySet()) {
                String attrSrr = String.valueOf(enIn.getKey()) + SEPARATE_TAG + enIn.getValue();
                sb.append(attrSrr);
            }
            sb.append("\r\n");
        }
        try {
            FileOutputStream out = new FileOutputStream(path);
            out.write(sb.toString().getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

