/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public abstract class BaseFile {
    public static final String FORMAT_UTF8 = "utf-8";
    public static final String FORMAT_UTF16 = "utf-16";
    protected String mFilePath = null;
    protected boolean mInAssets = false;
    protected boolean mIsDamaged = false;
    protected String mFormat = "utf-8";

    protected abstract void loadFile(InputStream var1);

    public BaseFile() {
    }

    public BaseFile(Object context, String path, boolean inAssets) {
        this.mFilePath = path;
        this.mInAssets = inAssets;
        InputStream is = this.getInputStream(path, inAssets);
        this.loadFile(is);
    }

    public BaseFile(InputStream is) {
        this.loadFile(is);
    }

    public BaseFile(InputStream is, String format) {
        this.mFormat = format;
        this.loadFile(is);
    }

    public BaseFile(BaseFile file) {
        if (file != null && !file.isDamaged()) {
            this.mFilePath = file.mFilePath;
            this.mInAssets = file.mInAssets;
            this.mIsDamaged = file.mIsDamaged;
        }
    }

    public boolean isDamaged() {
        return this.mIsDamaged;
    }

    protected InputStream getInputStream(String path, boolean inAssets) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return is;
    }
}

