/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.utils;

import com.iflytek.skintool.domin.KeyImageData;
import com.iflytek.skintool.model.common.ImageData;
import com.iflytek.skintool.model.theme.ThemeInfo;
import com.iflytek.skintool.parser.common.ImageParser;
import com.iflytek.skintool.parser.theme.ThemeInfoParser;
import com.iflytek.skintool.parser.utils.ThemeFileParser;
import com.iflytek.skintool.util.ManageUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ThemeFileManager {
    private String mSkinFileDir;
    private static ThemeFileManager mThemefilemanager = null;
    private String mCurrentThemeDir;
    private Object mContext;
    private int mCurrentResType;
    private ThemeInfo mCurrentThemeInfo;
    public static Map<String, Map<String, Properties>> mAllPropertiesMap = new HashMap<String, Map<String, Properties>>();
    private ThemeFileParser mThemeFileParser = new ThemeFileParser();
    private ImageParser mImageParser = new ImageParser(null);
    private String mImageName;
    private ThemeInfoParser mThemeInfoParser;

    private ThemeFileManager() {
    }

    public static ThemeFileManager getInstance() {
        if (mThemefilemanager == null) {
            mThemefilemanager = new ThemeFileManager();
        }
        return mThemefilemanager;
    }

    public ImageParser getImageParser() {
        return this.mImageParser;
    }

    public Map<String, Properties> getSkinFile(boolean land, String filename, int index) {
        this.mCurrentThemeDir = ManageUtils.flag ? String.valueOf(ManageUtils.getDefaultThemeFilePath(index)) + ManageUtils.getDefaultThemeIniFilePath() : String.valueOf(ManageUtils.getDefaultThemeFilePath(index)) + ManageUtils.getDefaultLayoutIniFilePath();
        if (index == 0 && !ManageUtils.flag) {
            System.out.println("DEBUG");
        }
        return this.getPropertiesMap(this.mCurrentThemeDir, this.mCurrentResType, land, "layout", "layout-land", filename);
    }

    public Map<String, Properties> getThemeFile(String fileName, InputStream is) {
        Map<String, Properties> propertiesMap = mAllPropertiesMap.get(fileName);
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            propertiesMap = this.mThemeFileParser.getStreamProperties(is);
            mAllPropertiesMap.put(fileName, propertiesMap);
        }
        return propertiesMap;
    }

    public Map<String, Properties> getThemeFile(String themeDir, int resType) {
        return this.getPropertiesMap(themeDir, resType, false, null, null, "theme_info.ini");
    }

    private Map<String, Properties> getPropertiesMap(String themeDir, int resType, boolean land, String pSubfolder, String lSubfolder, String fileName) {
        String subfolder = null;
        String key = null;
        if (land) {
            subfolder = lSubfolder;
            key = String.valueOf(themeDir) + fileName + "land";
        } else {
            subfolder = pSubfolder;
            key = String.valueOf(themeDir) + fileName;
        }
        Map<String, Properties> propertiesMap = mAllPropertiesMap.get(key);
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            propertiesMap = this.mThemeFileParser.getAllProperties(themeDir, subfolder, fileName, this.mContext, resType);
            if (land && this.mThemeFileParser.isEmpty()) {
                subfolder = pSubfolder;
                propertiesMap = this.mThemeFileParser.getAllProperties(themeDir, subfolder, fileName, this.mContext, resType);
            }
            mAllPropertiesMap.put(key, propertiesMap);
        }
        return propertiesMap;
    }

    public KeyImageData crateImageInstance(String tag, boolean landscape, int width, int height) {
        this.mImageParser.setParserObject(1);
        String mCurrentThemeDir1 = null;
        mCurrentThemeDir1 = ManageUtils.flag ? String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() : String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultLayoutResFilePath();
        this.mImageParser.setThemeDir(mCurrentThemeDir1);
        ImageData imageData = this.mImageParser.getParserResult(tag);
        this.mImageName = imageData.getImageSrcName();
        if (this.mImageName != null) {
            return imageData.getImage(this.mContext, mCurrentThemeDir1, landscape, this.mCurrentResType, imageData.getImageSrcName(), width, height);
        }
        return null;
    }

    public String getDefaultResDir() {
        String defaultRes = "480/layout/";
        return defaultRes;
    }

    public String getDefaultPicDir() {
        String defaultRes = "480/res/";
        return defaultRes;
    }

    public String getImageSrcName() {
        return this.mImageName;
    }

    public void setContext(Object context) {
        this.mContext = context;
    }

    public String getImageNameByTag(String tag) {
        this.mImageParser.setParserObject(1);
        String mCurrentThemeDir1 = null;
        mCurrentThemeDir1 = ManageUtils.flag ? String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultThemeResFilePath() : String.valueOf(ManageUtils.getDefaultThemeFilePath(1)) + ManageUtils.getDefaultLayoutResFilePath();
        this.mImageParser.setThemeDir(mCurrentThemeDir1);
        ImageData imagedata = this.mImageParser.getParserResult(tag);
        this.mImageName = imagedata.getImageSrcName();
        return String.valueOf(mCurrentThemeDir1) + this.mImageName;
    }

    public ImageData getImageByTag(String tag) {
        this.mImageParser.setParserObject(1);
        ImageData imagedata = this.mImageParser.getParserResult(tag);
        return imagedata;
    }
}

