/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.model.layout.LayoutData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.ComposingParser;
import com.iflytek.skintool.parser.layout.KeyboardParser;
import com.iflytek.skintool.util.ThemeUtils;

public class LayoutParser
extends BaseParser {
    private LayoutData mLayoutData;
    private KeyboardParser mCandidatesParser;
    private KeyboardParser mKeyboardParser;
    private StyleParser mStyleParser;
    private DimensParser mDimensParser;
    private ComposingParser mComposingParser;

    public LayoutParser(Object context) {
        super(context);
        this.mFileName = "layout.ini";
        this.mCandidatesParser = new KeyboardParser(context);
        this.mCandidatesParser.setFileName("cand.ini");
        this.mKeyboardParser = new KeyboardParser(context);
        this.mKeyboardParser.setFileName("keyboard.ini");
        this.mStyleParser = new StyleParser(context);
        this.mDimensParser = new DimensParser(context);
        this.mComposingParser = new ComposingParser(context);
    }

    @Override
    public LayoutData getParserResult(String tag) {
        this.mLayoutData = new LayoutData();
        this.mLayoutData.setTag(tag);
        this.parserProperties(tag);
        this.loadLayout(this.mLayoutData);
        return this.mLayoutData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("NAME")) {
            this.mLayoutData.setName(value);
        } else if (key.equalsIgnoreCase("COMP")) {
            this.mLayoutData.setComposingStr(value);
        } else if (key.equalsIgnoreCase("CAND")) {
            this.mLayoutData.setCandidateStr(value);
        } else if (key.equalsIgnoreCase("KEYBOARD")) {
            this.mLayoutData.setKeyboardStr(value);
        } else if (key.equalsIgnoreCase("STYLE")) {
            this.mLayoutData.setStyleStr(value);
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.mLayoutData.setDimensStr(value);
        } else if (key.equalsIgnoreCase("LAYOUT")) {
            this.mLayoutData.setLayoutType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("HCR")) {
            this.mLayoutData.setHcrSupport(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("HCR_RECT")) {
            this.mLayoutData.setHcrRectString(ThemeUtils.splitString(value, ","));
        } else if (key.equalsIgnoreCase("MULTITOUCH")) {
            this.mLayoutData.setMultiTouchSupport(Integer.valueOf(value) == 1);
        } else if (key.equalsIgnoreCase("MODE")) {
            this.mLayoutData.setShowModeStr(value);
        } else if (key.equalsIgnoreCase("STYLE_TYPE")) {
            this.mLayoutData.setThemeType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("PREINPUT_TEXT_SUPPORT")) {
            this.mLayoutData.setPreInputText(value);
        } else {
            return false;
        }
        return true;
    }

    private void loadLayout(LayoutData layoutData) {
        if (!layoutData.isAllParser()) {
            String keyboardStr;
            String candStr;
            this.mStyleParser.setParserObject(this.layoutType);
            this.mLayoutData.setStyle(this.mStyleParser.getParserResult(layoutData.getStyleStr()));
            this.mDimensParser.setParserObject(this.layoutType);
            this.mLayoutData.setDimensData(this.mDimensParser.getParserResult(layoutData.getDimensStr()));
            String composingStr = layoutData.getComposingStr();
            if (composingStr != null) {
                this.mComposingParser.setParserObject(1);
                ComposingData tempData = this.mComposingParser.getParserResult(composingStr);
                layoutData.setComposing(tempData);
            }
            if ((candStr = layoutData.getCandidateStr()) != null) {
                this.mCandidatesParser.setParserObject(1);
                BaseData temp = this.mCandidatesParser.getParserResult(candStr);
                this.mLayoutData.setCandidates(temp);
            }
            if ((keyboardStr = layoutData.getKeyboardStr()) != null) {
                this.mKeyboardParser.setParserObject(this.layoutType);
                layoutData.setKeyboards(this.mKeyboardParser.getParserResult(keyboardStr));
            }
            layoutData.setAllParser(true);
        }
    }

    @Override
    public boolean parserProperty(String key, String value, boolean land, boolean mark) {
        if (key.equalsIgnoreCase("NAME")) {
            this.mLayoutData.setName(value);
        }
        return true;
    }

    public void setLayoutType(int i) {
        this.layoutType = i;
    }
}

