/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.parser.layout;

import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.layout.KeyboardData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.parser.common.BaseParser;
import com.iflytek.skintool.parser.common.DimensParser;
import com.iflytek.skintool.parser.common.StyleParser;
import com.iflytek.skintool.parser.layout.AreaParserImpl;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class KeyboardParser
extends BaseParser {
    private StyleParser mStyleParser;
    private DimensParser mDimensParser;
    private AreaParserImpl mAreaParser;
    private KeyboardData mKeyboardData;
    private String[] mModeKeyboardStrArray;

    public KeyboardParser(Object context) {
        super(context);
        this.mFileName = "keyboard.ini";
        this.mAreaParser = new AreaParserImpl(context);
    }

    public void setStyleParser(StyleParser styleParser) {
        this.mStyleParser = styleParser;
        this.mAreaParser.setStyleParser(styleParser);
    }

    public void setDimensParser(DimensParser dimensParser) {
        this.mDimensParser = dimensParser;
        this.mAreaParser.setDimensParser(dimensParser);
    }

    @Override
    public void clear() {
        super.clear();
        this.mStyleParser = null;
        this.mDimensParser = null;
    }

    @Override
    public BaseData getParserResult(String tag) {
        if (this.mStyleParser == null) {
            this.mStyleParser = new StyleParser(this.mContext);
            this.mStyleParser.setParserObject(this.layoutType);
            this.mAreaParser.setStyleParser(this.mStyleParser);
        }
        if (this.mDimensParser == null) {
            this.mDimensParser = new DimensParser(this.mContext);
            this.mDimensParser.setParserObject(this.layoutType);
            this.mAreaParser.setDimensParser(this.mDimensParser);
        }
        String keyboardTag = String.valueOf(this.mFileName) + this.mLandscape;
        HashMap<String, BaseData> keyboardDataPool = (HashMap<String, BaseData>)mAllDataPool.get(keyboardTag);
        keyboardDataPool = new HashMap<String, BaseData>();
        BaseData mModeKeyboardData = null;
        if (mModeKeyboardData == null) {
            this.mModeKeyboardStrArray = null;
            this.mKeyboardData = new KeyboardData();
            this.parserProperties(tag);
            if (this.mModeKeyboardStrArray != null && this.mModeKeyboardStrArray.length > 0) {
                mModeKeyboardData = new SelectorData();
                mModeKeyboardData.setTag(tag);
                ((SelectorData)mModeKeyboardData).setDimens(this.mKeyboardData.getDimensData());
                int i = 0;
                while (i < this.mModeKeyboardStrArray.length) {
                    this.mKeyboardData.setDimensData(new DimensData());
                    this.parserProperties(this.mModeKeyboardStrArray[i]);
                    this.mKeyboardData.setTag(this.mModeKeyboardStrArray[i]);
                    KeyboardData keyboardData = this.mKeyboardData.clone();
                    ((SelectorData)mModeKeyboardData).addData(keyboardData);
                    ++i;
                }
            } else {
                this.mKeyboardData.setTag(tag);
                mModeKeyboardData = this.mKeyboardData;
            }
            keyboardDataPool.put(tag, mModeKeyboardData);
            mAllDataPool.put(keyboardTag, keyboardDataPool);
        }
        return mModeKeyboardData;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape) {
        if (key.equalsIgnoreCase("SELECTOR")) {
            this.mModeKeyboardStrArray = ThemeUtils.splitString(value, ",");
        } else if (key.equalsIgnoreCase("STYLE")) {
            this.mKeyboardData.setStyle(this.mStyleParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("DIMENS")) {
            this.mKeyboardData.setDimensData(this.mDimensParser.getParserResult(value));
        } else if (key.equalsIgnoreCase("LAYOUT")) {
            this.mKeyboardData.setLayoutType(Integer.valueOf(value));
        } else if (key.equalsIgnoreCase("TYPE")) {
            this.mKeyboardData.setKeyBoardType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("STYLE_TYPE")) {
            this.mKeyboardData.setThemeType(ThemeUtils.getInt(value));
        } else if (key.equalsIgnoreCase("AREA_SET")) {
            this.mAreaParser.setParserObject(this.layoutType);
            String[] keyStrArray = ThemeUtils.splitString(value, ",");
            ArrayList<BaseData> areaArray = new ArrayList<BaseData>();
            int i = 0;
            while (i < keyStrArray.length) {
                BaseData baseData = this.mAreaParser.getParserResult(keyStrArray[i]);
                if (baseData != null) {
                    areaArray.add(baseData);
                }
                ++i;
            }
            this.mKeyboardData.setAreaSet(areaArray);
        } else if (key.equalsIgnoreCase("MODE")) {
            this.mKeyboardData.setShowModeStr(value);
        }
        return true;
    }

    @Override
    protected boolean parserProperty(String key, String value, boolean landscape, boolean mark) {
        return false;
    }
}

