/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.model.theme;

import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.model.theme.ThemeAreaData;
import com.iflytek.skintool.model.theme.ThemeBalloonData;
import com.iflytek.skintool.model.theme.ThemeKeyData;
import com.iflytek.skintool.model.theme.ThemeKeyboardData;
import com.iflytek.skintool.model.theme.ThemeLayoutData;
import com.iflytek.skintool.util.ThemeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubjectData {
    private List<StyleData> mStyleDataMap;
    private Map<Integer, ThemeKeyData> mThemeKeyDataMap;
    private Map<Integer, ThemeAreaData> mThemeAreaDataMap;
    private Map<Integer, ThemeLayoutData> mThemeLayoutDataMap;
    private Map<Integer, ThemeKeyboardData> mThemeKeyBoardMap;
    private ComposingData mComposingData;
    private ThemeBalloonData mBalloonData;
    private int mThemeColor = 0;
    private int mThemePressColor = 0;

    public void setThemeColor(int color) {
        this.mThemeColor = color;
    }

    public int getThemeColor(int state) {
        if (state == 1) {
            return this.mThemeColor;
        }
        return this.mThemePressColor == 0 ? this.mThemeColor : this.mThemePressColor;
    }

    public ThemeBalloonData getBalloonData() {
        return this.mBalloonData;
    }

    public void setBalloonData(ThemeBalloonData mBalloonData) {
        this.mBalloonData = mBalloonData;
    }

    public ComposingData getComposingData() {
        return this.mComposingData;
    }

    public void setComposingData(ComposingData data) {
        this.mComposingData = data;
    }

    public ThemeKeyboardData getKeyBoard(int key) {
        if (this.mThemeKeyBoardMap == null) {
            return null;
        }
        ThemeKeyboardData data = this.mThemeKeyBoardMap.get(key);
        if (data == null) {
            data = this.mThemeKeyBoardMap.get(key);
        }
        return data;
    }

    public void addKeyBoard(int key, ThemeKeyboardData keyboard) {
        if (this.mThemeKeyBoardMap == null) {
            this.mThemeKeyBoardMap = new HashMap<Integer, ThemeKeyboardData>();
        }
        this.mThemeKeyBoardMap.put(key, keyboard);
    }

    public Map<Integer, ThemeAreaData> geAreaList() {
        return this.mThemeAreaDataMap;
    }

    public void addStyleData(int key, StyleData style) {
        if (this.mStyleDataMap == null) {
            this.mStyleDataMap = new ArrayList<StyleData>();
        }
        this.mStyleDataMap.add(key, style);
    }

    public StyleData getStyleData(int key) {
        if (this.mStyleDataMap == null) {
            return null;
        }
        StyleData style = this.mStyleDataMap.get(key);
        if (style == null) {
            style = this.mStyleDataMap.get(key & 0xF0000000);
        }
        return style;
    }

    public void addThemeKeyData(int key, ThemeKeyData keyData) {
        if (this.mThemeKeyDataMap == null) {
            this.mThemeKeyDataMap = new HashMap<Integer, ThemeKeyData>();
        }
        this.mThemeKeyDataMap.put(key, keyData);
    }

    public ThemeKeyData getThemeKeyData(int key) {
        if (this.mThemeKeyDataMap == null) {
            return null;
        }
        ThemeKeyData data = this.mThemeKeyDataMap.get(key);
        return data;
    }

    public void addThemeLayoutData(int key, ThemeLayoutData layoutData) {
        if (this.mThemeLayoutDataMap == null) {
            this.mThemeLayoutDataMap = new HashMap<Integer, ThemeLayoutData>();
        }
        if (key == 0) {
            layoutData.setTypeAttr(ThemeUtils.splitInt("0", ","));
        }
        this.mThemeLayoutDataMap.put(key, layoutData);
    }

    public ThemeLayoutData getThemeLayoutData(int key) {
        if (this.mThemeLayoutDataMap == null) {
            return null;
        }
        ThemeLayoutData data = this.mThemeLayoutDataMap.get(key);
        if (data == null) {
            data = this.mThemeLayoutDataMap.get(0);
        }
        return data;
    }

    public void addThemeAreaData(int key, ThemeAreaData AreaData2) {
        if (this.mThemeAreaDataMap == null) {
            this.mThemeAreaDataMap = new HashMap<Integer, ThemeAreaData>();
        }
        this.mThemeAreaDataMap.put(key, AreaData2);
    }

    public ThemeAreaData getAreaLayoutData(int key) {
        if (this.mThemeAreaDataMap == null) {
            return null;
        }
        ThemeAreaData data = this.mThemeAreaDataMap.get(key);
        return data;
    }

    public void setComposingData(int i) {
    }

    public void setThemePressColor(int themePressColor) {
        this.mThemePressColor = themePressColor;
    }
}

