/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.graphical.high;

import com.iflytek.skintool.graphical.high.IMEAreaPanel;
import com.iflytek.skintool.graphical.high.IMEKeyboardPanel;
import com.iflytek.skintool.graphical.low.IMEButton;
import com.iflytek.skintool.graphical.low.IMEPanel;
import com.iflytek.skintool.model.common.DimensData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.AreaData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.KeyboardData;
import com.iflytek.skintool.model.layout.LayoutData;
import com.iflytek.skintool.model.pool.ExpressionImagePool;
import com.iflytek.skintool.model.pool.ThemeDataPool;
import com.iflytek.skintool.model.theme.ThemeLayoutData;
import com.iflytek.skintool.util.ManageUtils;
import com.iflytek.skintool.util.ThemeUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class IMELayoutPanel
extends IMEPanel {
    private LayoutData layoutData;
    private int id;

    public void setLayoutData(LayoutData data) {
        this.layoutData = data;
    }

    public void loadLayoutPanel() {
        this.setSize((int)this.layoutData.getDimensData().getWidth(), (int)this.layoutData.getDimensData().getHeight());
        this.setLocation((int)this.layoutData.getDimensData().getX(), (int)this.layoutData.getDimensData().getY());
        this.setStyle();
        this.mSonPanleLength = this.layoutData.getChilds().size();
        this.mSonPanel = new IMEKeyboardPanel[this.mSonPanleLength];
        this.setLayout(null);
        int i = 0;
        while (i < this.mSonPanleLength) {
            this.mSonPanel[i] = new IMEKeyboardPanel();
            ((IMEKeyboardPanel)this.mSonPanel[i]).setKeyboardData((KeyboardData)this.layoutData.getChilds().get(i));
            ((IMEKeyboardPanel)this.mSonPanel[i]).loadKeyboardPanel();
            this.add((IMEKeyboardPanel)this.mSonPanel[i]);
            ++i;
        }
    }

    private void setStyle() {
        ThemeLayoutData themeLayoutData = ThemeDataPool.msubjectset.getThemeLayoutData(this.layoutData.getThemeType());
        if (themeLayoutData != null) {
            StyleData styleData = themeLayoutData.getStyle();
            if (styleData.getImageData() != null) {
                ManageUtils.flag = true;
                styleData.loadImage(false, this.getWidth(), this.getHeight());
                ManageUtils.flag = false;
                this.setBackgroundIcon(styleData.getImage());
            } else {
                this.setBackgroudColor(new Color(styleData.getBgColor()));
            }
        } else {
            StyleData layoutStyleData = this.layoutData.getStyle();
            if (layoutStyleData != null) {
                if (layoutStyleData.getImageData() != null) {
                    layoutStyleData.loadImage(false, this.getWidth(), this.getHeight());
                    this.setBackgroundIcon(layoutStyleData.getImage());
                } else {
                    this.setBackgroudColor(new Color(layoutStyleData.getBgColor()));
                }
            }
        }
    }

    public void fillSpeechTitle() {
        this.getSonPanel()[0].getSonPanel()[0].getSonPanel()[0].getSonButton()[0].setText("\u8bf7\u8bf4\u51fa\u5185\u5bb9");
        this.getSonPanel()[0].getSonPanel()[0].getSonPanel()[0].getSonButton()[0].setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, this.getSonPanel()[0].getSonPanel()[0].getSonPanel()[0].getSonButton()[0].getFont().getSize()));
    }

    public void fillExpressionPanel() {
        this.fillExpressionCand();
        this.fillExpressionContent();
    }

    private void fillExpressionContent() {
        IMEAreaPanel panel = (IMEAreaPanel)this.getSonPanel()[1].getSonPanel()[0];
        AreaData data = panel.getAreaData();
        DimensData dimensData = data.getDimensData();
        int cellWidth = (panel.getWidth() - panel.getPadding().mX1 - panel.getPadding().mX2) / dimensData.getRowCount();
        int cellHeight = (panel.getHeight() - panel.getPadding().mY1 - panel.getPadding().mY2) / dimensData.getColumnCount();
        KeyData keyData = data.getKeyAttribute();
        DimensData keyDimens = keyData.getDimensData();
        keyDimens.measurePadding(panel.getWidth(), panel.getHeight());
        StyleData styleBackData = keyData.getBackStateSet().get(1);
        if (styleBackData != null && styleBackData.getImageTag() != null) {
            styleBackData.loadImage(false, cellWidth, cellHeight);
        }
        StyleData themeForeStyleData = null;
        if (keyData.getThemeType() > 0) {
            try {
                themeForeStyleData = ThemeDataPool.msubjectset.getThemeKeyData(keyData.getThemeType()).getForegroundStyle(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        panel.initializeSonButtons(dimensData.getColumnCount() * dimensData.getRowCount());
        ExpressionImagePool imagePool = ExpressionImagePool.getInstance();
        int i = 0;
        while (i < dimensData.getColumnCount()) {
            int j = 0;
            while (j < dimensData.getRowCount()) {
                panel.getSonButton()[j + i * dimensData.getRowCount()] = new IMEButton();
                panel.add(panel.getSonButton()[j + i * dimensData.getRowCount()]);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setSize(cellWidth, cellHeight);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setKeyData(keyData);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setLocation(j * cellWidth + panel.getPadding().getmX1(), i * cellHeight + panel.getPadding().getmY1());
                ImageIcon tempIcon = imagePool.getImageIcon(j + i * dimensData.getRowCount());
                Image tempImage = tempIcon.getImage();
                tempImage = tempImage.getScaledInstance(50, 50, 1);
                tempIcon = new ImageIcon(tempImage);
                if (styleBackData != null && styleBackData.getImage() != null) {
                    panel.getSonButton()[j + i * dimensData.getRowCount()].setIcon(styleBackData.getImage());
                }
                JLabel tempLabel = new JLabel();
                tempLabel.setIcon(tempIcon);
                panel.getSonButton()[j + i * dimensData.getRowCount()].setLayout(null);
                tempLabel.setSize(tempIcon.getIconWidth(), tempIcon.getIconHeight());
                tempLabel.setLocation((cellWidth - tempIcon.getIconWidth()) / 2, (cellHeight - tempIcon.getIconHeight()) / 2);
                panel.getSonButton()[j + i * dimensData.getRowCount()].add(tempLabel);
                ++j;
            }
            ++i;
        }
    }

    private void fillExpressionCand() {
        ExpressionImagePool eiPool = ExpressionImagePool.getInstance();
        JLabel expLabel = new JLabel();
        DimensData dimens = ((IMEAreaPanel)this.mSonPanel[0].getSonPanel()[0]).getAreaData().getKeyAttribute().getDimensData();
        int x1 = (int)ThemeUtils.getDimension(dimens.getMarginString()[0], this.getWidth());
        int y1 = (int)ThemeUtils.getDimension(dimens.getMarginString()[1], this.getHeight());
        int x2 = (int)ThemeUtils.getDimension(dimens.getMarginString()[2], this.getWidth());
        int y2 = (int)ThemeUtils.getDimension(dimens.getMarginString()[3], this.getHeight());
        int height = ((IMEAreaPanel)this.mSonPanel[0].getSonPanel()[0]).getHeight() - y1 - y2;
        int width = ((IMEAreaPanel)this.mSonPanel[0].getSonPanel()[0]).getWidth() / 5 - x1 - x2;
        if (width > height) {
            width = height;
        } else {
            height = width;
        }
        expLabel.setIcon(new ImageIcon(eiPool.getImageIcon(3).getImage().getScaledInstance(width, height, 1)));
        expLabel.setSize(width, height);
        expLabel.setLocation(x1, y1);
        this.mSonPanel[0].getSonPanel()[0].add(expLabel);
        this.mSonPanel[0].getSonPanel()[0].setLayout(null);
    }

    public void setAlpha(int alpha) {
        int i = 0;
        while (i < this.mSonPanleLength) {
            ((IMEKeyboardPanel)this.mSonPanel[i]).setAlpha(alpha);
            ++i;
        }
    }

    public void changeKeyForeColor(Color color) {
        int i = 0;
        while (i < this.mSonPanleLength) {
            ((IMEKeyboardPanel)this.mSonPanel[i]).changeKeyForeColor(color);
            ++i;
        }
    }

    public void reload() {
        this.mSonPanel = null;
        this.removeAll();
        this.loadLayoutPanel();
        if (this.id % 19 == 12) {
            this.fillSpeechTitle();
        } else if (this.id % 19 == 18) {
            this.fillExpressionPanel();
        }
        this.setLocation(0, 60);
    }

    public void setID(Integer tag) {
        this.id = tag;
    }
}

