/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.controler;

import com.iflytek.skintool.front.controler.KeyboardViewLogic;
import com.iflytek.skintool.front.view.SkinInfoEditView;
import com.iflytek.skintool.model.pool.LayoutDataPool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.UUID;

public class SkinInfoEditLogic {
    private SkinInfoEditView skinInfoEditView = new SkinInfoEditView();
    private KeyboardViewLogic keyboardViewLogic;

    public SkinInfoEditView getSkinInfoEditView() {
        return this.skinInfoEditView;
    }

    public SkinInfoEditLogic(KeyboardViewLogic logic) {
        this.keyboardViewLogic = logic;
        this.initLisenters();
    }

    public void initLisenters() {
        this.skinInfoEditView.getSkinNameField().addKeyListener(this.skinNameEditListener());
        this.skinInfoEditView.getSkinAuthorField().addKeyListener(this.skinAuthorEditListener());
        this.skinInfoEditView.getSkinVersionField().addKeyListener(this.skinVersionEditListener());
        this.skinInfoEditView.getSkinDescriptionArea().addKeyListener(this.skinDescriptionEditListener());
        this.skinInfoEditView.getRandomSkinIDButton().addActionListener(this.randomIDListener());
    }

    private ActionListener randomIDListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = UUID.randomUUID().toString();
                SkinInfoEditLogic.this.skinInfoEditView.getSkinIDField().setText(id);
                LayoutDataPool.getThemeInfo().setID(id);
            }
        };
    }

    private KeyListener skinNameEditListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LayoutDataPool.getThemeInfo().setName(SkinInfoEditLogic.this.skinInfoEditView.getSkinNameField().getText());
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
    }

    private KeyListener skinAuthorEditListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LayoutDataPool.getThemeInfo().setAuthor(SkinInfoEditLogic.this.skinInfoEditView.getSkinAuthorField().getText());
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
    }

    private KeyListener skinVersionEditListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    LayoutDataPool.getThemeInfo().setVersion(Float.parseFloat(SkinInfoEditLogic.this.skinInfoEditView.getSkinVersionField().getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
    }

    private KeyListener skinDescriptionEditListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LayoutDataPool.getThemeInfo().setDescription(SkinInfoEditLogic.this.skinInfoEditView.getSkinDescriptionArea().getText());
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
    }

    public void unableSkinInfoEditor() {
        this.skinInfoEditView.setEditorEnable(false);
    }

    public void enableSkinInfoEditor() {
        this.skinInfoEditView.setEditorEnable(true);
    }
}

