/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.front.controler;

import com.iflytek.skintool.front.controler.ChooseTemplateLogic;
import com.iflytek.skintool.front.controler.MainViewLogic;
import com.iflytek.skintool.front.view.InitialView;
import com.iflytek.skintool.util.ItFilter;
import com.iflytek.skintool.util.ThemeUtils;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class InitialViewLogic {
    private InitialView initialView = new InitialView();

    public InitialViewLogic() {
        this.initialView.getCreateButton().addActionListener(this.createActionListener());
        this.initialView.getImportButton().addActionListener(this.importActionListener());
        this.initialView.getTutorButton().addActionListener(this.tutorActionListener());
        this.initialView.getExitButton().addActionListener(this.exitActionListener());
        this.initialView.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        InitialViewLogic ivLogic = new InitialViewLogic();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        ivLogic.showView();
    }

    public void showView() {
        this.initialView.setVisible(true);
    }

    public void hideView() {
        this.initialView.setVisible(false);
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseTemplateLogic ctLogic = new ChooseTemplateLogic();
                ctLogic.showView();
                InitialViewLogic.this.hideView();
            }
        };
    }

    private ActionListener importActionListener() {
        final InitialViewLogic logic = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser itFileChooser = new JFileChooser();
                itFileChooser.setDialogTitle("\u8bf7\u9009\u62e9\u76ae\u80a4\u6587\u4ef6");
                itFileChooser.setFileFilter(new ItFilter());
                int chooserResult = itFileChooser.showOpenDialog(InitialViewLogic.this.initialView);
                File selectedFile = null;
                if (chooserResult == 0) {
                    selectedFile = itFileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        ThemeUtils.unZip(selectedFile.getPath(), String.valueOf(System.getProperty("user.dir")) + "\\bin\\" + selectedFile.getName() + "\\");
                        File rootFile = new File(String.valueOf(System.getProperty("user.dir")) + "\\bin\\" + selectedFile.getName() + "\\");
                        File sonFile = rootFile.listFiles()[0];
                        MainViewLogic mv = new MainViewLogic(9, String.valueOf(rootFile.getName()) + "\\" + sonFile.getName(), logic);
                        mv.showView();
                        InitialViewLogic.this.hideView();
                    }
                } else if (chooserResult == 1 || chooserResult == -1) {
                    // empty if block
                }
            }
        };
    }

    private ActionListener tutorActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InitialViewLogic.this.openWebage("http://bbs.voicecloud.cn/showtopic-140067-1-1.html");
            }
        };
    }

    private ActionListener exitActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
    }

    private void openWebage(String urlString) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URL(urlString).toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

