/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.utils;

import com.iflytek.skintool.util.SkinUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;

public class SerializerUtil {
    public static <E> String array2str(Collection<E> values, String mergeStr) {
        if (values == null || values.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (E value : values) {
            if (value.equals(mergeStr)) {
                sb.append("\\");
            }
            sb.append(value);
            sb.append(mergeStr);
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String array2str(float[] value, String mergeStr) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            sb.append(value[i]);
            sb.append(mergeStr);
            ++i;
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String array2str(int[] value, String mergeStr) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            sb.append(value[i]);
            sb.append(mergeStr);
            ++i;
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String array2str(ImageIcon[] animationDrawables) {
        if (animationDrawables == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < animationDrawables.length) {
            sb.append(animationDrawables[i]);
            sb.append(",");
            ++i;
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String toIniString(TreeMap<String, TreeMap<String, String>> props) {
        if (props == null || props.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, TreeMap<String, String>> entrySets : props.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    public static String getColorStr(int color) {
        StringBuffer sb = new StringBuffer();
        sb.append("0x");
        sb.append(Integer.toHexString(color));
        return sb.toString();
    }

    public static String getGravityStr(int value) {
        if (value == 0) {
            return "";
        }
        ArrayList<String> strs = new ArrayList<String>();
        int mask = 1;
        if ((value & 0x110000) != 0) {
            strs.add("center");
        }
        int i = 0;
        while (i < 4) {
            int v = value & mask << i * 4;
            if (v != 0) {
                switch (i) {
                    case 0: {
                        strs.add("left");
                        break;
                    }
                    case 1: {
                        strs.add("top");
                        break;
                    }
                    case 2: {
                        strs.add("right");
                        break;
                    }
                    case 3: {
                        strs.add("bottom");
                    }
                }
            }
            ++i;
        }
        return SerializerUtil.array2str(strs, "|");
    }

    public static int getKeyType(int type) {
        int respTypeMask = 65280;
        int funcTypeMask = 255;
        if ((type & (0x101 & ~funcTypeMask)) == 256) {
            return 0;
        }
        if ((type & (0x101 & ~respTypeMask)) == 1) {
            return 1;
        }
        return 2;
    }

    public static String getCodeStr(int code) {
        if (code >= 0) {
            return Integer.toString(code);
        }
        if (code > -1000) {
            return "M" + Integer.toString(-code);
        }
        return "F" + Integer.toString(-code - 1000);
    }

    public static String getKeyOperationStr(int value) {
        int reslut = 0;
        while (value != 1) {
            ++reslut;
            value >>= 1;
        }
        return Integer.toString(reslut);
    }

    public static String getKeyGravityStr(int value) {
        StringBuffer sb = new StringBuffer();
        int center = 0x110000;
        if ((value & center) == center) {
            sb.append("center");
            sb.append("|");
        }
        if (((value &= ~center) & 1) == 1) {
            sb.append("left");
            sb.append("|");
        } else if ((value & 0x10) == 16) {
            sb.append("top");
            sb.append("|");
        } else if ((value & 0x100) == 256) {
            sb.append("right");
            sb.append("|");
        } else if ((value & 0x1000) == 4096) {
            sb.append("bottom");
            sb.append("|");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }
}

