/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.theme;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.ComposingData;
import com.iflytek.skintool.util.SkinUtils;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ThemeComposingDataSerializer
extends AbstractBaseSerializer<ComposingData> {
    int[] COMPOSING_STATES = new int[]{1, 2, 3};
    String[] COMPOSING_STATES_STRS = new String[]{"VALID", "FIXED", "INVALID"};
    private TreeMap<String, TreeMap<String, String>> mStateProps = new TreeMap();

    @Override
    public TreeMap<String, String> writeto(ComposingData composingData) {
        int cur = this.mProps.size();
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (composingData.getTypeAttr() != null) {
            attr.put("TYPE", SerializerUtil.array2str(composingData.getTypeAttr(), ","));
        }
        if (composingData.getBackgroundStyle() != null) {
            attr.put("STYLE", this.mListener.redirect(9, composingData.getBackgroundStyle().getTag(), composingData.getBackgroundStyle()));
        }
        TreeMap<String, String> forState = new TreeMap<String, String>();
        int i = 0;
        while (i < this.COMPOSING_STATES_STRS.length) {
            StyleData styleData = composingData.getForegroundStyle(this.COMPOSING_STATES[i]);
            if (styleData != null) {
                forState.put(this.COMPOSING_STATES_STRS[i], this.mListener.redirect(9, styleData.getTag(), styleData));
            }
            ++i;
        }
        if (forState.size() > 0) {
            this.mStateProps.put("For_State_Composing_" + cur, forState);
            attr.put("FORE_STATE", "For_State_Composing_" + cur);
        }
        return attr;
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        for (Map.Entry<String, TreeMap<String, String>> entrySets : this.mStateProps.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isExist(ComposingData data) {
        if (this.mProps.size() != 0) {
            String typeStr = SerializerUtil.array2str(data.getTypeAttr(), ",");
            if (typeStr == null) {
                return false;
            }
            Collection values = this.mProps.values();
            for (TreeMap treeMap : values) {
                if (!((String)treeMap.get("TYPE")).equals(typeStr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTag(ComposingData data) {
        if (data.getTag() != null) {
            return data.getTag();
        }
        return "Composing_" + this.mProps.size();
    }
}

