/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.layout;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.domin.KeyOperation;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.SubKeyData;
import com.iflytek.skintool.util.SkinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class SubKeyDataSerializer
extends AbstractBaseSerializer<SubKeyData> {
    private static final int[] KEY_OPERATION = new int[]{KeyOperation.count(), 1, 2, 32, 4, 16, 8};
    int[] KEY_STATES = new int[]{16, 4, 1, 2, 8};
    String[] KEY_STATES_STRS = new String[]{"DISABLED", "FOCUSED", "NORMAL", "PRESSED", "SELECTED"};
    private TreeMap<String, TreeMap<String, String>> mStateProps = new TreeMap();

    @Override
    public TreeMap<String, String> writeto(SubKeyData object) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        if (object.getDimens() != null) {
            attr.put("DIMENS", this.mListener.redirect(8, "Dimens_" + object.getTag(), object.getDimens()));
        }
        TreeMap<String, String> foreState = new TreeMap<String, String>();
        if (object.getForegroundStyle() != null) {
            int i = 0;
            while (i < this.KEY_STATES.length) {
                StyleData styleData = null;
                styleData = i == 0 ? object.getForegroundStyle(16) : (i == 1 ? object.getForegroundStyle(4) : (i == 2 ? object.getForegroundStyle(1) : (i == 3 ? object.getForegroundStyle(2) : object.getForegroundStyle(8))));
                if (styleData != null) {
                    foreState.put(this.KEY_STATES_STRS[i], this.mListener.redirect(9, "Style_" + object.getTag() + "_" + this.KEY_STATES_STRS[i], styleData));
                }
                ++i;
            }
            attr.put("FORE_STATE", "FORE_STATE_" + object.getTag());
            this.mStateProps.put("FORE_STATE_" + object.getTag(), foreState);
        }
        attr.put("GRAVITY", SerializerUtil.getGravityStr(object.getGravity()));
        if (object.getText() != null) {
            attr.put("TEXT", object.getText());
        }
        attr.put("VISIBILITY", Boolean.toString(object.isVisibility()));
        ArrayList<String> keyOperations = new ArrayList<String>();
        int i = 0;
        while (i < KEY_OPERATION.length) {
            if (object.isSupportOperation(KEY_OPERATION[i])) {
                keyOperations.add(SerializerUtil.getKeyOperationStr(KEY_OPERATION[i]));
            }
            ++i;
        }
        attr.put("SUPPORT_OPERATION", SerializerUtil.array2str(keyOperations, ","));
        if (object.getSequence() != null) {
            attr.put("SEQUENCE", object.getSequence());
        }
        if (object.getInput() != null) {
            attr.put("INPUT", SerializerUtil.array2str(Arrays.asList(object.getInput()), ","));
        }
        if (object.getPromptContent() != null) {
            if (object.getPromptContent().getPopTag() != null) {
                attr.put("BALLOON", object.getPromptContent().getPopTag());
            }
            if (object.getPromptContent().getPopTexts() != null) {
                attr.put("POP_TEXT", SerializerUtil.array2str(Arrays.asList(object.getPromptContent().getPopTexts()), ","));
            }
            attr.put("POP_SHOW", String.valueOf(object.getPromptContent().getPopHlIndex()));
            if (object.getPromptContent().getPopDrawableStr() != null) {
                attr.put("POP_IMAGE", SerializerUtil.array2str(Arrays.asList(object.getPromptContent().getPopDrawableStr()), ","));
                String[] drawableStrs = object.getPromptContent().getPopDrawableStr();
                if (drawableStrs != null) {
                    String str = new String();
                    String[] stringArray = drawableStrs;
                    int n = drawableStrs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        str = String.valueOf(string) + ",";
                        ++n2;
                    }
                    attr.put("POP_IMAGE", str);
                }
            }
            attr.put("SUPPORT_POP", Boolean.toString(object.getPromptContent().isSupportPop()));
            attr.put("SUPPORT_SOUND", Boolean.toString(object.getPromptContent().isSupportSound()));
            attr.put("SUPPORT_VIBRATE", Boolean.toString(object.getPromptContent().isSupportVibrate()));
        }
        attr.put("CODE", SerializerUtil.getCodeStr(object.getCode()));
        attr.put("TARGET", String.valueOf(object.getTarget()));
        if (object.getTargetModeStr() != null) {
            attr.put("TARGET", String.valueOf(object.getTarget()));
        }
        return attr;
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        for (Map.Entry<String, TreeMap<String, String>> entrySets : this.mStateProps.entrySet()) {
            SkinUtils.stringMerge(sb, entrySets.getKey());
            for (Map.Entry<String, String> entry : entrySets.getValue().entrySet()) {
                SkinUtils.stringMerge(sb, entry.getKey(), entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public String getTag(SubKeyData data) {
        return data.getTag();
    }
}

