/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.layout;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.layout.LayoutData;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.TreeMap;

public class LayoutDataSerializer
extends AbstractBaseSerializer<LayoutData> {
    @Override
    public TreeMap<String, String> writeto(LayoutData layoutData) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        attr.put("NAME", layoutData.getName());
        if (layoutData.getComposingStr() != null) {
            attr.put("COMP", this.mListener.redirect(10, layoutData.getComposingStr(), layoutData.getComposingData()));
        }
        attr.put("CAND", this.mListener.redirect(3, layoutData.getCandidateStr(), layoutData.getCandidates()));
        attr.put("KEYBOARD", this.mListener.redirect(2, layoutData.getKeyboardStr(), layoutData.getKeyboards()));
        if (layoutData.getStyle() != null) {
            attr.put("STYLE", this.mListener.redirect(9, "Style_" + layoutData.getTag(), layoutData.getStyle()));
        }
        attr.put("DIMENS", this.mListener.redirect(8, "Style_" + layoutData.getTag(), layoutData.getDimensData()));
        attr.put("LAYOUT", String.valueOf(layoutData.getLayoutType().ordinal()));
        if (layoutData.getHcrSupport().ordinal() != 0) {
            attr.put("HCR", String.valueOf(layoutData.getHcrSupport().ordinal()));
        }
        if (this.getReflectField(layoutData, "mHcrRectStrings") != null) {
            String[] hcrRectStrings = (String[])this.getReflectField(layoutData, "mHcrRectStrings");
            attr.put("HCR_RECT", SerializerUtil.array2str(Arrays.asList(hcrRectStrings), ","));
        }
        if (layoutData.getBaseLineHeight() != 0.0f) {
            attr.put("BASELINE_HEIGHT", String.valueOf(layoutData.getBaseLineHeight()));
        }
        attr.put("MULTITOUCH", layoutData.isMultiTouchSupport() ? "1" : "0");
        attr.put("MODE", layoutData.getShowModeStr());
        attr.put("STYLE_TYPE", Integer.toString(layoutData.getThemeType()));
        if (layoutData.getPreInputText() != null) {
            attr.put("PREINPUT_TEXT_SUPPORT", layoutData.getPreInputText());
        }
        return attr;
    }

    private Object getReflectField(LayoutData object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getTag(LayoutData data) {
        return data.getTag();
    }
}

