/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.layout;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.interfaces.ISerializerListener;
import com.iflytek.serializer.layout.SubKeyDataSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.BaseData;
import com.iflytek.skintool.model.common.StyleData;
import com.iflytek.skintool.model.layout.KeyData;
import com.iflytek.skintool.model.layout.SelectorData;
import com.iflytek.skintool.model.layout.SubKeyData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class KeyDataSerializer
extends AbstractBaseSerializer<BaseData> {
    int[] KEY_STATES = new int[]{16, 4, 1, 2, 8};
    String[] KEY_STATES_STRS = new String[]{"DISABLED", "FOCUSED", "NORMAL", "PRESSED", "SELECTED"};
    SubKeyDataSerializer mSubKeyDataSerializer = new SubKeyDataSerializer();

    @Override
    public void setListener(ISerializerListener listener) {
        super.setListener(listener);
        this.mSubKeyDataSerializer.setListener(listener);
    }

    @Override
    public TreeMap<String, String> writeto(BaseData object) {
        String tag = object.getTag();
        if (object instanceof SelectorData) {
            ArrayList<String> selectorStr = new ArrayList<String>();
            for (BaseData baseData : ((SelectorData)object).getDataSet()) {
                selectorStr.add(this.serializeData(6, baseData.getTag(), baseData));
            }
            TreeMap<String, String> attr = new TreeMap<String, String>();
            if (selectorStr.size() > 0) {
                attr.put("SELECTOR", SerializerUtil.array2str(selectorStr, ","));
            }
            if (object.getDimensData() != null) {
                attr.put("DIMENS", this.mListener.redirect(8, "Dimens_" + tag, object.getDimensData()));
            }
            return attr;
        }
        if (object instanceof KeyData) {
            String str;
            StyleData styleData;
            int i;
            TreeMap<String, String> attr = new TreeMap<String, String>();
            if (object.getDimensData() != null) {
                attr.put("DIMENS", this.mListener.redirect(8, "Dimens_" + tag, object.getDimensData()));
            }
            if (((KeyData)object).getBackStateSet() != null) {
                attr.put("BACK_STATE", "BACK_STATE_" + tag);
                TreeMap<String, String> backStates = new TreeMap<String, String>();
                if (this.getReflectField((KeyData)object, "mBackStateSet") != null) {
                    HashMap backgroundStyles = (HashMap)this.getReflectField((KeyData)object, "mBackStateSet");
                    i = 0;
                    while (i < this.KEY_STATES.length) {
                        styleData = (StyleData)backgroundStyles.get(this.KEY_STATES[i]);
                        if (styleData != null) {
                            str = this.KEY_STATES_STRS[i];
                            backStates.put(str, this.mListener.redirect(9, "Style_Back_State_" + tag + "_" + str, styleData));
                        }
                        ++i;
                    }
                    this.mProps.put("BACK_STATE_" + tag, backStates);
                    attr.put("BACK_STATE", "BACK_STATE_" + tag);
                }
            }
            if (((KeyData)object).getForeStateSet() != null) {
                attr.put("FORE_STATE", "FORE_STATE_" + tag);
                TreeMap<String, String> foreStates = new TreeMap<String, String>();
                if (this.getReflectField((KeyData)object, "mForeStateSet") != null) {
                    HashMap foregroundStyles = (HashMap)this.getReflectField((KeyData)object, "mForeStateSet");
                    i = 0;
                    while (i < this.KEY_STATES.length) {
                        styleData = (StyleData)foregroundStyles.get(this.KEY_STATES[i]);
                        if (styleData != null) {
                            str = this.KEY_STATES_STRS[i];
                            foreStates.put(str, this.mListener.redirect(9, "Style_Fore_State_" + tag + "_" + str, styleData));
                        }
                        ++i;
                    }
                    this.mProps.put("FORE_STATE_" + tag, foreStates);
                    attr.put("FORE_STATE", "FORE_STATE_" + tag);
                }
            }
            if (((KeyData)object).getShowModeStr() != null) {
                attr.put("MODE", ((KeyData)object).getShowModeStr());
            }
            if (((KeyData)object).getForeStyle().getImageTag() != null) {
                attr.put("IMAGE", this.mListener.redirect(12, ((KeyData)object).getForeStyle().getImageTag(), ((KeyData)object).getForeStyle().getImage()));
            }
            if (((KeyData)object).getText() != null) {
                attr.put("TEXT", ((KeyData)object).getText());
            }
            if (((KeyData)object).getSubKeys() != null) {
                ArrayList<String> subKeyDataStr = new ArrayList<String>();
                List<SubKeyData> subKeyDatas = ((KeyData)object).getSubKeys();
                i = 1;
                for (SubKeyData subKeyData : subKeyDatas) {
                    subKeyDataStr.add(this.mSubKeyDataSerializer.serializeData(19, String.valueOf(tag) + "_" + i, subKeyData));
                    ++i;
                }
                attr.put("SUB_KEY", SerializerUtil.array2str(subKeyDataStr, ","));
            } else {
                if (((KeyData)object).getCellKeyData().getSequence() != null) {
                    attr.put("SEQUENCE", ((KeyData)object).getCellKeyData().getSequence());
                }
                if (((KeyData)object).getCellKeyData().getInput() != null && ((KeyData)object).getCellKeyData().getInput().length > 0) {
                    attr.put("INPUT", ((KeyData)object).getCellKeyData().getInput()[0]);
                }
                if (((KeyData)object).getCellKeyData().getCodeString() != null) {
                    attr.put("CODE", ((KeyData)object).getCellKeyData().getCodeString());
                }
                if (((KeyData)object).getBaloonStr() != null) {
                    attr.put("BALLOON", ((KeyData)object).getBaloonStr());
                }
            }
            attr.put("STYLE_TYPE", Integer.toString(object.getThemeType()));
            attr.put("RESPONCE_TYPE", Integer.toString(((KeyData)object).getResponseType()));
            attr.put("FUN_TYPE", Integer.toString(((KeyData)object).getFunctionType()));
            return attr;
        }
        return new TreeMap<String, String>();
    }

    @Override
    public String toIniString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toIniString());
        sb.append(this.mSubKeyDataSerializer.toIniString());
        return sb.toString();
    }

    @Override
    public boolean isExist(BaseData data) {
        return this.mProps.containsKey(data.getTag());
    }

    private Object getReflectField(KeyData object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getTag(BaseData data) {
        return data.getTag();
    }
}

