/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.serializer.common;

import com.iflytek.serializer.common.AbstractBaseSerializer;
import com.iflytek.serializer.utils.SerializerUtil;
import com.iflytek.skintool.model.common.ImageData;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.TreeMap;

public class ImageDataSerializer
extends AbstractBaseSerializer<ImageData> {
    @Override
    public TreeMap<String, String> writeto(ImageData object) {
        TreeMap<String, String> attr = new TreeMap<String, String>();
        attr.put("SRC", object.getImageSrcName());
        if (object.getDensity() != 0) {
            attr.put("DENSITY", String.valueOf(object.getDensity()));
        }
        try {
            String[] str;
            Field field = object.getClass().getDeclaredField("mXDivsStr");
            field.setAccessible(true);
            if (field.get(object) != null && (str = (String[])field.get(object)) != null && (str[0].trim() != "0" || str[1].trim() != "0")) {
                attr.put("X_DIVS", SerializerUtil.array2str(Arrays.asList(str), ","));
            }
            field = object.getClass().getDeclaredField("mYDivsStr");
            field.setAccessible(true);
            if (field.get(object) != null && (str = (String[])field.get(object)) != null && (str[0].trim() != "0" || str[1].trim() != "0")) {
                attr.put("Y_DIVS", SerializerUtil.array2str(Arrays.asList(str), ","));
            }
            if (object.getAlpha() != 255) {
                attr.put("ALPHA", String.valueOf(object.getAlpha()));
            }
            if (object.getType() != -1) {
                attr.put("IMG_TYPE", Integer.toString(object.getType()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attr;
    }

    @Override
    public String getTag(ImageData data) {
        return "Image_" + this.mProps.size();
    }
}

