// Docu : http://wiki.moxiecode.com/index.php/TinyMCE:Create_plugin/3.x#Creating_your_own_plugins

(function() {
	// Load plugin specific language pack
	tinymce.PluginManager.requireLangPack('cuvideo');
	 
	tinymce.create('tinymce.plugins.cuvideo', {
		
		init : function(ed, url) {
		// Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');
			ed.addCommand('cuvideo', function() {
				ed.windowManager.open({
					file : url + '/window.php',
					width : 680,
					height : 390,
					inline : 1
				}, {
					plugin_url : url // Plugin absolute URL
				});
			});

			// Register example button
			ed.addButton('cuvideo', {
				title : 'cuvideo',
				cmd : 'cuvideo',
				image : url + '/images/cuvideo.png'
			});
			
			// Add a node change handler, selects the button in the UI when a image is selected
			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('cuvideo', n.nodeName == 'IMG');
			});
		},
		createControl : function(n, cm) {
			return null;
		},
		getInfo : function() {
			return {
					longname  : 'cuvideo',
					author 	  : 'Many drops of make an ocean',
					authorurl : 'http://www.cuplayer.com',
					infourl   : 'http://www.cuplayer.com',
					version   : "2.5 beta"
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('cuvideo', tinymce.plugins.cuvideo);
})();


