<?php

/*

Plugin Name: Smartideo

Plugin URI: http://www.fengziliu.com/

Description: A plugin for WordPress to embed videos. Such as TuDou, QQ Video, Ku6, YouKu, Sohu Video, Wasu Video, Yinyuetai and so on (mainly supporting chinese sites).

Version: 1.0

Author: Fens Liu

Author URI: http://www.fengziliu.com/smartideo-for-wordpress.html

*/



define('SMARTIDEO_VERSION', '1.0');

define('SMARTIDEO_URL', plugins_url('', __FILE__));

define('SMARTIDEO_PATH', dirname( __FILE__ ));



$smartideo = new smartideo();

class smartideo{

    public function __construct(){
        wp_embed_register_handler( 'smartideo_tudou',
            '#https?://(?:www\.)?tudou\.com/(?:programs/view|listplay/(?<list_id>[a-z0-9_=\-]+))/(?<video_id>[a-z0-9_=\-]+)#i',
            array($this, 'smartideo_embed_handler_tudou') );
        
        wp_embed_register_handler( 'smartideo_56',
            '#https?://(?:www\.)?56\.com/[a-z0-9]+/(?:play_album\-aid\-[0-9]+_vid\-(?<video_id1>[a-z0-9_=\-]+)|v_(?<video_id2>[a-z0-9_=\-]+))#i',
            array($this, 'smartideo_embed_handler_56') );
        
        wp_embed_register_handler( 'smartideo_youku',
            '#https?://v\.youku\.com/v_show/id_(?<video_id>[a-z0-9_=\-]+)#i',
            array($this, array($this, 'smartideo_embed_handler_youku')) );
        
        wp_embed_register_handler( 'smartideo_qq',
            '#https?://v\.qq\.com/(?:[a-z0-9/]+)/(?<video_id>[a-z0-9_=\-]+)#i',
            array($this, 'smartideo_embed_handler_qq') );
        
        wp_embed_register_handler( 'smartideo_sohu',
            '#https?://my\.tv\.sohu\.com/us/(?:\d+)/(?<video_id>\d+)#i',
            array($this, 'smartideo_embed_handler_sohu') );
        
        wp_embed_register_handler( 'smartideo_wasu',
            '#https?://www\.wasu\.cn/play/show/id/(?<video_id>\d+)#i',
            array($this, 'smartideo_embed_handler_wasu') );
        
        wp_embed_register_handler( 'smartideo_yinyuetai',
            '#https?://v\.yinyuetai\.com/video/(?<video_id>\d+)#i',
            array($this, 'smartideo_embed_handler_yinyuetai') );
        
        wp_embed_register_handler( 'smartideo_ku6',
            '#https?://v\.ku6\.com/show/(?<video_id>[a-z0-9\-_\.]+).html#i',
            array($this, 'smartideo_embed_handler_ku6') );
    }
    
    public function smartideo_embed_handler_tudou( $matches, $attr, $url, $rawattr ) {
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://www.tudou.com/programs/view/html5embed.action?type=0&code=%1$s" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://www.tudou.com/v/%1$s/&resourceId=0_05_05_99&bid=05/v.swf" type="application/x-shockwave-flash" allowscriptaccess="always" allowfullscreen="true" wmode="opaque" width="480" height="400"></embed>',
                esc_attr( $matches['video_id'] ) );
        }
	return apply_filters( 'embed_tudou', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_56( $matches, $attr, $url, $rawattr ) {
	$matches['video_id'] = $matches['video_id1'] == '' ?
		$matches['video_id2'] : $matches['video_id1'];
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://www.56.com/iframe/%1$s" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://player.56.com/v_%1$s.swf" type="application/x-shockwave-flash" width="480" height="400" allowfullscreen="true" allownetworking="all" allowscriptaccess="always"></embed>',
                esc_attr( $matches['video_id'] ) );
        }
	return apply_filters( 'embed_56', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_youku( $matches, $attr, $url, $rawattr ) {
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://player.youku.com/embed/%1$s" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://player.youku.com/player.php/sid/%1$s/v.swf" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
                esc_attr( $matches['video_id'] ));
        }

	return apply_filters( 'embed_youku', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_qq( $matches, $attr, $url, $rawattr ) {
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://v.qq.com/iframe/player.html?vid=%1$s" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://static.video.qq.com/TPout.swf?vid=%1$s" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
                esc_attr( $matches['video_id'] ));
        }

	return apply_filters( 'embed_qq', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_sohu( $matches, $attr, $url, $rawattr ) {
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://tv.sohu.com/upload/static/share/share_play.html#%1$s_0_0_9001_0" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://share.vrs.sohu.com/my/v.swf&topBar=1&id=%1$s&autoplay=false&xuid=&from=page" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
                esc_attr( $matches['video_id'] ));
        }

	return apply_filters( 'embed_sohu', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_wasu( $matches, $attr, $url, $rawattr ) {
        if(wp_is_mobile()){
            $embed = sprintf(
                '<iframe src="http://www.wasu.cn/Play/iframe/id/%1$s" width="480" height="400" frameborder="0" allowfullscreen="true"></iframe>',
                esc_attr( $matches['video_id'] ) );
        }else{
            $embed = sprintf(
                '<embed src="http://s.wasu.cn/portal/player/20141216/WsPlayer.swf?mode=3&vid=%1$s&auto=0&ad=4228" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
                esc_attr( $matches['video_id'] ));
        }

	return apply_filters( 'embed_wasu', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_yinyuetai( $matches, $attr, $url, $rawattr ) {
        $embed = sprintf(
            '<embed src="http://player.yinyuetai.com/video/player/%1$s/v_0.swf" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
            esc_attr( $matches['video_id'] ));

	return apply_filters( 'embed_yinyuetai', $embed, $matches, $attr, $url, $rawattr );
    }
    
    public function smartideo_embed_handler_ku6( $matches, $attr, $url, $rawattr ) {
        $embed = sprintf(
            '<embed src="http://player.ku6.com/refer/%1$s/v.swf" allowFullScreen="true" quality="high" width="480" height="400" align="middle" allowScriptAccess="always" type="application/x-shockwave-flash"></embed>',
            esc_attr( $matches['video_id'] ));

	return apply_filters( 'embed_ku6', $embed, $matches, $attr, $url, $rawattr );
    }
}
