/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "window.h"
#include "timeline.h"
#include "propDialog.h"
#include "exportDialog.h"
#include "langDialog.h"
#include "timelist.h"
#include "pathDialog.h"
#include "parser.h"
#include "htmDialog.h"

#include <qdockarea.h>
#include <qcanvas.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include <qtable.h>
#include <qlineedit.h>
#include <about.h>
#include <qtranslator.h>
#include <qlistbox.h>
#include <qapplication.h>
#include <qsettings.h>
#include <qdir.h>

#include "menuimages/copy.xpm"
#include "menuimages/cut.xpm"
#include "menuimages/paste.xpm"
#include "menuimages/new.xpm"
#include "menuimages/open.xpm"
#include "menuimages/save.xpm"
#include "menuimages/saveas.xpm"
#include "menuimages/undo.xpm"
#include "menuimages/redo.xpm"
#include "menuimages/print.xpm"
#include "menuimages/export.xpm"
#include "menuimages/help_about.xpm"
#include "menuimages/browser.xpm"
#include "menuimages/php.xpm"
#include "menuimages/htm.xpm"

#include "menuimages/perl.xpm"
#include "menuimages/lang.xpm"
#include "menuimages/path.xpm"
#include "menuimages/exit.xpm"
#include "menuimages/prop.xpm"

#include <iostream>
using namespace std;

Window::Window( int argc, char **argv  ):QMainWindow()
{

  tempDir = tempDir.home().absPath() + "/.qflash";
  frames = 500;
  maxitems = 1000;
  rate = 8;
  h = 400;
  v = 300;
  setCaption( "QFlash" );
  resize(800,640);
  layer = 0;
  currentFrame = 0;
  maxlayer = 0;
  rate = 8;
  h = 400;
  v = 300;
  c = QColor(Qt::white);
  fileurl = "";
  for (int i=0; i<frames; i++)
  {
    Canvas* cantmp = new Canvas(h,v);
    can.append(cantmp);
    cantmp->back->setBrush(c);
  }
  //Canvas* inicial = new Canvas(h,v);
  ed = new Editor(can.at(0), this);
  setCentralWidget(ed);
  undoActionList = new actionList();
  ed->undoActionList = undoActionList;
  
  colorsWindow =  new QDockWindow(QDockWindow::InDock,this );
  colorsWindow->setResizeEnabled(false);
  colorsWindow->setCaption(tr("Color"));
  colorsWindow->setFixedExtentHeight(340);
  colorsWindow->setFixedExtentWidth(120);
  colorsWindow->setMovingEnabled(false); 
  colors = new Colors(colorsWindow,tr("Color"));
  colorsWindow->setWidget(colors);
  addDockWindow( colorsWindow, Qt::Right );

  propWindow =  new QDockWindow(QDockWindow::InDock,this );
  propWindow->setResizeEnabled(false);
  propWindow->setCaption(tr("Properties"));
  propWindow->setFixedExtentHeight(100);
  propWindow->setFixedExtentWidth(width());
  propWindow->setMovingEnabled(false); 
  prop = new Properties(propWindow,"prop");
  propWindow->setWidget(prop);
  addDockWindow( propWindow, Qt::Bottom );


  statusBar = new QStatusBar(this);
  lineEdit = new QLineEdit(statusBar, "led");
  lineEdit->setEnabled(FALSE);

  statusBar->addWidget(lineEdit, 0, 1);
  statusBar->setSizeGripEnabled(FALSE);

  lineLabel = new QLabel(statusBar, "lineLabel");
  lineLabel->setAlignment( Qt::AlignRight );
  lineLabel->setText( tr("Name:") );

  lineEdit->resize( 150, lineEdit->height() );
  lineEdit->move( width() - 155, lineEdit->pos().y());
  lineLabel->resize( 80, 5 );
  lineLabel->move( width() - 245, lineLabel->pos().y() +5 );
  lineLabel->setEnabled(FALSE);

  toolsWindow =  new QDockWindow(QDockWindow::InDock,this );
  toolsWindow->setResizeEnabled(false);
  toolsWindow->setCaption(tr("Tools"));
  toolsWindow->setFixedExtentHeight(660); 
  toolsWindow->setFixedExtentWidth(74);
  toolsWindow->setMovingEnabled(false); 
  tools = new Tools(toolsWindow,"tools");
  toolsWindow->setWidget(tools);
  addDockWindow( toolsWindow, Qt::Left );

  timeWindow =  new QDockWindow(QDockWindow::InDock,this );
  timeWindow->setResizeEnabled(false);
  timeWindow->setCaption(tr("Time line"));
  timeWindow->setFixedExtentHeight(150);
  timeWindow->setFixedExtentWidth(width());
  timeWindow->setMovingEnabled(false); 
  time = new TimeLine(timeWindow,"time");

  timeWindow->setWidget(time);
  addDockWindow( timeWindow, Qt::Top);

  timeWindow->setHorizontalStretchable(true);
  timeWindow->setVerticalStretchable(true);

  
  prop->setTool();
    

    connect( tools->toolButton1, SIGNAL(released()),prop, SLOT(setTool()));
    connect( tools->toolButton2, SIGNAL(released()),prop, SLOT(setTool()));
    connect( tools->toolButton3, SIGNAL(released()),prop, SLOT(setTool()));
    connect( tools->toolButton4, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton5, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton6, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton7, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton8, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton9, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton10, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton11, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton12, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton13, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton14, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton15, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton16, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton17, SIGNAL(released()), prop, SLOT(setTool()));
    connect( tools->toolButton18, SIGNAL(released()), prop, SLOT(setTool()));

    connect( tools->ASButton, SIGNAL(released()), ed, SLOT(addAS()));
    connect( lineEdit, SIGNAL(textChanged ( const QString & )), ed, SLOT(setName(const QString&)));

   
    // actions
    fileNewAction = new QAction( this, "fileNewAction" );
    fileNewAction->setIconSet( QIconSet( QPixmap (( const char** ) new_xpm)));
    fileOpenAction = new QAction( this, "fileOpenAction" );
    fileOpenAction->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));
    fileSaveAction = new QAction( this, "fileSaveAction" );
    fileSaveAction->setIconSet( QIconSet( QPixmap (( const char** ) save_xpm)));
    fileSaveAsAction = new QAction( this, "fileSaveAsAction" );
    fileSaveAsAction->setIconSet( QIconSet( QPixmap (( const char** ) saveas_xpm)));
    fileExportAction = new QAction( this, "fileExportAction" );
    fileExportAction->setIconSet( QIconSet( QPixmap (( const char** ) export_xpm)));
    filePrintAction = new QAction( this, "filePrintAction" );
    filePrintAction->setIconSet( QIconSet( QPixmap (( const char** ) print_xpm)));
    fileExitAction = new QAction( this, "fileExitAction" );
    fileExitAction->setIconSet( QIconSet( QPixmap (( const char** ) exit_xpm)));
    editUndoAction = new QAction( this, "editUndoAction" );
    editUndoAction->setIconSet( QIconSet( QPixmap (( const char** ) undo_xpm)));
    editRedoAction = new QAction( this, "editRedoAction" );
    editRedoAction->setIconSet( QIconSet( QPixmap (( const char** ) redo_xpm)));
    editCutAction = new QAction( this, "editCutAction" );
    editCutAction->setIconSet( QIconSet( QPixmap (( const char** ) cut_xpm)));
    editCopyAction = new QAction( this, "editCopyAction" );
    editCopyAction->setIconSet( QIconSet( QPixmap (( const char** ) copy_xpm)));
    editPasteAction = new QAction( this, "editPasteAction" );
    editPasteAction->setIconSet( QIconSet( QPixmap (( const char** ) paste_xpm)));
    editPropAction = new QAction( this, "editPropAction" );
    editPropAction->setIconSet( QIconSet( QPixmap (( const char** ) prop_xpm)));
    editLangAction = new QAction( this, "editPropAction" );
    editLangAction->setIconSet( QIconSet( QPixmap (( const char** ) lang_xpm)));
    editPathAction = new QAction( this, "editPathAction" );
    editPathAction->setIconSet( QIconSet( QPixmap (( const char** ) path_xpm)));
  
    
    helpContentsAction = new QAction( this, "helpContentsAction" );
    //helpContentsAction->setIconSet( QIconSet( QPixmap (( const char** ) help_contents_xpm)));
    helpIndexAction = new QAction( this, "helpIndexAction" );
    //helpIndexAction->setIconSet( QIconSet( QPixmap (( const char** ) help_index_xpm)));
    helpAboutAction = new QAction( this, "helpAboutAction" );
    helpAboutAction->setIconSet( QIconSet( QPixmap (( const char** ) help_about_xpm)));
    filePreviewAction = new QAction( this, "filePreviewAction" );
    filePreviewAction->setIconSet( QIconSet( QPixmap (( const char** ) browser_xpm)));

    getHtmAction = new QAction( this, "getHtmAction" );
    getHtmAction->setIconSet( QIconSet( QPixmap (( const char** ) htm_xpm)));

    getPhpAction = new QAction( this, "getPhpAction" );
    getPhpAction->setIconSet( QIconSet( QPixmap (( const char** ) php_xpm)));
    getPerlAction = new QAction( this, "getPerlAction" );
    getPerlAction->setIconSet( QIconSet( QPixmap (( const char** ) perl_xpm)));

    // menubar
    
    menuBar = new QMenuBar( this, "menuBar" );

    fileMenu = new QPopupMenu( this );
    fileNewAction->addTo( fileMenu );
    fileOpenAction->addTo( fileMenu );
    fileSaveAction->addTo( fileMenu );
    fileSaveAsAction->addTo( fileMenu );
    fileExportAction->addTo( fileMenu );
    filePreviewAction->addTo( fileMenu );
    getHtmAction->addTo( fileMenu );
    //filePrintAction->addTo( fileMenu );
    fileMenu->insertSeparator();
    fileExitAction->addTo( fileMenu );
    menuBar->insertItem( QString(""), fileMenu, 1 );
    
    editMenu = new QPopupMenu( this );

    //editMenu->insertSeparator();
    //editCutAction->addTo( editMenu );
    //editCopyAction->addTo( editMenu );
    //editPasteAction->addTo( editMenu );
    getPhpAction->addTo( editMenu );
    getPerlAction->addTo( editMenu );
    editMenu->insertSeparator();
    editLangAction->addTo( editMenu );
    editPathAction->addTo( editMenu );
    editPropAction->addTo( editMenu );
//     editMenu->insertSeparator();
//     editUndoAction->addTo( editMenu );
//     editRedoAction->addTo( editMenu );
    menuBar->insertItem( QString(""), editMenu, 2 );

    helpMenu = new QPopupMenu( this );
    //helpContentsAction->addTo( helpMenu );
    //helpIndexAction->addTo( helpMenu );
    //helpMenu->insertSeparator();
    helpAboutAction->addTo( helpMenu );
    menuBar->insertItem( QString(""), helpMenu, 3 );

    languageChange();

    // signals and slots connections
    connect( fileNewAction, SIGNAL( activated() ), this, SLOT( fileNew() ) );
    connect( fileOpenAction, SIGNAL( activated() ), this, SLOT( fileOpen() ) );
    connect( fileSaveAction, SIGNAL( activated() ), this, SLOT( fileSave() ) );
    connect( fileSaveAsAction, SIGNAL( activated() ), this, SLOT( fileSaveAs() ) );
    connect( fileExportAction, SIGNAL( activated() ), this, SLOT( swf() ) );
    connect( filePreviewAction, SIGNAL( activated() ), this, SLOT( filePreview() ) );
    connect( getHtmAction, SIGNAL( activated() ), this, SLOT( getHtm() ) );
    connect( filePrintAction, SIGNAL( activated() ), this, SLOT( filePrint() ) );
    connect( fileExitAction, SIGNAL( activated() ), this, SLOT( fileExit() ) );
    connect( editUndoAction, SIGNAL( activated() ), this, SLOT( editUndo() ) );
    connect( editRedoAction, SIGNAL( activated() ), this, SLOT( editRedo() ) );
    connect( editCutAction, SIGNAL( activated() ), this, SLOT( editCut() ) );
    connect( editCopyAction, SIGNAL( activated() ), this, SLOT( editCopy() ) );
    connect( editPasteAction, SIGNAL( activated() ), this, SLOT( editPaste() ) );

    connect( getPhpAction, SIGNAL( activated() ), this, SLOT( getPhp() ) );

    connect( getPerlAction, SIGNAL( activated() ), this, SLOT( getPerl() ) );

    connect( editPropAction, SIGNAL( activated() ), this, SLOT( editProp() ) );
    connect( editLangAction, SIGNAL( activated() ), this, SLOT( editLang() ) );
    connect( editPathAction, SIGNAL( activated() ), this, SLOT( editPath() ) );

    connect( helpIndexAction, SIGNAL( activated() ), this, SLOT( helpIndex() ) );
    connect( helpContentsAction, SIGNAL( activated() ), this, SLOT( helpContents() ) );
    connect( helpAboutAction, SIGNAL( activated() ), this, SLOT( helpAbout() ) );

    loadPath();

  if (access(TARPATH, F_OK))
  {
     QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure tar path or you won't be able to save/open files"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
     msg->exec();
  }
  else
  {   
    if ( argc > 1)
      autoOpen( QString( argv[1] ) );
  }


  statusBar->message (tr("Ready"));
}




void Window::languageChange()
{
  
    fileNewAction->setText( trUtf8( "Create an empty file" ) );
    fileNewAction->setMenuText( tr( "&New" ) );
    fileNewAction->setAccel( tr( "Ctrl+N" ) );
    fileOpenAction->setText( tr( "Open an existing project" ) );
    fileOpenAction->setMenuText( tr( "&Open..." ) );
    fileOpenAction->setAccel( tr( "Ctrl+O" ) );
    fileSaveAction->setText( tr( "Save the project" ) );
    fileSaveAction->setMenuText( tr( "&Save" ) );
    fileSaveAction->setAccel( tr( "Ctrl+S" ) );
    fileSaveAsAction->setText( tr( "Save the project as..." ) );
    fileSaveAsAction->setMenuText( tr( "Save &as..." ) );
//     fileSaveAsAction->setAccel( QString::null );
    fileExportAction->setText( tr( "Export the file to flash SWF" ) );
    fileExportAction->setMenuText( tr( "Export" ) );
    fileExportAction->setAccel( tr("Ctrl+E") );
    filePreviewAction->setText( tr( "Open the flash file in your browser" ) );
    filePreviewAction->setMenuText( tr( "Preview" ) );
    filePreviewAction->setAccel( tr("F1") );
    getHtmAction->setText( trUtf8( "Get the html code for your webpage" ) );
    getHtmAction->setMenuText( tr( "Get html code" ) );
    getHtmAction->setAccel( tr( "Ctrl+H" ) );
    filePrintAction->setText( tr( "Print" ) );
    //filePrintAction->setMenuText( tr( "&Print..." ) );
    //filePrintAction->setAccel( tr( "Ctrl+P" ) );
    fileExitAction->setText( tr( "Close QFlash" ) );
    fileExitAction->setMenuText( tr( "&Quit" ) );
    fileExitAction->setAccel( tr("Ctrl+Q") );
    editUndoAction->setText( trUtf8( "Undo the last action" ) );
    editUndoAction->setMenuText( tr( "&Undo" ) );
    editUndoAction->setAccel( tr( "Ctrl+Z" ) );
    editRedoAction->setText( trUtf8( "Redo the last undone action" ) );
    editRedoAction->setMenuText( tr( "&Redo" ) );
    editRedoAction->setAccel( tr( "Ctrl+Shift+Z") );
    editCutAction->setText( tr( "Cut the selected files" ) );
    editCutAction->setMenuText( tr( "Cu&t" ) );
    editCutAction->setAccel( tr( "Ctrl+X" ) );
    editCopyAction->setText( tr( "Copy the selected files" ) );
    editCopyAction->setMenuText( tr( "&Copy" ) );
    editCopyAction->setAccel( tr( "Ctrl+C" ) );
    editPasteAction->setText( tr( "Paste the clipboard items" ) );
    editPasteAction->setMenuText( tr( "&Paste" ) );
    editPasteAction->setAccel( tr( "Ctrl+V" ) );
    getPhpAction->setText( trUtf8( "Convert the project to PHP Ming code" ) );
    getPhpAction->setMenuText( tr( "Convert to PHP" ) );
    getPhpAction->setAccel( tr( "F3" ) );
    
    getPerlAction->setText( trUtf8( "Convert the project to Perl Ming code" ) );
    getPerlAction->setMenuText( tr( "Convert to Perl" ) );
    getPerlAction->setAccel( tr( "F4" ) );
    
    editPropAction->setText( tr( "Picture properties" ) );
    editPropAction->setMenuText( tr( "&Properties" ) );
    editPropAction->setAccel( tr( "Ctrl+P" ) );
    
    editLangAction->setText( tr( "Change the language" ) );
    editLangAction->setMenuText( tr( "Change &language" ) );
    editLangAction->setAccel( tr( "Ctrl+L" ) );

    editPathAction->setText( tr( "Change the paths of the files QFlash uses" ) );
    editPathAction->setMenuText( tr( "Change paths" ) );
    editPathAction->setAccel( tr( "Ctrl+R" ) );

    helpContentsAction->setText( tr( "Contents" ) );
    //helpContentsAction->setMenuText( tr( "&Contents..." ) );
    //helpContentsAction->setAccel( QString::null );
    helpIndexAction->setText( tr( "Index" ) );
    //helpIndexAction->setMenuText( tr( "&Index..." ) );
    //helpIndexAction->setAccel( QString::null );
    helpAboutAction->setText( trUtf8( "Do you have any doubt about QFlash?" ) );
    helpAboutAction->setMenuText( tr( "&About QFlash" ) );
    helpAboutAction->setAccel( QString::null );

    menuBar->findItem(1)->setText( tr( "File" ) );
    menuBar->findItem(2)->setText( tr( "Edit" ) );
    menuBar->findItem(3)->setText( tr( "Help" ) );

}



void Window::updateFrame(int templayer, int frame)
{
  if ( time->list->childCount() >0  )
  {
    ed->hideNodes();
    TableItem* t = (TableItem*) time->table->item(templayer,frame);
    if (( t->start /*|| (t->effect && t->end) || (t->morphing && t->end )*/ ) && frame <= frames && templayer <= maxlayer)
    {
       if ( can.at(frame) != NULL)
         ed->setCanvas( can.at(frame) );
       ed->hideNodes();
       update();
       currentFrame = frame;
       layer = maxlayer - templayer;
    }
  }
}

void Window::update()
{
    QResizeEvent* e;
    resizeEvent(e);
}


void Window::insertLayer()
{
  maxlayer++;
}

void Window::removeLayer(int index)
{
  ed->hideNodes();
  for (int b = 0; b<frames; b++)
    {
      TableItem* t = (TableItem*) time->table->item(index,b);
      if (t->start)
        {
          clearFrame( index, b);
        }
    }

  //sets Z to new layers

  for (int a = 0; a < frames ; a++)
  {

      QCanvasItemList l = can.at(a)->allItems();
      QCanvasItem* moving;
      for ( QCanvasItemList::Iterator it = l.begin() ; it != l.end(); ++it)
      {
        moving = (QCanvasItem*) *it;
        if ( ( (int) (moving->z()/3000)> (maxlayer - index) ) && (moving->rtti() != 6666) && (moving->rtti() != 666) && (moving->rtti() != 6969) && (moving->rtti() != 668))
          moving->setZ(moving->z()-3000);
      }
  }
  maxlayer--;
}
 
void Window::clearFrame(int templayer, int frame)
{
  ed->hideNodes();
  ed->choosen = NULL;
  ed->moving = NULL;
  QCanvasItemList l = can.at(frame)->allItems(); 
  
  QCanvasItem* moving;
  for ( QCanvasItemList::Iterator it = l.begin() ; it != l.end(); ++it)
  {
     moving = (QCanvasItem*) *it;
     if ( ( (int) (moving->z()/3000) == (maxlayer - templayer ) ) && (moving->rtti() != 6666) && (moving->rtti() != 666) && (moving->rtti() != 6969) && (moving->rtti() != 668))
     {
       moving->hide();       
       if (moving->rtti () != 88 && moving->rtti () != 87 &&  moving->rtti () != 89)
       {
         delete moving; 
       }
       else
       {
           if (moving->rtti() == 89)
           {
               Regular* tmpreg = (Regular*) moving;
               tmpreg->view = 0;
           }     
           if (moving->rtti () == 87)
           {
//                PencilItem* tmppenc = (PencilItem*) moving;
//                tmppenc->view = 0;
           }
           if (moving->rtti () == 88)
           {
               BrushItem* tmpbrush = (BrushItem*) moving;
               tmpbrush->view = 0;
           }
        }
      }
  }
  ed->canvas()->setAllChanged();
  ed->canvas()->update();

}


void Window::resizeEvent ( QResizeEvent * )
 {


   //resizes the canvas (in editor)

   int c = width() - colorsWindow->width() - toolsWindow->width() ;
   if (c< h+300) c = h +300;
   int d = height() - propWindow->height() - timeWindow->height() ;
   if (d< v+300) d = v +300;

   ed->canvas()->resize(c, d); 
   ed->canvas()->update();


   //to resolve a qlistview bug?

   timeListItem* tmp = (timeListItem*) time->list->selectedItem();
   tmp->setHHeight(20)  ;


   //resizes timeruler

   int e = width() - 105 - 30;
   time->scroll->resize(   e   , 130 );
   time->tvs->move(width()-30, 3);


   //resizes items in statusBar

   lineEdit->resize( 150, lineEdit->height() );
   lineEdit->move( width() - 155, lineEdit->pos().y());

   lineLabel->resize( 80, 20 );
   lineLabel->move( width() - 245, lineLabel->pos().y());

   repaint();

 }



void Window::copyFrame(int templayer, int frame, int layer2, int frame2)
{

    templayer = maxlayer - templayer;
    layer2 = maxlayer - layer2;

    QCanvasItemList l = ed->filterSelection( can.at(frame)->allItems() ); 
    if (l.isEmpty()) return;

    QCanvasItem* moving;
    for ( QCanvasItemList::Iterator it = l.begin(); it != l.end(); ++it)
    {
       moving = (QCanvasItem*) *it;
       QCanvasItem* temp;

       if ( ((int) (moving->z()/3000) == templayer) && ed->isValid(moving) )
       {
//            cout << moving->z() << " " << templayer << " " << (int) (moving->z()/3000) << (moving->z()/3000) << endl;

           if (ed->getTextBox(moving) != NULL)
           {
             TextBox* textb = new TextBox(ed->getTextBox(moving), can.at(frame2) );
             textb->setZ( temp->z() + (layer2 - templayer)*3000);

           }
           else
           {
               if (ed->getGroup(moving) != NULL)
               {
                  ed->buffered = moving;
                  ed->cutt = 0;
//                   ed->cenx = moving->x();//ed->cenx;
//                   ed->ceny = moving->y();//ed->ceny;
                  ed->paste(1);
               }
               else
               {
                  temp = copyItem(moving, can.at(frame2));
                  temp->setZ( temp->z() + (layer2 - templayer)*3000);
               } 
          }
       }
//        else cout << moving->z() << " " << layer2 <<  " " << templayer << " " << (int) (moving->z()/3000) << (moving->z()/3000) << endl;
    }
    ed->canvas()->update();

}

QCanvasItemList Window::copyFrameForButton(QCanvas* canvas1, QCanvas* canvas2)
{
    QCanvasItemList createdItems;
    QCanvasItemList l = ed->filterSelection( canvas1->allItems() ); 
    if (l.isEmpty()) return l;

    QCanvasItem* moving;
    for ( QCanvasItemList::Iterator it = l.begin(); it != l.end(); ++it)
    {
       moving = (QCanvasItem*) *it;
       QCanvasItem* temp;
       temp = copyItem(moving, canvas2);
       createdItems.append(temp);
    }
    ed->canvas()->update();

    return createdItems;
}



void Window::fileNew(bool warn)
{
  if (!warn)
  {
    QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("You will lose the work you haven't saved yet.\nDo you want to continue?"), QMessageBox::Warning, QMessageBox::Yes | QMessageBox::Default, QMessageBox::No  | QMessageBox::Escape, 0);
    if ( msg->exec() == QMessageBox::No )
      return;
  }

  time->hide();
  delete time;
  time = new TimeLine(timeWindow,"time");
  timeWindow->setWidget(time);
  time->show();

  layer = 0;
  maxlayer = 0;
  rate = 8;
  h = 400;
  v = 300;
  c = QColor(Qt::white);
  fileurl = "";

  ed->hide();
  delete ed;
  can.clear();

  for (int i=0; i<frames; i++)
  {
    Canvas* cantmp = new Canvas(h,v);
    can.append(cantmp);
    cantmp->back->setBrush(c);
  }
  
  ed = new Editor(can.at(0), this);
  setCentralWidget(ed);
  ed->show();
}

void Window::autoOpen(QString file)
{
   fileurl = QUrl(file);
   if (!access(file, F_OK))
   {
     xml2canvas handler(this);
     system( TARPATH + " -xzf "+ fileurl.toString(0,0)+" -C "+ tempDir.absPath());
     QFile xmlFile( tempDir.absPath()+"/qflashtmp/temp.xml" );
     QXmlInputSource source( &xmlFile );
     QXmlSimpleReader reader;
     reader.setContentHandler( &handler );
     reader.parse( source );
   }
   else
   {
    QMessageBox* msg = new QMessageBox ( tr("Error"), tr("A problem has occurred"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
    msg->exec();


   }
}

void Window::fileOpen()
{
  QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("You will lose the work you haven't saved yet.\nDo you want to continue?"), QMessageBox::Warning, QMessageBox::Yes | QMessageBox::Default, QMessageBox::No  | QMessageBox::Escape, 0);
  if ( msg->exec() == QMessageBox::No )
    return;

 if (!access(TARPATH, F_OK))
 {
   xml2canvas handler(this);
   fileurl =  QFileDialog::getOpenFileName( "", "QFlash Projects (*.qfp)", this, "open file dialog", tr("Choose a file"));
   if (fileurl.toString(0,0) != "")
   { 
     system( TARPATH + " -xzf "+ fileurl.toString(0,0)+" -C "+ tempDir.absPath());
     QUrl tmp = fileurl;
     fileNew(1);
     fileurl = tmp;
     QFile xmlFile( tempDir.absPath()+"/qflashtmp/temp.xml" );
     QXmlInputSource source( &xmlFile );
     QXmlSimpleReader reader;
     reader.setContentHandler( &handler );
     reader.parse( source );
   }
  }
  else
  {
    QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure tar path or you won't be able to save/open files"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
    msg->exec();
  }
}

bool Window::fileSave()
{
 
  if (!access(TARPATH, F_OK))
  {
     if (fileurl.toString(0,0) == (const QString&) "")
       return fileSaveAs();
     else
     {
       QString s = xmlSave();
       QFile file( tempDir.absPath()+"/qflashtmp/temp.xml" );
       if ( file.open( IO_WriteOnly ) ) 
       {
         QTextStream stream( &file );
         stream << s << "\n";
         file.close();
       }

       system( TARPATH + " -C "+tempDir.absPath()+"/ -czf " +tempDir.absPath()+ "/qflashtmp/temp.tar.gz "+imageList+" qflashtmp/temp.xml");
       system("cp " +tempDir.absPath()+ "/qflashtmp/temp.tar.gz \""+fileurl.toString(0,0)+"\"");
    }
   }
   else
   {
     QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure tar path or you won't be able to save/open files"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
     msg->exec();
     return 0;
   }

  return 1;
}





bool Window::fileSaveAs()
{
  if (!access(TARPATH, F_OK))
  {
    fileurl = QFileDialog::getSaveFileName(
                    "",
                    "QFlash Project (*.qfp)",
                    this,
                    "save file dialog",
                    tr("Choose a file"));

    if (fileurl.toString(0,0) == "")
        return 0;

    if (!fileurl.toString(0,0).endsWith(".qfp"))
       fileurl = QUrl( fileurl.path() + ".qfp" );


    if (!access(fileurl.path(), F_OK))
    {
      QMessageBox* msg = new QMessageBox ( tr("Warning"), tr("This file already exists. Do you want to overwrite it?"), QMessageBox::Warning, QMessageBox::Yes, QMessageBox::No | QMessageBox::Default,  0);
      if ( msg->exec() == QMessageBox::No )
      {
        fileurl = "";
        return 0;
      }
    }
    QString s = xmlSave();
    QFile file( tempDir.absPath()+"/qflashtmp/temp.xml" );
    if ( file.open( IO_WriteOnly ) )
    {
      QTextStream stream( &file );
      stream << s << "\n";
      file.close();
    } 
    system( TARPATH + " -C "+tempDir.absPath()+"/ -czf " +tempDir.absPath()+ "/qflashtmp/temp.tar.gz "+imageList+" qflashtmp/temp.xml");
    system("cp " +tempDir.absPath()+ "/qflashtmp/temp.tar.gz \""+fileurl.toString(0,0)+"\"");

  }
  else
  {
      QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure tar path or you won't be able to save/open files"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
      msg->exec();
      return 0;
  }

  return 1;

}


void Window::filePrint()
{
    qWarning( "Window::filePrint(): Not implemented yet" );
}

void Window::fileExit()
{
    QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("You will lose the work you haven't saved yet.\nDo you want to continue?"), QMessageBox::Warning, QMessageBox::Yes | QMessageBox::Default, QMessageBox::No  | QMessageBox::Escape, 0);
    if ( msg->exec() == QMessageBox::No )
      return;

    system ("rm -rf " +tempDir.absPath()+ "/qflashtmp");
    exit(0);
}

void Window::editUndo()
{
 //qWarning( "Window::editRedo(): Not implemented yet" );

  undoActionList->undo();
}

void Window::editRedo()
{
    qWarning( "Window::editRedo(): Not implemented yet" );
}

void Window::editCut()
{
    qWarning( "Window::editCut(): Not implemented yet" );
}

void Window::editCopy()
{
    qWarning( "Window::editCopy(): Not implemented yet" );
}

void Window::editPaste()
{
    qWarning( "Window::editPaste(): Not implemented yet" );
}


void Window::helpIndex()
{
    qWarning( "Window::helpIndex(): Not implemented yet" );
}

void Window::helpContents()
{
    qWarning( "Window::helpContents(): Not implemented yet" );
}

void Window::helpAbout()
{

  About *dlg = new About();
  dlg->exec();

}


int Window::getTool()
{
  if (tools->toolButton1->isOn()) return 1;
  if (tools->toolButton2->isOn()) return 2;
  if (tools->toolButton3->isOn()) return 3;
  if (tools->toolButton4->isOn()) return 4;
  if (tools->toolButton5->isOn()) return 5;
  if (tools->toolButton6->isOn()) return 6;
  if (tools->toolButton7->isOn()) return 7; 
  if (tools->toolButton8->isOn()) return 8;
  if (tools->toolButton9->isOn()) return 9;
  if (tools->toolButton10->isOn()) return 10;
  if (tools->toolButton11->isOn()) return 11;
  if (tools->toolButton12->isOn()) return 12;
  if (tools->toolButton13->isOn()) return 13;
  if (tools->toolButton14->isOn()) return 14;
  if (tools->toolButton15->isOn()) return 15;
  if (tools->toolButton16->isOn()) return 16;
  if (tools->toolButton17->isOn()) return 17;
  if (tools->toolButton18->isOn()) return 18;
  return 0;
}

QString Window::xmlSave()
{
  imageList = "";
  QString s;
  if (fileswf == "" )
    fileswf = fileurl.toString(0,0).copy().replace(".qfp", ".swf");
  s = "<animation movie=\"" +fileswf+ "\" rate=\"" +QString::number(rate)+ "\" mp3=\"" +filemp3+ "\" width=\"" +QString::number(h)+ "\" height=\"" +QString::number(v)+ "\" layers=\"" +QString::number(maxlayer)+ "\" color=\"" +c.name()+ "\" frames=\"" + QString::number(time->table->frameCount()) + "\">\n";
  
  
  TableItem* ti;
  TableItem* ta;

  for (int i =0; i < time->table->frameCount()+1; i++)
  {
    for (int a = maxlayer; a >= 0 ; a--)
    {
      ti =(TableItem*) time->table->item(a,i);
      if (i>0)
        ta =(TableItem*) time->table->item(a,i-1);
      int end = 0;
      int as = 0;
      if (i>0)
          if (ta->end && (!ta->start || !ti->ready)) end = 1;
      QString actionScript = (ed->animAction.actions.at(i))->latin1();
      if(actionScript != "")
         as = 1;

      if (ti->start || end || ( as && a==0)) //save all the frame in the xml
      {
            s += "\t<frame ";
            if (end)
              s += "end=\"1\" ";
            if ((as && a==0) && !end && !ti->start)
              s += "asOnly=\"1\" ";
            if (as && a==0)
            s += "code=\"" + actionScript.replace( "\"", "&quot;" ).replace( "\n", "&new;" ) + "\" ";
            s += "layer=\"" + QString::number(maxlayer - a) + "\" number=\"" + QString::number(i)+ "\">\n";


            s += can.at(i)->xml(maxlayer - a, ed); //it saves all the items
            imageList += can.at(i)->imageList();

            s += "\t</frame>\n";
      }
      
      
      
    }
  
  }
  s+= "</animation>";
  return s;
}


void Window::setFrames(int)
{
}

QCanvasItem* Window::copyItem(QCanvasItem* tempItem, QCanvas* canvas)
{
    switch (tempItem->rtti())
    {
       case 6666:
       {
            break;
       }
       case 666:
       {
            break;
       }
       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* item = new RectItem( (RectItem*) tempItem, canvas);
            return item;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* item = new OvalItem( (OvalItem*) tempItem, canvas);
            return item;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* item = new LineItem( (LineItem*) tempItem, canvas);
            return item;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* item = new Polygon( (Polygon*) tempItem, canvas);
            return item;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* item = new CanvasTextItem( (CanvasTextItem*) tempItem, canvas);
            return item;
       }
       case 86:
       {
            ImageItem* item = new ImageItem( (ImageItem*) tempItem, canvas);
            return item;
       }
       case 87:
       {
//             PencilItem* item = new PencilItem( (PencilItem*) tempItem, canvas );
//             return item;
       }
       case 88:
       {
            BrushItem* item = new BrushItem( (BrushItem*) tempItem, canvas );
            return item;
       }
       case 89:
       {
            Regular* item = new Regular( (Regular*) tempItem, canvas);
            return item;
       }

    }
  return NULL;
}


void Window::editProp()
{
   Dialog *dlg = new Dialog(c, frames, h, v );
   if ( dlg->exec() == QDialog::Accepted ) 
   {
      c = dlg->c;
      //if (frames != dlg->spinBox1->value()) setFrames(dlg->spinBox1->value());
      h = dlg->spinBox2->value();
      v = dlg->spinBox3->value();
    }
    delete dlg;
    ed->updateAll();
    QResizeEvent* e;
    resizeEvent(e);
}

void Window::editLang()
{
   
   if (access(tempDir.absPath()+"/translations/", F_OK))
       system( "mkdir "+tempDir.absPath()+"/translations/" );
   
   langDialog *dlg = new langDialog( );
   if ( dlg->exec() == QDialog::Accepted ) 
   {
     if (!dlg->status) //lang from list
     {
       if (dlg->listLang->currentText() == "Spanish") lang = "/usr/share/qflash/translations/es.qm";
       if (dlg->listLang->currentText() == "Catalan" )  lang = "/usr/share/qflash/translations/ca.qm";
     }
     else
     {
       system("cp \""+dlg->lineFile->text() +"\" "+tempDir.absPath()+"/translations/" );
       lang = tempDir.absPath()+"/translations/"+dlg->lang;
     }
   saveLang();
   }
delete dlg;
}

void Window::editPath()
{
  pathDialog *dlg = new pathDialog( BROWPATH,  TARPATH, UTILSPATH, KSVGPATH, TTF2FFTPATH );
  if ( dlg->exec() == QDialog::Accepted ) 
  {
    BROWPATH = dlg->lineEdit1->text();
    TARPATH = dlg->lineEdit2->text();
    UTILSPATH = dlg->lineEdit3->text();
    KSVGPATH = dlg->lineEdit4->text();
    TTF2FFTPATH = dlg->lineEdit5->text();

    if (!UTILSPATH.endsWith("/"))
       UTILSPATH += "/";
    savePath();
  }
  delete dlg;
}

void Window::saveLang()
{

   FILE *fp;
   fp = fopen(tempDir.absPath()+"/lang.cnf", "w");
   fprintf(fp,lang);
   fclose(fp);
   QMessageBox* msg = new QMessageBox ( tr("Warning"), tr("You must restart QFlash to apply the changes"), QMessageBox::Warning, QMessageBox::Ok | QMessageBox::Default, 0, 0);
  msg->exec();
}

void Window::savePath()
{

  FILE *fp;
  fp = fopen( tempDir.absPath()+"/path.cnf", "w");
  if ( BROWPATH == "" ) 
     fprintf(fp, "none");
  else
     fprintf(fp,BROWPATH);
  fprintf(fp,"\n");
  if ( TARPATH == "" ) 
     fprintf(fp, "none");
  else 
     fprintf(fp,TARPATH);
  fprintf(fp,"\n");
  if ( UTILSPATH == "" ) 
     fprintf(fp, "none");
  else
     fprintf(fp,UTILSPATH);
     fprintf(fp,"\n");
  if ( KSVGPATH == "" ) 
     fprintf(fp, "none");
  else
     fprintf(fp,KSVGPATH);
  fprintf(fp,"\n");
  if ( TTF2FFTPATH == "" ) 
     fprintf(fp, "none");
  else
     fprintf(fp,TTF2FFTPATH);
  fprintf(fp,"\n");
  fclose(fp);

}

void Window::loadPath()
{
 
 QFile file(tempDir.absPath()+"/path.cnf");

 if (!file.open( IO_ReadOnly ))
 {
   if ( !tempDir.exists() )
     system("mkdir "+ tempDir.absPath() );
   
   BROWPATH = "/usr/bin/firefox";
   TARPATH = "/bin/tar";
   KSVGPATH = "/usr/bin/ksvgtopng";
   UTILSPATH = "/usr/lib/libming/bin/";
   TTF2FFTPATH = "/usr/lib/libming/bin/";
   savePath();
 }
 else
 { 
   QTextStream stream( &file );
   stream >> BROWPATH;
   stream >> TARPATH;
   stream >> UTILSPATH;
   stream >> KSVGPATH;
   stream >> TTF2FFTPATH;
   file.close();
 }

}


int Window::setSwfProp()
{
  ExpDialog *dlg = new ExpDialog(time->table->frameCount(), rate, filemp3, fileswf);
  if ( dlg->exec() == QDialog::Accepted ) 
  {
    rate = dlg->spinRate->value();
    fileswf = dlg->lineSwf->text();
    filemp3 = dlg->lineMp3->text();
    if (!fileSave()) return 0;
    delete dlg;
    return 1;
  }
  delete dlg;
  return 0;
}

int Window::swf()
{ 
   
    if (fileurl.toString(0,0)  == (const QString&) "")
    {
      QMessageBox* msg = new QMessageBox ( tr("Warning"), tr("You must save your work"), QMessageBox::Warning, QMessageBox::Ok | QMessageBox::Default, 0, 0);
      msg->exec();
    }
    if (!fileSave()) return 0;

    if (fileurl.toString(0,0)  == (const QString&) "") return 0;

    if (setSwfProp())
    {
      xml2swf handler(this);
      QFile xmlFile( tempDir.absPath()+"/qflashtmp/temp.xml" );
      QXmlInputSource source( &xmlFile );
      QXmlSimpleReader reader;
      reader.setContentHandler( &handler );
      reader.parse( source );
      return 1;
    }
    else return 0;
}

void Window::avisoParser()
{
    QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure mingutils path before creating swf with images which contain transparencies"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
    msg->exec();
}

void Window::avisoFonts()
{
  QMessageBox* msg = new QMessageBox ( tr("Warning"), trUtf8("Some fonts of the file can't be found. Default font will be load instead"), QMessageBox::Warning, QMessageBox::Ok | QMessageBox::Default, 0, 0);
   msg->exec();
}

void Window::filePreview()
{
  if (access(tempDir.absPath()+"/preview/", F_OK))
    system("mkdir "+tempDir.absPath()+"/preview");

  if (access(BROWPATH, F_OK))
  {
    QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure your browser path"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
    msg->exec();
  }
  else
  {
    if (swf())
    {
       system("cp -f "+fileswf+" "+tempDir.absPath()+"/preview/flash.swf");
       system("cp -f /usr/share/qflash/logo.png "+tempDir.absPath()+"/preview/");

       FILE *fp;
       fp = fopen(tempDir.absPath()+"/preview/flash.html", "w");
       fprintf( fp, "<html>\n<head>\n</head>\n<body bgcolor=\"#ecac00\">\n<center>\n<br>\n<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\" id=\"home\" height=\""+QString::number(v)+"\" width=\""+QString::number(h)+"\">\n<param name=\"movie\" value=\"flash.swf\"><param name=\"quality\" value=\"high\">\n" );
       fprintf( fp, "<param name=\"loop\" value=\"false\">\n" ); 
       fprintf( fp, "<embed src=\"flash.swf\" quality=\"high\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" height=\""+QString::number(v)+"\" width=\""+QString::number(h)+"\">\n</embed>\n </object>\n<br><br><br>\n<img src=\"logo.png\">\n<h2>"+ tr("Thanks for using QFlash!")+"</h2>\n"+tr("Visit us in")+" <a href=\"http://qflash.sourceforge.net\">Sourceforge.net</a>\n</center>\n</body>\n</html>" );

      fclose(fp);

      system(BROWPATH + " "+tempDir.absPath()+"/preview/flash.html &");
    }
 }

}

void Window::getPhp()
{
 if (access(UTILSPATH + "swftophp", F_OK))
 {
   QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure mingutils path"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
   msg->exec();
 }
 else
 {
   if (swf())
   {
     QUrl phpUrl = QFileDialog::getSaveFileName( "", "Php file ( *.php )", this, "save file dialog", tr("Choose a file"));
     if (phpUrl.toString(0,0) != "")
     { 
       QString ext = "";
       if ( !phpUrl.toString(0,0).endsWith(".php") ) ext = ".php";
       system( UTILSPATH + "swftophp " + fileswf + " > " + phpUrl.toString(0,0) + ext); 
     }
   }
 }
}

void Window::getHtm()
{
  htmDialog *dlg = new htmDialog();
  dlg->textEdit1->setText(  "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"\nhttp://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\" id=\"home\" height=\""+QString::number(v)+"\" width=\""+QString::number(h)+"\">\n<param name=\"movie\" value=\"FLASH.swf\">\n<param name=\"quality\" value=\"high\">\n<param name=\"loop\" value=\"false\">\n<embed src=\"flash.swf\" quality=\"high\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" height=\""+QString::number(v)+"\" width=\""+QString::number(h)+"\">\n</embed>\n</object>\n" );
  dlg->exec();
}


void Window::getPerl()
{
  if (access(UTILSPATH + "swftoperl", F_OK))
  {
    QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure mingutils path"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
    msg->exec();
  }
  else
  {
    if (swf())
    {
      QUrl perlUrl = QFileDialog::getSaveFileName( "", "Perl files (*.pl)", this, "open file dialog", tr("Choose a file"));
      if (perlUrl.toString(0,0) != "")
      { 
        QString ext = "";
        if ( !perlUrl.toString(0,0).endsWith(".pl") ) ext = ".pl";
        system( UTILSPATH + "swftoperl " + fileswf + " > " + perlUrl.toString(0,0) + ext ); 
      }
    }
  }
}

void Window::changeAdjusts(int x, int y)
{
  for (int i=0; i<frames; i++)
  {
    Canvas* cantmp = can.at(i);
    cantmp->back->adjust->move(x,y);
  }

}


void Window::startButtonEdit(bool on)
{
  //on == 1 when button is editing, on == 0 when you stop editing a button

  time->table->setEnabled(!on);
  time->list->setEnabled(!on);
  time->ruler->setEnabled(!on);

  prop->buttonUp->setEnabled(on);
  prop->buttonOver->setEnabled(on);
  prop->buttonDown->setEnabled(on);
  prop->buttonBack->setEnabled(on);
  prop->buttonCancel->setEnabled(on);
  prop->buttonAS->setEnabled(on);

  tools->toolButton15->setEnabled(!on);
  tools->toolButton4->setEnabled(!on);
  ed->editingButton = on;

  prop->copiable(on);

  if (on == 1)
    prop->setButtonMessage();

}

void Window::updateStatusBar()
{
  QString name = ed->getName(ed->choosen);

  if (name != NULL && !ed->editingButton)
  {
    lineEdit->setEnabled(TRUE);
    lineLabel->setEnabled(TRUE);
    lineEdit->setText(name);
  }
  else
  {
    lineEdit->setEnabled(FALSE);
    lineLabel->setEnabled(FALSE);

  }


}

void Window::closeEvent( QCloseEvent* )
{
  fileExit();
}


